/*
 * Decompiled with CFR 0.152.
 */
package bot.box.appusage.handler;

import bot.box.appusage.contract.TimelineContracts;

public class TimelineGenerator {
    private TimelineContracts.Presenter mPresenter;
    private String mPackageName;

    TimelineGenerator(TimelineContracts.Presenter mPresenter) {
        this.mPresenter = mPresenter;
    }

    public void fetchForToday() {
        if (this.mPackageName == null) {
            throw new NullPointerException("Must provide a legit package name i.e. Monitor.scan().generateTimeline().whichPackage().fetchFor()");
        }
        if (this.mPackageName.trim().length() == 0) {
            throw new IllegalArgumentException("Must provide a legit package name i.e. Monitor.scan().generateTimeline().whichPackage().fetchFor()");
        }
        this.fetchFor(0, this.mPackageName);
    }

    private void fetchFor(int duration, String mPackage) {
        if (this.mPresenter == null) {
            throw new IllegalStateException("Your view must implement TimelineContracts.View");
        }
        this.mPresenter.generateTimeline(duration, mPackage);
    }

    public TimelineGenerator whichPackage(String mPackage) {
        if (mPackage.trim().length() == 0) {
            throw new IllegalArgumentException("Package Name must not be empty.");
        }
        this.mPackageName = mPackage;
        return this;
    }
}

