/*
 * Decompiled with CFR 0.152.
 */
package bot.box.appusage.delegate;

import android.content.Context;
import android.os.AsyncTask;
import bot.box.appusage.BotMonitor;
import bot.box.appusage.datamanager.DataManager;
import bot.box.appusage.model.TimeLine;
import com.google.common.collect.Lists;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

public class FetchPackageTimelineDelegate
extends AsyncTask<String, Void, List<List<TimeLine>>> {
    private WeakReference<Context> mContext = new WeakReference<Context>(BotMonitor.getMonitorContext());
    private OnTimeLineCallback mCallback;
    private int duration;

    public FetchPackageTimelineDelegate(OnTimeLineCallback l, int offSet) {
        this.mCallback = l;
        this.duration = offSet;
    }

    protected List<List<TimeLine>> doInBackground(String ... strings) {
        List<TimeLine> targetAppTimeline = DataManager.getInstance().getTargetAppTimeline((Context)this.mContext.get(), strings[0], this.duration);
        ArrayList<TimeLine> newList = new ArrayList<TimeLine>();
        for (TimeLine item : targetAppTimeline) {
            if (item.mEventType == 7 || item.mEventType == 0) continue;
            if (item.mEventType == 2) {
                TimeLine newItem = item.copy();
                newItem.mEventType = -1;
                newList.add(newItem);
            }
            newList.add(item);
        }
        return Lists.partition(newList, (int)3);
    }

    protected void onPostExecute(List<List<TimeLine>> appData) {
        this.mCallback.onTimeLineFetched(appData);
    }

    public static interface OnTimeLineCallback {
        public void onTimeLineFetched(List<List<TimeLine>> var1);
    }
}

