/*
 * Decompiled with CFR 0.152.
 */
package bot.box.appusage.delegate;

import android.os.AsyncTask;
import bot.box.appusage.BotMonitor;
import bot.box.appusage.datamanager.DataManager;
import bot.box.appusage.model.AppData;
import java.util.List;

public class FetchAppUsageDelegate
extends AsyncTask<Integer, Integer, List<AppData>> {
    private AppUsageCallback mListener;

    public FetchAppUsageDelegate(AppUsageCallback l) {
        this.mListener = l;
    }

    protected void onPreExecute() {
        super.onPreExecute();
        this.mListener.onPreExecute();
    }

    protected List<AppData> doInBackground(Integer ... params) {
        return DataManager.getInstance().getUsedApps(BotMonitor.getMonitorContext(), params[0]);
    }

    protected void onPostExecute(List<AppData> aVoid) {
        super.onPostExecute(aVoid);
        long mTotalUsage = 0L;
        for (AppData item : aVoid) {
            if (item.mUsageTime <= 0L) continue;
            mTotalUsage += item.mUsageTime;
            item.mCanOpen = BotMonitor.getMonitorContext().getPackageManager().getLaunchIntentForPackage(item.mPackageName) != null;
        }
        this.mListener.onAppDataFetch(aVoid, mTotalUsage);
    }

    public void executeExecutor(int duration) {
        this.executeOnExecutor(THREAD_POOL_EXECUTOR, new Integer[]{duration});
    }

    public static interface AppUsageCallback {
        public void onPreExecute();

        public void onAppDataFetch(List<AppData> var1, long var2);
    }
}

