/*
 * Decompiled with CFR 0.152.
 */
package bot.box.appusage.datamanager;

import android.annotation.SuppressLint;
import android.app.usage.NetworkStats;
import android.app.usage.NetworkStatsManager;
import android.app.usage.UsageEvents;
import android.app.usage.UsageStatsManager;
import android.content.Context;
import android.content.pm.PackageManager;
import android.net.TrafficStats;
import android.os.Build;
import android.os.RemoteException;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Log;
import androidx.core.app.ActivityCompat;
import bot.box.appusage.model.AppData;
import bot.box.appusage.utils.SortOrder;
import bot.box.appusage.utils.UsageUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class DataManager {
    private static DataManager mInstance;

    public static void init() {
        mInstance = new DataManager();
    }

    public static DataManager getInstance() {
        return mInstance;
    }

    public List<AppData> getUsedApps(Context context, int offset) {
        ArrayList<AppData> items = new ArrayList<AppData>();
        ArrayList<AppData> newList = new ArrayList<AppData>();
        UsageStatsManager manager = (UsageStatsManager)context.getSystemService("usagestats");
        if (manager != null) {
            String prevPackage = "";
            HashMap<String, Long> startPoints = new HashMap<String, Long>();
            HashMap<String, ClonedEvent> endPoints = new HashMap<String, ClonedEvent>();
            SortOrder sortEnum = SortOrder.getSortEnum(offset);
            long[] range = UsageUtils.getTimeRange(sortEnum);
            UsageEvents events = sortEnum.name().equalsIgnoreCase("MONTH") ? manager.queryEvents(2L, range[1]) : manager.queryEvents(range[0], range[1]);
            UsageEvents.Event event = new UsageEvents.Event();
            while (events.hasNextEvent()) {
                events.getNextEvent(event);
                int eventType = event.getEventType();
                long eventTime = event.getTimeStamp();
                String eventPackage = event.getPackageName();
                if (eventType == 1) {
                    AppData item = this.containItem(items, eventPackage);
                    if (item == null) {
                        item = new AppData();
                        item.mPackageName = eventPackage;
                        items.add(item);
                    }
                    if (!startPoints.containsKey(eventPackage)) {
                        startPoints.put(eventPackage, eventTime);
                    }
                }
                if (eventType == 2 && startPoints.size() > 0 && startPoints.containsKey(eventPackage)) {
                    endPoints.put(eventPackage, new ClonedEvent(event));
                }
                if (TextUtils.isEmpty((CharSequence)prevPackage)) {
                    prevPackage = eventPackage;
                }
                if (prevPackage.equals(eventPackage)) continue;
                if (startPoints.containsKey(prevPackage) && endPoints.containsKey(prevPackage)) {
                    ClonedEvent lastEndEvent = (ClonedEvent)endPoints.get(prevPackage);
                    AppData listItem = this.containItem(items, prevPackage);
                    if (listItem != null) {
                        listItem.mEventTime = lastEndEvent.timeStamp;
                        long duration = lastEndEvent.timeStamp - (Long)startPoints.get(prevPackage);
                        if (duration <= 0L) {
                            duration = 0L;
                        }
                        listItem.mUsageTime += duration;
                        if (duration > 5000L) {
                            ++listItem.mCount;
                        }
                    }
                    startPoints.remove(prevPackage);
                    endPoints.remove(prevPackage);
                }
                prevPackage = eventPackage;
            }
        }
        if (items.size() > 0) {
            boolean canCalculateDataUsage = false;
            Map<Object, Object> mobileData = new HashMap<String, Long>();
            Map<Object, Object> wifiData = new HashMap();
            if (Build.VERSION.SDK_INT >= 23) {
                canCalculateDataUsage = true;
                NetworkStatsManager networkStatsManager = (NetworkStatsManager)context.getSystemService("netstats");
                TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
                mobileData = this.getMobileData(context, telephonyManager, networkStatsManager, offset);
                wifiData = this.getWifiUsageData(context, telephonyManager, networkStatsManager, offset);
            } else {
                mobileData.put("mobile", TrafficStats.getMobileRxBytes() + TrafficStats.getMobileTxBytes());
            }
            boolean hideSystem = false;
            boolean hideUninstall = true;
            PackageManager packageManager = context.getPackageManager();
            for (AppData item : items) {
                if (!UsageUtils.openable(packageManager, item.mPackageName) || hideSystem && UsageUtils.isSystemApp(packageManager, item.mPackageName) || hideUninstall && !UsageUtils.isInstalled(packageManager, item.mPackageName)) continue;
                if (canCalculateDataUsage) {
                    String key = "u" + UsageUtils.getAppUid(packageManager, item.mPackageName);
                    if (mobileData.size() > 0 && mobileData.containsKey(key)) {
                        item.mMobile = (Long)mobileData.get(key);
                    }
                    if (wifiData.size() > 0 && wifiData.containsKey(key)) {
                        item.mWifi = (Long)wifiData.get(key);
                    }
                }
                item.mName = UsageUtils.parsePackageName(packageManager, item.mPackageName);
                newList.add(item);
            }
            Collections.sort(newList, (left, right) -> (int)(right.mUsageTime - left.mUsageTime));
        }
        return newList;
    }

    private AppData containItem(List<AppData> items, String packageName) {
        for (AppData item : items) {
            if (!item.mPackageName.equals(packageName)) continue;
            return item;
        }
        return null;
    }

    private Map<String, Long> getMobileData(Context context, TelephonyManager tm, NetworkStatsManager nsm, int offset) {
        HashMap<String, Long> result = new HashMap<String, Long>();
        if (ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.READ_PHONE_STATE") == 0) {
            long[] range = UsageUtils.getTimeRange(SortOrder.getSortEnum(offset));
            try {
                NetworkStats networkStatsM;
                if (Build.VERSION.SDK_INT >= 23 && (networkStatsM = nsm.querySummary(0, UUID.randomUUID().toString(), range[0], range[1])) != null) {
                    while (networkStatsM.hasNextBucket()) {
                        NetworkStats.Bucket bucket = new NetworkStats.Bucket();
                        networkStatsM.getNextBucket(bucket);
                        String key = "u" + bucket.getUid();
                        if (result.containsKey(key)) {
                            result.put(key, (Long)result.get(key) + bucket.getTxBytes() + bucket.getRxBytes());
                            continue;
                        }
                        result.put(key, bucket.getTxBytes() + bucket.getRxBytes());
                    }
                }
            }
            catch (RemoteException e) {
                e.printStackTrace();
                Log.e((String)">>>>>", (String)e.getMessage());
            }
        }
        return result;
    }

    @SuppressLint(value={"MissingPermission"})
    private Map<String, Long> getWifiUsageData(Context context, TelephonyManager tm, NetworkStatsManager nsm, int offset) {
        HashMap<String, Long> result = new HashMap<String, Long>();
        if (ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.READ_PHONE_STATE") == 0) {
            long[] range = UsageUtils.getTimeRange(SortOrder.getSortEnum(offset));
            try {
                NetworkStats networkStatsM;
                if (Build.VERSION.SDK_INT >= 23 && (networkStatsM = nsm.querySummary(1, UUID.randomUUID().toString(), range[0], range[1])) != null) {
                    while (networkStatsM.hasNextBucket()) {
                        NetworkStats.Bucket bucket = new NetworkStats.Bucket();
                        networkStatsM.getNextBucket(bucket);
                        String key = "u" + bucket.getUid();
                        if (result.containsKey(key)) {
                            result.put(key, (Long)result.get(key) + bucket.getTxBytes() + bucket.getRxBytes());
                            continue;
                        }
                        result.put(key, bucket.getTxBytes() + bucket.getRxBytes());
                    }
                }
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    class ClonedEvent {
        String packageName;
        String eventClass;
        long timeStamp;
        int eventType;

        ClonedEvent(UsageEvents.Event event) {
            this.packageName = event.getPackageName();
            this.eventClass = event.getClassName();
            this.timeStamp = event.getTimeStamp();
            this.eventType = event.getEventType();
        }
    }
}

