/*
 * Decompiled with CFR 0.152.
 */
package bot.box.appusage.utils;

import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.graphics.drawable.Drawable;
import bot.box.appusage.BotMonitor;
import bot.box.appusage.utils.SortOrder;
import java.util.Calendar;

public class UsageUtils {
    public static final long USAGE_TIME_MIX = 5000L;
    private static final long A_DAY = 86400000L;

    public static String humanReadableMillis(long milliSeconds) {
        long second = milliSeconds / 1000L;
        if (second < 60L) {
            return String.format("%ss", second);
        }
        if (second < 3600L) {
            return String.format("%sm %ss", second / 60L, second % 60L);
        }
        return String.format("%sh %sm %ss", second / 3600L, second % 3600L / 60L, second % 3600L % 60L);
    }

    public static boolean openable(PackageManager packageManager, String packageName) {
        return packageManager.getLaunchIntentForPackage(packageName) != null;
    }

    public static boolean isSystemApp(PackageManager manager, String packageName) {
        boolean isSystemApp = false;
        try {
            ApplicationInfo applicationInfo = manager.getApplicationInfo(packageName, 0);
            if (applicationInfo != null) {
                isSystemApp = (applicationInfo.flags & 1) != 0 || (applicationInfo.flags & 0x80) != 0;
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return isSystemApp;
    }

    public static boolean isInstalled(PackageManager packageManager, String packageName) {
        ApplicationInfo applicationInfo = null;
        try {
            applicationInfo = packageManager.getApplicationInfo(packageName, 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return applicationInfo != null;
    }

    public static Drawable parsePackageIcon(String packageName, int _defaultIcon) {
        PackageManager manager = BotMonitor.getMonitorContext().getPackageManager();
        try {
            return manager.getApplicationIcon(packageName);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return BotMonitor.getMonitorContext().getResources().getDrawable(_defaultIcon);
        }
    }

    public static String parsePackageName(PackageManager pckManager, String data) {
        ApplicationInfo applicationInformation;
        try {
            applicationInformation = pckManager.getApplicationInfo(data, 128);
        }
        catch (PackageManager.NameNotFoundException e) {
            applicationInformation = null;
        }
        return applicationInformation != null ? pckManager.getApplicationLabel(applicationInformation) : data;
    }

    public static long[] getTimeRange(SortOrder sort) {
        long[] range;
        switch (sort) {
            case TODAY: {
                range = UsageUtils.getTodayRange();
                break;
            }
            case YESTERDAY: {
                range = UsageUtils.getYesterday();
                break;
            }
            case THIS_WEEK: {
                range = UsageUtils.getThisWeek();
                break;
            }
            case MONTH: {
                range = UsageUtils.getThisMonth();
                break;
            }
            case THIS_YEAR: {
                range = UsageUtils.getThisYear();
                break;
            }
            default: {
                range = UsageUtils.getTodayRange();
            }
        }
        return range;
    }

    private static long[] getTodayRange() {
        long timeNow = System.currentTimeMillis();
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return new long[]{cal.getTimeInMillis(), timeNow};
    }

    private static long[] getYesterday() {
        long timeNow = System.currentTimeMillis();
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(timeNow - 86400000L);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        long start = cal.getTimeInMillis();
        long end = start + 86400000L > timeNow ? timeNow : start + 86400000L;
        return new long[]{start, end};
    }

    private static long[] getThisWeek() {
        long timeNow = System.currentTimeMillis();
        Calendar cal = Calendar.getInstance();
        cal.set(7, 2);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        long start = cal.getTimeInMillis();
        long end = start + 86400000L > timeNow ? timeNow : start + 86400000L;
        return new long[]{start, end};
    }

    private static long[] getThisMonth() {
        long timeNow = System.currentTimeMillis();
        Calendar cal = Calendar.getInstance();
        cal.set(5, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return new long[]{cal.getTimeInMillis(), timeNow};
    }

    private static long[] getThisYear() {
        long timeNow = System.currentTimeMillis();
        Calendar cal = Calendar.getInstance();
        cal.set(1, Calendar.getInstance().get(1));
        cal.set(2, 0);
        cal.set(5, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return new long[]{cal.getTimeInMillis(), timeNow};
    }
}

