/*
 * Decompiled with CFR 0.152.
 */
package bot.box.appusage.datamanager;

import android.app.usage.UsageEvents;
import android.app.usage.UsageStatsManager;
import android.content.Context;
import android.content.pm.PackageManager;
import android.text.TextUtils;
import bot.box.appusage.model.AppData;
import bot.box.appusage.utils.SortOrder;
import bot.box.appusage.utils.UsageUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class DataManager {
    private static DataManager mInstance;

    public static void init() {
        mInstance = new DataManager();
    }

    public static DataManager getInstance() {
        return mInstance;
    }

    public List<AppData> getUsedApps(Context context, int offset) {
        ArrayList<AppData> items = new ArrayList<AppData>();
        ArrayList<AppData> newList = new ArrayList<AppData>();
        UsageStatsManager manager = (UsageStatsManager)context.getSystemService("usagestats");
        if (manager != null) {
            String prevPackage = "";
            HashMap<String, Long> startPoints = new HashMap<String, Long>();
            HashMap<String, ClonedEvent> endPoints = new HashMap<String, ClonedEvent>();
            SortOrder sortEnum = SortOrder.getSortEnum(offset);
            long[] range = UsageUtils.getTimeRange(sortEnum);
            UsageEvents events = sortEnum.name().equalsIgnoreCase("MONTH") ? manager.queryEvents(2L, range[1]) : manager.queryEvents(range[0], range[1]);
            UsageEvents.Event event = new UsageEvents.Event();
            while (events.hasNextEvent()) {
                events.getNextEvent(event);
                int eventType = event.getEventType();
                long eventTime = event.getTimeStamp();
                String eventPackage = event.getPackageName();
                if (eventType == 1) {
                    AppData item = this.containItem(items, eventPackage);
                    if (item == null) {
                        item = new AppData();
                        item.mPackageName = eventPackage;
                        items.add(item);
                    }
                    if (!startPoints.containsKey(eventPackage)) {
                        startPoints.put(eventPackage, eventTime);
                    }
                }
                if (eventType == 2 && startPoints.size() > 0 && startPoints.containsKey(eventPackage)) {
                    endPoints.put(eventPackage, new ClonedEvent(event));
                }
                if (TextUtils.isEmpty((CharSequence)prevPackage)) {
                    prevPackage = eventPackage;
                }
                if (prevPackage.equals(eventPackage)) continue;
                if (startPoints.containsKey(prevPackage) && endPoints.containsKey(prevPackage)) {
                    ClonedEvent lastEndEvent = (ClonedEvent)endPoints.get(prevPackage);
                    AppData listItem = this.containItem(items, prevPackage);
                    if (listItem != null) {
                        listItem.mEventTime = lastEndEvent.timeStamp;
                        long duration = lastEndEvent.timeStamp - (Long)startPoints.get(prevPackage);
                        if (duration <= 0L) {
                            duration = 0L;
                        }
                        listItem.mUsageTime += duration;
                        if (duration > 5000L) {
                            ++listItem.mCount;
                        }
                    }
                    startPoints.remove(prevPackage);
                    endPoints.remove(prevPackage);
                }
                prevPackage = eventPackage;
            }
        }
        if (items.size() > 0) {
            boolean hideSystem = false;
            boolean hideUninstall = true;
            PackageManager packageManager = context.getPackageManager();
            for (AppData item : items) {
                if (!UsageUtils.openable(packageManager, item.mPackageName) || hideSystem && UsageUtils.isSystemApp(packageManager, item.mPackageName) || hideUninstall && !UsageUtils.isInstalled(packageManager, item.mPackageName)) continue;
                item.mName = UsageUtils.parsePackageName(packageManager, item.mPackageName);
                newList.add(item);
            }
            Collections.sort(newList, (left, right) -> (int)(right.mUsageTime - left.mUsageTime));
        }
        return newList;
    }

    private AppData containItem(List<AppData> items, String packageName) {
        for (AppData item : items) {
            if (!item.mPackageName.equals(packageName)) continue;
            return item;
        }
        return null;
    }

    class ClonedEvent {
        String packageName;
        String eventClass;
        long timeStamp;
        int eventType;

        ClonedEvent(UsageEvents.Event event) {
            this.packageName = event.getPackageName();
            this.eventClass = event.getClassName();
            this.timeStamp = event.getTimeStamp();
            this.eventType = event.getEventType();
        }
    }
}

