/*
 * Decompiled with CFR 0.152.
 */
package bot.box.appusage.delegate;

import android.os.AsyncTask;
import bot.box.appusage.BotMonitor;
import bot.box.appusage.datamanager.DataManager;
import bot.box.appusage.model.AppData;
import bot.box.appusage.utils.UsageManager;
import java.util.List;

public class FetchAppUsageDelegate
extends AsyncTask<Integer, Integer, Void> {
    private AppUsageCallback mListener;

    public FetchAppUsageDelegate(AppUsageCallback l) {
        this.mListener = l;
    }

    protected void onPreExecute() {
        super.onPreExecute();
        this.mListener.onPreExecute();
    }

    protected Void doInBackground(Integer ... params) {
        List<AppData> usedApps = DataManager.getInstance().getUsedApps(BotMonitor.getMonitorContext(), params[0]);
        long mTotalUsage = 0L;
        for (AppData item : usedApps) {
            if (item.mUsageTime <= 0L) continue;
            mTotalUsage += item.mUsageTime;
            item.mCanOpen = BotMonitor.getMonitorContext().getPackageManager().getLaunchIntentForPackage(item.mPackageName) != null;
        }
        UsageManager.getInstance().setAppUsageList(usedApps, mTotalUsage);
        return null;
    }

    protected void onPostExecute(Void aVoid) {
        super.onPostExecute((Object)aVoid);
        this.mListener.onAppDataFetch(UsageManager.getInstance().getAppUsageList(), UsageManager.getInstance().getTotalUsage());
    }

    public static interface AppUsageCallback {
        public void onPreExecute();

        public void onAppDataFetch(List<AppData> var1, long var2);
    }
}

