package bot.box.appusage.handler;

import bot.box.appusage.BotMonitor;
import bot.box.appusage.contract.UsageContracts;
import bot.box.appusage.presenter.UsagePresenter;

/**
 * Created by BarryAllen
 *
 * @TheBotBOx boxforbot@gmail.com
 */
public class Monitor {

    private static Monitor mInstance = null;

    private Monitor() {
    }

    /**
     * requests for usage access permission
     */
    public static void requestUsagePermission() {
        BotMonitor.requestPermission();
    }

    /**
     * @return true, if usage access permission has been granted by the user for the application
     */
    public static boolean hasUsagePermission() {
        return BotMonitor.checkUsagePermission();
    }

    public static Monitor scan() {
        if (mInstance == null) {
            synchronized (Monitor.class) {
                if (mInstance == null) {
                    mInstance = new Monitor();
                }
            }
        }
        return mInstance;
    }

    /**
     * query to fetch the list of all the applications usage stats.
     *
     * @param mView callback to the view, once the list is ready
     * @return new instance of UsageGenerator which will query for a particular duration
     */
    public UsageGenerator getAppLists(UsageContracts.View mView) {
        return new UsageGenerator(new UsagePresenter(mView));
    }


}
