package bot.box.appusage.delegate;

import android.os.AsyncTask;

import java.util.List;

import bot.box.appusage.BotMonitor;
import bot.box.appusage.datamanager.DataManager;
import bot.box.appusage.model.AppData;
import bot.box.appusage.utils.UsageManager;

/**
 * Created by BarryAllen
 *
 * @TheBotBOx boxforbot@gmail.com
 */
public class FetchAppUsageDelegate extends AsyncTask<Integer, Integer, Void> {
    private AppUsageCallback mListener;

    public FetchAppUsageDelegate(AppUsageCallback l) {
        this.mListener = l;
    }

    @Override
    protected void onPreExecute() {
        super.onPreExecute();
        this.mListener.onPreExecute();
    }

    @Override
    protected Void doInBackground(Integer... params) {
        List<AppData> usedApps = DataManager.getInstance().getUsedApps(BotMonitor.getMonitorContext(), params[0]);

        long mTotalUsage = 0;

        for (AppData item : usedApps) {
            if (item.mUsageTime <= 0) continue;
            mTotalUsage += item.mUsageTime;
            item.mCanOpen = BotMonitor.getMonitorContext().getPackageManager().getLaunchIntentForPackage(item.mPackageName) != null;
        }
        UsageManager.getInstance().setAppUsageList(usedApps, mTotalUsage);
        return null;
    }

    @Override
    protected void onPostExecute(Void aVoid) {
        super.onPostExecute(aVoid);

        this.mListener.onAppDataFetch(UsageManager.getInstance()
                .getAppUsageList(), UsageManager.getInstance().getTotalUsage());
    }

    public interface AppUsageCallback {
        void onPreExecute();

        void onAppDataFetch(List<AppData> usageData, long mTotalUsage);
    }

}
