/*
 * Decompiled with CFR 0.152.
 */
package th.or.nectec.android.library.widget;

import android.content.Context;
import android.text.Editable;
import android.text.InputFilter;
import android.text.Selection;
import android.text.Spannable;
import android.text.TextWatcher;
import android.text.method.DigitsKeyListener;
import android.text.method.KeyListener;
import android.util.AttributeSet;
import android.util.Log;
import th.or.nectec.android.library.util.ThaiCitizenID;
import th.or.nectec.android.library.widget.ClearableEditText;

public class ThaiCitizenIdEditText
extends ClearableEditText {
    TextWatcher idWatcher = new TextWatcher(){

        public void onTextChanged(CharSequence s, int start, int before, int count) {
        }

        public void beforeTextChanged(CharSequence s, int start, int count, int after) {
        }

        public void afterTextChanged(Editable s) {
            String rawid = s.toString().trim();
            String id2 = rawid.replaceAll("-", "");
            String show = "";
            for (int i = 0; i < id2.length(); ++i) {
                switch (i) {
                    case 1: 
                    case 5: 
                    case 10: 
                    case 12: {
                        show = show + "-";
                    }
                }
                show = show + id2.charAt(i);
            }
            if (!show.equals(rawid)) {
                ThaiCitizenIdEditText.this.setText(show);
                int position = ThaiCitizenIdEditText.this.length();
                Selection.setSelection((Spannable)ThaiCitizenIdEditText.this.getEditableText(), (int)position);
                if (id2.length() == 13) {
                    ThaiCitizenIdEditText.this.validate(id2);
                } else {
                    ThaiCitizenIdEditText.this.setError(null);
                }
            }
        }
    };

    public ThaiCitizenIdEditText(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setFilters(new InputFilter[]{new InputFilter.LengthFilter(17)});
        this.setInputType(2);
        this.setKeyListener((KeyListener)DigitsKeyListener.getInstance((boolean)false, (boolean)true));
        this.addTextChangedListener(this.idWatcher);
        if (this.isInEditMode()) {
            this.setText("xxxxxxxxxxxxx");
        }
    }

    private boolean validate(String id2) {
        if (this.isInEditMode()) {
            return true;
        }
        boolean valid = ThaiCitizenID.Validate(id2);
        if (!valid) {
            this.setError("\u0e23\u0e2b\u0e31\u0e2a\u0e1a\u0e31\u0e15\u0e23\u0e1b\u0e23\u0e30\u0e0a\u0e32\u0e0a\u0e19\u0e44\u0e21\u0e48\u0e16\u0e39\u0e01\u0e15\u0e49\u0e2d\u0e07");
        }
        Log.d((String)"TEXT", (String)("id=" + this.getText()));
        return valid;
    }

    public boolean isValidID() {
        return this.validate(this.getCitizenId());
    }

    public String getCitizenId() {
        return this.getText().toString().trim().replaceAll("-", "");
    }
}

