/*
 * Decompiled with CFR 0.152.
 */
package th.or.nectec.android.library.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.ListAdapter;
import android.widget.ListView;

public class NestedListView
extends ListView
implements View.OnTouchListener,
AbsListView.OnScrollListener {
    private int listViewTouchAction = -1;
    private static final int MAXIMUM_LIST_ITEMS_VIEWABLE = 99;

    public NestedListView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setOnScrollListener(this);
        this.setOnTouchListener(this);
    }

    public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
        if (this.getAdapter() != null && this.getAdapter().getCount() > 99 && this.listViewTouchAction == 2) {
            this.scrollBy(0, -1);
        }
    }

    public void onScrollStateChanged(AbsListView view, int scrollState) {
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int newHeight = 0;
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        if (heightMode != 0x40000000) {
            ListAdapter listAdapter = this.getAdapter();
            if (listAdapter != null && !listAdapter.isEmpty()) {
                int listPosition = 0;
                for (listPosition = 0; listPosition < listAdapter.getCount() && listPosition < 99; ++listPosition) {
                    View listItem = listAdapter.getView(listPosition, null, (ViewGroup)this);
                    if (listItem instanceof ViewGroup) {
                        listItem.setLayoutParams((ViewGroup.LayoutParams)new AbsListView.LayoutParams(-2, -2));
                    }
                    listItem.measure(widthMeasureSpec, heightMeasureSpec);
                    newHeight += listItem.getMeasuredHeight();
                }
                newHeight += this.getDividerHeight() * listPosition;
            }
            if (heightMode == Integer.MIN_VALUE && newHeight > heightSize && newHeight > heightSize) {
                newHeight = heightSize;
            }
        } else {
            newHeight = this.getMeasuredHeight();
        }
        this.setMeasuredDimension(this.getMeasuredWidth(), newHeight);
    }

    public boolean onTouch(View v, MotionEvent event) {
        if (this.getAdapter() != null && this.getAdapter().getCount() > 99 && this.listViewTouchAction == 2) {
            this.scrollBy(0, 1);
        }
        return false;
    }
}

