/*
 * Decompiled with CFR 0.152.
 */
package th.or.nectec.android.library.widget;

import android.app.Fragment;
import android.app.FragmentManager;
import android.app.FragmentTransaction;
import android.os.Parcelable;
import android.support.v4.view.PagerAdapter;
import android.util.Log;
import android.view.View;

public abstract class FragmentPagerAdapter
extends PagerAdapter {
    private static final String TAG = "FragmentPagerAdapter";
    private static final boolean DEBUG = true;
    private final FragmentManager mFragmentManager;
    private FragmentTransaction mCurTransaction = null;
    private Fragment mCurrentPrimaryItem = null;
    View mContainer;

    public FragmentPagerAdapter(FragmentManager fm) {
        this.mFragmentManager = fm;
    }

    public abstract Fragment getItem(int var1);

    public void startUpdate(View container) {
    }

    public Object instantiateItem(View container, int position) {
        if (this.mCurTransaction == null) {
            this.mCurTransaction = this.mFragmentManager.beginTransaction();
        }
        this.mContainer = container;
        String name = FragmentPagerAdapter.makeFragmentName(container.getId(), position);
        Fragment fragment = this.mFragmentManager.findFragmentByTag(name);
        if (fragment != null) {
            Log.v((String)TAG, (String)("Attaching item #" + position + ": f=" + fragment));
            this.mCurTransaction.attach(fragment);
        } else {
            fragment = this.getItem(position);
            Log.v((String)TAG, (String)("Adding item #" + position + ": f=" + fragment));
            this.mCurTransaction.add(container.getId(), fragment, FragmentPagerAdapter.makeFragmentName(container.getId(), position));
        }
        if (fragment != this.mCurrentPrimaryItem) {
            fragment.setMenuVisibility(false);
        }
        return fragment;
    }

    public void destroyItem(View container, int position, Object object) {
        if (this.mCurTransaction == null) {
            this.mCurTransaction = this.mFragmentManager.beginTransaction();
        }
        Log.v((String)TAG, (String)("Detaching item #" + position + ": f=" + object + " v=" + ((Fragment)object).getView()));
        this.mCurTransaction.detach((Fragment)object);
    }

    public void setPrimaryItem(View container, int position, Object object) {
        Fragment fragment = (Fragment)object;
        if (fragment != this.mCurrentPrimaryItem) {
            if (this.mCurrentPrimaryItem != null) {
                this.mCurrentPrimaryItem.setMenuVisibility(false);
            }
            if (fragment != null) {
                fragment.setMenuVisibility(true);
            }
            this.mCurrentPrimaryItem = fragment;
        }
    }

    public void finishUpdate(View container) {
        if (this.mCurTransaction != null) {
            this.mCurTransaction.commitAllowingStateLoss();
            this.mCurTransaction = null;
            this.mFragmentManager.executePendingTransactions();
        }
    }

    public boolean isViewFromObject(View view, Object object) {
        return ((Fragment)object).getView() == view;
    }

    public Parcelable saveState() {
        return null;
    }

    public void restoreState(Parcelable state, ClassLoader loader) {
    }

    private static String makeFragmentName(int viewId, int index) {
        return "android:switcher:" + viewId + ":" + index;
    }

    public Fragment getFragment(int position) {
        if (this.mContainer == null) {
            return null;
        }
        String name = FragmentPagerAdapter.makeFragmentName(this.mContainer.getId(), position);
        Fragment fragment = this.mFragmentManager.findFragmentByTag(name);
        if (fragment != null) {
            return fragment;
        }
        fragment = this.getItem(position);
        if (fragment == null) {
            return null;
        }
        Log.v((String)TAG, (String)("Adding item #" + position + ": f=" + fragment));
        this.mCurTransaction.add(this.mContainer.getId(), fragment, FragmentPagerAdapter.makeFragmentName(this.mContainer.getId(), position));
        return fragment;
    }
}

