/*
 * Decompiled with CFR 0.152.
 */
package th.or.nectec.android.library.security;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import th.or.nectec.android.library.security.MessageDigester;

public class Cryptographer {
    Cipher ecipher;
    Cipher dcipher;
    private boolean stop = false;
    private static final String KEY = "wis@nectec";
    public static final int ALGORITHM_AES = 0;
    public static final int ALGORITHM_DES = 1;
    @Deprecated
    public static final int ALGORITHM_TEA = 2;
    public static final int ALGORITHM_FFC = 3;
    public static final int ALGORITHM_BWF = 4;
    public static final String AES_INSTANCE = "AES/CBC/PKCS5Padding";
    public static final String DES_INSTANCE = "DES/CBC/PKCS5Padding";
    public static final String BWF_INSTANCE = "Blowfish/CFB/NoPadding";
    static final byte[] mAESiv = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
    static final byte[] mDESiv = new byte[]{-114, 18, 57, -100, 7, 114, 111, 90};
    static final byte[] mBWFiv = new byte[]{0, -128, 1, 97, -8, 23};
    private int mCryptoMode;
    private ProgessListener mProgess;
    byte[] buf = new byte[1024];

    public Cryptographer(String key, int Algorithm) {
        this.mCryptoMode = Algorithm;
        switch (Algorithm) {
            case 4: {
                SecretKeySpec skey = new SecretKeySpec(MessageDigester.getMD5(key), "Blowfish");
                this.setupParameter(skey, BWF_INSTANCE, null);
                break;
            }
            case 0: {
                SecretKeySpec skey = new SecretKeySpec(MessageDigester.getMD5(key), "AES");
                this.setupParameter(skey, AES_INSTANCE, mAESiv);
                break;
            }
            case 1: {
                byte[] keyData = key.getBytes();
                SecretKeySpec skey = new SecretKeySpec(keyData, 0, 8, "DES");
                this.setupParameter(skey, DES_INSTANCE, mDESiv);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid Algorithm Code");
            }
        }
    }

    public static final String getKey() {
        return KEY;
    }

    public void setProgessListener(ProgessListener listener) {
        this.mProgess = listener;
    }

    private void setupParameter(SecretKey key, String instance, byte[] iv) {
        IvParameterSpec paramSpec = new IvParameterSpec(iv);
        try {
            this.ecipher = Cipher.getInstance(instance);
            this.dcipher = Cipher.getInstance(instance);
            this.ecipher.init(1, (Key)key, paramSpec);
            this.dcipher.init(2, (Key)key, paramSpec);
        }
        catch (InvalidKeyException ike) {
            ike.printStackTrace();
        }
        catch (NoSuchAlgorithmException nae) {
            nae.printStackTrace();
        }
        catch (NoSuchPaddingException npe) {
            npe.printStackTrace();
        }
        catch (InvalidAlgorithmParameterException iae) {
            iae.printStackTrace();
        }
    }

    public boolean encrypt(File input, File output) {
        try {
            return this.encrypt(new FileInputStream(input), new FileOutputStream(output));
        }
        catch (FileNotFoundException fnf) {
            return false;
        }
    }

    public boolean encrypt(InputStream in, OutputStream out) {
        int size = 0;
        try {
            out = new CipherOutputStream(out, this.ecipher);
            int numRead = 0;
            while ((numRead = in.read(this.buf)) >= 0) {
                if (this.stop) {
                    in.close();
                    out.close();
                    return false;
                }
                out.write(this.buf, 0, numRead);
                if (this.mProgess == null) continue;
                this.mProgess.onCryptoProgessUpdate(size += numRead, true);
            }
            in.close();
            out.close();
            if (this.mProgess != null) {
                this.mProgess.onCryptoProgessUpdate(size, false);
            }
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean decrypt(File input, File output) {
        try {
            return this.decrypt(new FileInputStream(input), new FileOutputStream(output));
        }
        catch (FileNotFoundException fnf) {
            return false;
        }
    }

    public boolean decrypt(InputStream in, OutputStream out) {
        if (this.mCryptoMode == 3) {
            this.mCryptoMode = 3;
            return this.encrypt(in, out);
        }
        int size = 0;
        try {
            in = new CipherInputStream(in, this.dcipher);
            int numRead = 0;
            while ((numRead = in.read(this.buf)) >= 0) {
                if (this.stop) {
                    in.close();
                    out.close();
                    return false;
                }
                out.write(this.buf, 0, numRead);
                if (this.mProgess == null) continue;
                this.mProgess.onCryptoProgessUpdate(size += numRead, true);
            }
            in.close();
            out.close();
            if (this.mProgess != null) {
                this.mProgess.onCryptoProgessUpdate(size, false);
            }
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void close() {
        this.ecipher = null;
        this.dcipher = null;
        this.mProgess = null;
    }

    public void stop() {
        this.stop = true;
    }

    public static interface ProgessListener {
        public void onCryptoProgessUpdate(int var1, boolean var2);
    }
}

