/*
 * Decompiled with CFR 0.152.
 */
package th.or.nectec.android.library.network;

import android.content.Context;
import android.util.Log;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;

public final class HttpUtilities {
    public static final String TAG = "HttpUtil";

    public static String post(String endpoint, Map<String, String> params) throws IOException {
        String line;
        URL url;
        try {
            url = new URL(endpoint);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("invalid url: " + endpoint);
        }
        StringBuilder bodyBuilder = new StringBuilder();
        Iterator<Map.Entry<String, String>> iterator = params.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> param = iterator.next();
            bodyBuilder.append(param.getKey()).append('=').append(param.getValue());
            if (!iterator.hasNext()) continue;
            bodyBuilder.append('&');
        }
        String body = bodyBuilder.toString();
        Log.v((String)TAG, (String)("Posting '" + body + "' to " + url));
        byte[] bytes = body.getBytes();
        HttpURLConnection conn = null;
        conn = (HttpURLConnection)url.openConnection();
        conn.setDoOutput(true);
        conn.setUseCaches(false);
        conn.setFixedLengthStreamingMode(bytes.length);
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8");
        OutputStream out = conn.getOutputStream();
        out.write(bytes);
        out.close();
        int status = conn.getResponseCode();
        if (status != 200) {
            throw new IOException("Post failed with error code " + status + ", msg " + conn.getResponseMessage());
        }
        BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        while ((line = rd.readLine()) != null) {
            Log.i((String)TAG, (String)("RES Message: " + line));
        }
        rd.close();
        conn.disconnect();
        return line;
    }

    public static void enableHttpCaching(Context context, int cacheSizeMb) {
        try {
            File httpCacheDir = new File(context.getCacheDir(), "http");
            long httpCacheSize = cacheSizeMb * 1024 * 1024;
            Class.forName("android.net.http.HttpResponseCache").getMethod("install", File.class, Long.TYPE).invoke(null, httpCacheDir, httpCacheSize);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

