/*
 * Decompiled with CFR 0.152.
 */
package th.or.nectec.android.library.form.field;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.text.TextUtils;
import android.view.View;
import java.util.ArrayList;
import th.or.nectec.android.library.form.IMultiColumnField;
import th.or.nectec.android.library.form.NTField;
import th.or.nectec.android.library.provider.columns.AddressColumns;
import th.or.nectec.android.library.util.StringUtils;
import th.or.nectec.android.library.widget.address.AddressView;

public class NTAddressField
extends NTField
implements IMultiColumnField,
AddressColumns {
    AddressView view;
    private String codeColumn;
    private String sColumn;
    private String dColumn;
    private String pColumn;

    public NTAddressField(AddressView view, String addressCode, String subdistrict, String district, String province) {
        super((View)view, addressCode);
        this.view = view;
        this.codeColumn = addressCode;
        this.sColumn = subdistrict;
        this.dColumn = district;
        this.pColumn = province;
    }

    public NTAddressField(AddressView view) {
        super((View)view, "address_code");
        this.codeColumn = "address_code";
        this.sColumn = "subdistrict";
        this.dColumn = "district";
        this.pColumn = "province";
    }

    public NTAddressField(String col, String lable) {
        super(col, lable);
        this.codeColumn = col + "address_code";
        this.sColumn = col + "subdistrict";
        this.dColumn = col + "district";
        this.pColumn = col + "province";
    }

    public NTAddressField(String lable) {
        super("address_code", lable);
        this.codeColumn = "address_code";
        this.sColumn = "subdistrict";
        this.dColumn = "district";
        this.pColumn = "province";
    }

    public NTAddressField(String addressCode, String subdistrict, String district, String province, String lable) {
        super(addressCode, lable);
        this.codeColumn = addressCode;
        this.sColumn = subdistrict;
        this.dColumn = district;
        this.pColumn = province;
    }

    @Override
    @Deprecated
    public String getValue() {
        return null;
    }

    @Override
    @Deprecated
    public void setValue(String value) {
    }

    @Override
    public void setValueByCursor(Cursor c) {
        String code = null;
        if (!TextUtils.isEmpty((CharSequence)this.codeColumn)) {
            code = c.getString(c.getColumnIndex(this.codeColumn));
        }
        String p = c.getString(c.getColumnIndex(this.pColumn));
        String d = c.getString(c.getColumnIndex(this.dColumn));
        String s = c.getString(c.getColumnIndex(this.sColumn));
        this.view.setLocale(code, s, d, p);
    }

    @Override
    public ContentValues getContentValues() {
        ContentValues cv = new ContentValues();
        if (!TextUtils.isEmpty((CharSequence)this.codeColumn)) {
            cv.put(this.codeColumn, this.view.getAddressCode());
        }
        cv.put(this.pColumn, this.view.getProvince());
        cv.put(this.dColumn, this.view.getDistrict());
        cv.put(this.sColumn, this.view.getSubdistrict());
        return cv;
    }

    @Override
    public boolean isValid() {
        if (StringUtils.isEmpty(this.view.getProvince())) {
            this.mInvalidMessage = "\u0e22\u0e31\u0e07\u0e44\u0e21\u0e48\u0e44\u0e14\u0e49\u0e40\u0e25\u0e37\u0e2d\u0e01\u0e17\u0e35\u0e48\u0e2d\u0e22\u0e39\u0e48";
            return false;
        }
        return super.isValid();
    }

    @Override
    public String[] getColumns() {
        ArrayList<String> columns = new ArrayList<String>();
        columns.add(this.pColumn);
        columns.add(this.dColumn);
        columns.add(this.sColumn);
        if (!TextUtils.isEmpty((CharSequence)this.codeColumn)) {
            columns.add(this.codeColumn);
        }
        return columns.toArray(new String[columns.size()]);
    }

    @Override
    public View onCreateView(Context context) {
        AddressView av = new AddressView(context, null);
        return av;
    }
}

