/*
 * Decompiled with CFR 0.152.
 */
package th.co.sic.module.nfc.sic43nt;

import th.co.sic.module.nfc.Define;
import th.co.sic.module.nfc.SicChip;
import th.co.sic.module.nfc.providers.EepromProvider;

public class UserConfiguration
extends EepromProvider {
    public static final byte PAGE_CONFIGURATION_0 = 41;
    public static final byte PAGE_CONFIGURATION_1 = 42;
    public static final byte PAGE_PASSWORD = 43;
    public static final byte PAGE_PASSWORD_ACK = 44;
    public static final byte PAGE_KEY_9_6 = 45;
    public static final byte PAGE_KEY_5_2 = 46;
    public static final byte PAGE_KEY_1_0 = 47;
    public static final byte PAGE_INIT_VECTOR = 48;
    public static final byte BYTE__FDP = 0;
    public static final byte BYTE__Tdata0 = 1;
    public static final byte BYTE__DYN_PAGE_PTR = 2;
    public static final byte BYTE__Auth0 = 3;
    public static final byte BIT__FDP__FDT = Define.Bit.parseBit((int[])new int[]{1, 0});
    public static final byte BIT__FDP__SleepEN = Define.Bit.parseBit((int[])new int[]{3});
    public static final byte BIT__FDP__DynBytePtr = Define.Bit.parseBit((int[])new int[]{5, 4});
    public static final byte FDT__NoFieldDetect = Define.Bit.parseBit();
    public static final byte FDT__1stSOF = Define.Bit.parseBit((int[])new int[]{0});
    public static final byte FDT__Select = Define.Bit.parseBit((int[])new int[]{1});
    public static final byte FDT__FieldPresent = Define.Bit.parseBit((int[])new int[]{1, 0});
    public static final byte SleepEN__Disable = Define.Bit.parseBit();
    public static final byte SleepEN__Enable = Define.Bit.parseBit((int[])new int[]{3});
    public static final byte BYTE__Protection = 0;
    public static final byte BYTE__Tdata1 = 1;
    public static final byte BYTE__RFDCFG = 2;
    public static final byte BYTE__MEMCFG = 3;
    public static final byte BIT__Protection__AUTHLIM = Define.Bit.parseBit((int[])new int[]{2, 1, 0});
    public static final byte BIT__Protection__CFGLOCK = Define.Bit.parseBit((int[])new int[]{6});
    public static final byte BIT__Protection__PROT = Define.Bit.parseBit((int[])new int[]{7});
    public static final byte AUTHLIM__Unlimited = Define.Bit.parseBit();
    public static final byte AUTHLIM__Limit_1 = Define.Bit.parseBit((int[])new int[]{0});
    public static final byte AUTHLIM__Limit_2 = Define.Bit.parseBit((int[])new int[]{1});
    public static final byte AUTHLIM__Limit_3 = Define.Bit.parseBit((int[])new int[]{1, 0});
    public static final byte AUTHLIM__Limit_4 = Define.Bit.parseBit((int[])new int[]{2});
    public static final byte AUTHLIM__Limit_5 = Define.Bit.parseBit((int[])new int[]{2, 0});
    public static final byte AUTHLIM__Limit_6 = Define.Bit.parseBit((int[])new int[]{2, 1});
    public static final byte AUTHLIM__Limit_7 = Define.Bit.parseBit((int[])new int[]{2, 1, 0});
    public static final byte CFGLOCK__Unlock = Define.Bit.parseBit();
    public static final byte CFGLOCK__Locked = Define.Bit.parseBit((int[])new int[]{6});
    public static final byte PROT__WriteProtection = Define.Bit.parseBit();
    public static final byte PROT__ReadWriteProtection = Define.Bit.parseBit((int[])new int[]{7});
    public static final byte BIT__RFDCFG__AutoProgTamper = Define.Bit.parseBit((int[])new int[]{1});
    public static final byte BIT__RFDCFG__OutputType = Define.Bit.parseBit((int[])new int[]{2});
    public static final byte BIT__RFDCFG__TamperST = Define.Bit.parseBit((int[])new int[]{3});
    public static final byte BIT__RFDCFG__TamperMD = Define.Bit.parseBit((int[])new int[]{4});
    public static final byte BIT__RFDCFG__TamperConf = Define.Bit.parseBit((int[])new int[]{6, 5});
    public static final byte BIT__RFDCFG__AutoDetEn = Define.Bit.parseBit((int[])new int[]{7});
    public static final byte AutoProgTamper__Disable = Define.Bit.parseBit();
    public static final byte AutoProgTamper__Enable = Define.Bit.parseBit((int[])new int[]{1});
    public static final byte OutputType__OpenDrain = Define.Bit.parseBit();
    public static final byte OutputType__PushPull = Define.Bit.parseBit((int[])new int[]{2});
    public static final byte TamperST__Continuous = Define.Bit.parseBit();
    public static final byte TamperST__PowerUpOnly = Define.Bit.parseBit((int[])new int[]{3});
    public static final byte TamperMD__RfDetecionMode = Define.Bit.parseBit();
    public static final byte TamperMD__TamperMode = Define.Bit.parseBit((int[])new int[]{4});
    public static final byte TamperConf__6_4_uA = Define.Bit.parseBit();
    public static final byte TamperConf__3_2_uA = Define.Bit.parseBit((int[])new int[]{5});
    public static final byte TamperConf__1_6_uA = Define.Bit.parseBit((int[])new int[]{6});
    public static final byte TamperConf__0_8_uA = Define.Bit.parseBit((int[])new int[]{6, 5});
    public static final byte AutoDetEn__Manual = Define.Bit.parseBit();
    public static final byte AutoDetEn__AutoDetect = Define.Bit.parseBit((int[])new int[]{7});
    public static final byte BIT__MEMCFG__144_LockF = Define.Bit.parseBit((int[])new int[]{2});
    public static final byte BIT__MEMCFG__DYN_RLC_EN = Define.Bit.parseBit((int[])new int[]{3});
    public static final byte BIT__MEMCFG__DYN_TMP_EN = Define.Bit.parseBit((int[])new int[]{4});
    public static final byte BIT__MEMCFG__DYN_UID_EN = Define.Bit.parseBit((int[])new int[]{5});
    public static final byte BIT__MEMCFG__TMP_CTRL_RLC = Define.Bit.parseBit((int[])new int[]{7, 6});
    public static final byte LockF__Style_1 = Define.Bit.parseBit();
    public static final byte LockF__Style_2 = Define.Bit.parseBit((int[])new int[]{2});
    public static final byte DYN_RLC_EN__Disable = Define.Bit.parseBit();
    public static final byte DYN_RLC_EN__Enable = Define.Bit.parseBit((int[])new int[]{3});
    public static final byte DYN_TMP_EN__Disable = Define.Bit.parseBit();
    public static final byte DYN_TMP_EN__Enable = Define.Bit.parseBit((int[])new int[]{4});
    public static final byte DYN_UID_EN__Disable = Define.Bit.parseBit();
    public static final byte DYN_UID_EN__Enable = Define.Bit.parseBit((int[])new int[]{5});
    public static final byte TMP_CTRL_RLC__FIXED = Define.Bit.parseBit();
    public static final byte TMP_CTRL_RLC__TAMPER_DETECTED = Define.Bit.parseBit((int[])new int[]{6});
    public static final byte TMP_CTRL_RLC__TAMPER_NOT_DETECTED = Define.Bit.parseBit((int[])new int[]{7});
    public static final byte TMP_CTRL_RLC__IGNORED_TAMPER = Define.Bit.parseBit((int[])new int[]{7, 6});
    private static UserConfiguration instance;

    public static UserConfiguration getInstance(SicChip chip) {
        if (instance == null) {
            instance = new UserConfiguration(chip);
        }
        return instance;
    }

    protected UserConfiguration(SicChip chip) {
        super(chip);
    }

    public void setFieldDetectPinTriggerEvent(byte FDT) {
        this.writeBit(41, 0, BIT__FDP__FDT, FDT);
    }

    public void setDynamicPointer(byte pagePtr, byte bytePtr_Last2bit) {
        this.writeByte((byte)41, (byte)2, pagePtr);
        this.writeBit(41, 0, BIT__FDP__DynBytePtr, bytePtr_Last2bit << 4);
    }

    public void setTdata(byte Tdata0, byte Tdata1) {
        this.writeByte((byte)41, (byte)1, Tdata0);
        this.writeByte((byte)42, (byte)1, Tdata1);
    }

    public void setPageProtection(byte address) {
        this.writeByte((byte)41, (byte)3, address);
    }

    public void setAuthenLimitation(byte limit_last3bit) {
        this.writeBit(42, 0, BIT__Protection__AUTHLIM, limit_last3bit);
    }

    public void setConfigLocked(boolean locked) {
        this.writeBit(42, 0, BIT__Protection__CFGLOCK, locked ? CFGLOCK__Locked : CFGLOCK__Unlock);
    }

    public void setReadAccessingProtection(boolean enable) {
        this.writeBit(42, 0, BIT__Protection__PROT, enable ? PROT__ReadWriteProtection : PROT__WriteProtection);
    }

    public void setAutoProgramTamperEnabled(boolean enable) {
        this.writeBit(42, 2, BIT__RFDCFG__AutoProgTamper, enable ? AutoProgTamper__Enable : AutoProgTamper__Disable);
    }

    public void setTamperCheckingWhenPowerUpOnly(boolean enable) {
        this.writeBit(42, 2, BIT__RFDCFG__TamperST, enable ? TamperST__PowerUpOnly : TamperST__Continuous);
    }

    public void setTamperingDetectionMode() {
        this.writeBit(42, 2, BIT__RFDCFG__TamperMD, TamperMD__TamperMode);
    }

    public void setSleepMode() {
        this.writeBit(42, 2, BIT__RFDCFG__TamperMD, TamperMD__RfDetecionMode);
        this.writeBit(41, 0, BIT__FDP__SleepEN, SleepEN__Enable);
    }

    public void setRfDetectionMode(boolean autoDetect, boolean isPushPull) {
        this.writeBit(42, 2, BIT__RFDCFG__TamperMD, TamperMD__RfDetecionMode);
        this.writeBit(41, 0, BIT__FDP__SleepEN, SleepEN__Disable);
        this.writeBit(42, 2, BIT__RFDCFG__AutoDetEn, autoDetect ? AutoDetEn__AutoDetect : AutoDetEn__Manual);
        this.writeBit(42, 2, BIT__RFDCFG__OutputType, isPushPull ? OutputType__PushPull : OutputType__OpenDrain);
    }

    public void setTamperBiasCurrent(byte TamperConf) {
        this.writeBit(42, 2, BIT__RFDCFG__TamperConf, TamperConf);
    }

    public void setLockbitStyle1() {
        this.writeBit(42, 3, BIT__MEMCFG__144_LockF, LockF__Style_1);
    }

    public void setLockbitStyle2() {
        this.writeBit(42, 3, BIT__MEMCFG__144_LockF, LockF__Style_2);
    }

    public void setDynamicNdef(boolean uid, boolean tamper, boolean rlc) {
        byte u = uid ? DYN_UID_EN__Enable : DYN_UID_EN__Disable;
        byte t = tamper ? DYN_TMP_EN__Enable : DYN_TMP_EN__Disable;
        byte r = rlc ? DYN_RLC_EN__Enable : DYN_RLC_EN__Disable;
        this.writeBit(42, 3, BIT__MEMCFG__DYN_UID_EN | BIT__MEMCFG__DYN_TMP_EN | BIT__MEMCFG__DYN_RLC_EN, u | t | r);
    }

    public void setRollingCodeController(byte mode) {
        this.writeBit(42, 3, BIT__MEMCFG__TMP_CTRL_RLC, mode);
    }

    public boolean setPassword(byte[] pwd, byte[] pack) {
        if (pwd != null && pwd.length == 4 && pack != null && pack.length >= 2) {
            this.write(43, pwd);
            this.write(44, pack);
            return true;
        }
        return false;
    }

    public boolean setKey(byte[] key) {
        if (key != null && key.length == 10) {
            int index = 0;
            for (int i = 0; i < 3; ++i) {
                byte[] data = new byte[]{0, 0, 0, 0};
                for (int j = 0; index < 10 && j < 4; ++j) {
                    data[j] = key[index++];
                }
                this.write(45 + i, data);
            }
            return true;
        }
        return false;
    }

    public boolean setInitialVector(byte[] iv) {
        if (iv != null && iv.length == 4) {
            this.write(48, iv);
        }
        return false;
    }
}

