/*
 * Decompiled with CFR 0.152.
 */
package th.co.sic.module.nfc.providers;

import th.co.sic.module.nfc.Provider;
import th.co.sic.module.nfc.SicChip;
import th.co.sic.module.nfc.sic4310.Register;
import th.co.sic.module.utils.PackageUtils;

public abstract class UartProvider
extends Provider {
    private static final String TAG = UartProvider.class.getSimpleName();
    public static int MAX_SIZE_FIFO;
    public static int STOP_BITS;
    public static int PARITY;
    public static int TRXRU_RESPONSE_TIME;
    public static int DIVISOR_M;
    public static int DIVISOR_N;
    public static int StopBits_1;
    public static int StopBits_2;
    public static int Parity_None;
    public static int Parity_Space;
    public static int Parity_Mask;
    public static int Parity_Even;
    public static int Parity_Odd;
    public static int Mode_Rx;
    public static int Mode_Tx;
    public static int Mode_RTS;
    public static int Mode_CTS;
    protected static byte ADDRESS_TRXRU_RESPONSE_TIME;
    protected static byte ADDRESS_UART_BYTE_CONFIGURATION;
    protected static byte ADDRESS_UART_DIVISOR_M;
    protected static byte ADDRESS_UART_DIVISOR_N;
    protected static int SPEED_OF_UART;
    protected static int TRxRURespTimeShiftBit;
    private SicChip mChip;

    protected UartProvider(SicChip chip) {
        super(chip.getRegister());
        this.mChip = chip;
    }

    public static byte[] getSinglePackage_TxRu(byte[] data) {
        return PackageUtils.getInstance().getPackageLimited((byte)-79, data, MAX_SIZE_FIFO);
    }

    public static byte[][] getMultiPackage_TxRu(byte[] ... data) {
        return PackageUtils.getInstance().getPackageSplit((byte)-79, data, MAX_SIZE_FIFO);
    }

    public static byte[] getPackage_RxUr() {
        return new byte[]{-78, 0};
    }

    public static byte[] getSinglePackage_TrxRu(byte[] data) {
        return PackageUtils.getInstance().getPackageLimited((byte)-77, data, MAX_SIZE_FIFO);
    }

    public static byte[][] getMultiPackage_TrxRu(byte[] ... data) {
        return PackageUtils.getInstance().getPackageSplit((byte)-79, (byte)-77, data, MAX_SIZE_FIFO);
    }

    public abstract byte getMode();

    public abstract void setMode(int var1);

    public int getBaudRate() {
        int m = this.mRegister.readBuffer((int)ADDRESS_UART_DIVISOR_M) & DIVISOR_M;
        int n = this.mRegister.readBuffer((int)ADDRESS_UART_DIVISOR_N) & DIVISOR_N;
        if (n < 2) {
            return -1;
        }
        if (m == 0) {
            m = 64;
        }
        return SPEED_OF_UART / (m * n);
    }

    public void setBaudRate(int baudRate) {
        int n;
        int bitRate = SPEED_OF_UART / baudRate;
        int m = 1;
        for (n = bitRate; n > 48; n >>= 1) {
            m <<= 1;
        }
        this.mRegister.write((byte[][])new byte[][]{{ADDRESS_UART_DIVISOR_M, (byte)m}, {ADDRESS_UART_DIVISOR_N, (byte)n}});
    }

    public byte getStopLength() {
        return (byte)(this.mRegister.readBuffer((int)ADDRESS_UART_BYTE_CONFIGURATION) & STOP_BITS);
    }

    public void setStopLength(int UART_StopLen) {
        this.mRegister.writeParams((int)ADDRESS_UART_BYTE_CONFIGURATION, STOP_BITS, UART_StopLen);
    }

    public byte getParity() {
        return (byte)(this.mRegister.readBuffer((int)ADDRESS_UART_BYTE_CONFIGURATION) & PARITY);
    }

    public void setParity(int UART_Parity) {
        this.mRegister.writeParams((int)ADDRESS_UART_BYTE_CONFIGURATION, PARITY, UART_Parity);
    }

    public int getTrxRuResponseTime() {
        int time = (this.mRegister.readBuffer((int)ADDRESS_TRXRU_RESPONSE_TIME) & TRXRU_RESPONSE_TIME) >> TRxRURespTimeShiftBit;
        return (int)Math.pow(2.0, time);
    }

    public int setTrxRuResponseTime(int time) {
        time = ((int)Math.ceil(Math.log(time) / Math.log(2.0)) & TRXRU_RESPONSE_TIME) >> TRxRURespTimeShiftBit;
        this.mRegister.write((int)ADDRESS_TRXRU_RESPONSE_TIME, time);
        time = (int)Math.pow(2.0, time);
        this.mChip.setTimeout(time + 128);
        return time;
    }

    public byte[] send(byte[] ... data) {
        return this.mChip.autoTransceive(UartProvider.getMultiPackage_TxRu(data));
    }

    public byte[] receive() {
        return this.mChip.autoTransceive(UartProvider.getPackage_RxUr());
    }

    public void clearFifo() {
        this.mChip.autoTransceive((byte[][])new byte[][]{Register.getPackage_ClearFlags(), UartProvider.getPackage_RxUr()});
    }

    @Deprecated
    public byte[] TxRuTranceiver(int ncmd, byte[] data) {
        return this.txRuTranceiver(ncmd, data);
    }

    public byte[] txRuTranceiver(int ncmd, byte[] data) {
        int flag;
        byte[] rxBuffer;
        this.mChip.autoTransceive(false, UartProvider.getMultiPackage_TxRu(new byte[][]{data}));
        do {
            if ((rxBuffer = this.receive()) != null && rxBuffer.length >= 1) continue;
            return null;
        } while ((rxBuffer[0] & (flag = -126)) == flag && ncmd-- > 0);
        return rxBuffer;
    }

    @Deprecated
    public byte[] TrxRuTranceiver(byte[] data) {
        return this.trxRuTranceiver(data);
    }

    public byte[] trxRuTranceiver(byte[] data) {
        return this.mChip.autoTransceive(UartProvider.getMultiPackage_TxRu(new byte[][]{data}));
    }

    @Deprecated
    public byte[] TrxRuTranceiver(int time, byte[] data) {
        return this.trxRuTranceiver(time, data);
    }

    public byte[] trxRuTranceiver(int time, byte[] data) {
        time = ((int)Math.ceil(Math.log(time) / Math.log(2.0)) & TRXRU_RESPONSE_TIME) >> TRxRURespTimeShiftBit;
        boolean ad = this.mChip.isAutoDisconnect();
        this.mChip.setAutoDisconnect(false);
        this.mRegister.write((int)ADDRESS_TRXRU_RESPONSE_TIME, time);
        time = (int)Math.pow(2.0, time);
        this.mChip.setTimeout(time + 128);
        this.mChip.setAutoDisconnect(ad);
        return this.mChip.autoTransceive(UartProvider.getMultiPackage_TrxRu(new byte[][]{data}));
    }

    public Builder init() {
        return new Builder(this);
    }

    private void initUART(int baudRate, int UART_StopLen, int UART_Parity, int UART_Mode) {
        try {
            int n;
            boolean ad = this.mChip.isAutoDisconnect();
            this.mChip.setAutoDisconnect(false);
            int UARTRateDiv = SPEED_OF_UART / baudRate;
            int m = 1;
            for (n = UARTRateDiv; n > 48; n >>= 1) {
                m <<= 1;
            }
            this.mRegister.write((byte[][])new byte[][]{{ADDRESS_UART_BYTE_CONFIGURATION, (byte)(UART_StopLen & STOP_BITS | UART_Parity & PARITY)}, {ADDRESS_UART_DIVISOR_M, (byte)m}, {ADDRESS_UART_DIVISOR_N, (byte)n}});
            this.mChip.setAutoDisconnect(ad);
            this.setMode(UART_Mode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public class Builder {
        private UartProvider iUart;
        private int baudRate;
        private int stopLen;
        private int parity;
        private int mode;

        Builder(UartProvider iUart) {
            this.iUart = iUart;
            this.baudRate = 115200;
            this.stopLen = StopBits_1;
            this.parity = Parity_None;
            this.mode = Mode_Rx | Mode_Tx;
        }

        public Builder setBaudRate(int baudRate) {
            this.baudRate = baudRate;
            return this;
        }

        public Builder setStopLength(int stopLen) {
            this.stopLen = stopLen;
            return this;
        }

        public Builder setParity(int parity) {
            this.parity = parity;
            return this;
        }

        public Builder setMode(int mode) {
            this.mode = mode;
            return this;
        }

        public void build() {
            this.iUart.initUART(this.baudRate, this.stopLen, this.parity, this.mode);
        }
    }
}

