/*
 * Decompiled with CFR 0.152.
 */
package th.co.sic.module.nfc.sic4310;

import th.co.sic.module.nfc.Define;
import th.co.sic.module.nfc.Provider;
import th.co.sic.module.nfc.SicChip;

public class Peripheral
extends Provider {
    public static final byte CONFIG_PW_LV = Define.Bit.parseBit((int[])new int[]{5, 4});
    public static final byte CONFIG_PWCHK_EN = Define.Bit.parseBit((int[])new int[]{2});
    public static final byte CONFIG_LDO_EN = Define.Bit.parseBit((int[])new int[]{1});
    public static final byte CONFIG_OSC_EN = Define.Bit.parseBit((int[])new int[]{0});
    public static final byte ADJUSTMENT_LDO_D_LV = Define.Bit.parseBit((int[])new int[]{2});
    public static final byte ADJUSTMENT_RFLM_LV = Define.Bit.parseBit((int[])new int[]{1});
    public static final byte ADJUSTMENT_RESP_2B_FLAG = Define.Bit.parseBit((int[])new int[]{0});
    public static final byte PowerLv_500_UA = Define.Bit.parseBit();
    public static final byte PowerLv_1250_UA = Define.Bit.parseBit((int[])new int[]{4});
    public static final byte PowerLv_2500_UA = Define.Bit.parseBit((int[])new int[]{5});
    public static final byte PowerLv_5000_UA = Define.Bit.parseBit((int[])new int[]{5, 4});
    public static final byte PowerCheck_Disable = Define.Bit.parseBit();
    public static final byte PowerCheck_Enable = Define.Bit.parseBit((int[])new int[]{2});
    public static final byte LDO_Disable = Define.Bit.parseBit();
    public static final byte LDO_Enable = Define.Bit.parseBit((int[])new int[]{1});
    public static final byte OSC_Disable = Define.Bit.parseBit();
    public static final byte OSC_Enable = Define.Bit.parseBit((int[])new int[]{0});
    public static final byte LDODropLv_2_4 = Define.Bit.parseBit();
    public static final byte LDODropLv_2_7 = Define.Bit.parseBit((int[])new int[]{2});
    public static final byte RFLimitLv_5_2 = Define.Bit.parseBit();
    public static final byte RFLimitLv_6_5 = Define.Bit.parseBit((int[])new int[]{1});
    public static final byte RespBitFlag_1 = Define.Bit.parseBit();
    public static final byte RespBitFlag_2 = Define.Bit.parseBit((int[])new int[]{0});
    private static final String TAG = Peripheral.class.getName();
    private static Peripheral instance;

    private Peripheral(SicChip chip) {
        super(chip.getRegister());
    }

    public static Peripheral getInstance(SicChip chip) {
        if (instance == null) {
            instance = new Peripheral(chip);
        }
        return instance;
    }

    protected void setRegisterAddress() {
    }

    protected void setDefaultBit() {
    }

    public void setPowerLevel(int PW_Level) {
        this.mRegister.writeParams(13, (int)CONFIG_PW_LV, PW_Level);
    }

    public void setPowerCheckEnabled(boolean enabled) {
        if (enabled) {
            this.mRegister.writeParams(13, (int)CONFIG_PWCHK_EN, (int)PowerCheck_Enable);
        } else {
            this.mRegister.writeParams(13, (int)CONFIG_PWCHK_EN, (int)PowerCheck_Disable);
        }
    }

    public void setLDORegulatorEnabled(boolean enabled) {
        if (enabled) {
            this.mRegister.writeParams(13, (int)CONFIG_LDO_EN, (int)LDO_Enable);
        } else {
            this.mRegister.writeParams(13, (int)CONFIG_LDO_EN, (int)LDO_Disable);
        }
    }

    public void setUARTOscillatorEnabled(boolean enabled) {
        if (enabled) {
            this.mRegister.writeParams(13, (int)CONFIG_OSC_EN, (int)OSC_Enable);
        } else {
            this.mRegister.writeParams(13, (int)CONFIG_OSC_EN, (int)OSC_Disable);
        }
    }

    public void setVoltageDropLevel(int LDO_DropLevel) {
        this.mRegister.writeParams(14, (int)ADJUSTMENT_LDO_D_LV, LDO_DropLevel);
    }

    public void setRFLimiterLevel(int RFLM_Level) {
        this.mRegister.writeParams(13, (int)ADJUSTMENT_RFLM_LV, RFLM_Level);
    }

    public void setResponseFlags(int RESP_Flag) {
        this.mRegister.writeParams(13, (int)ADJUSTMENT_RESP_2B_FLAG, RESP_Flag);
    }
}

