/*
 * Decompiled with CFR 0.152.
 */
package th.co.sic.module.nfc.sic4310;

import th.co.sic.module.nfc.Define;
import th.co.sic.module.nfc.providers.UartProvider;
import th.co.sic.module.nfc.sic4310.Gpio;
import th.co.sic.module.nfc.sic4310.Sic4310;

public class Uart
extends UartProvider {
    private static final String TAG = Uart.class.getSimpleName();
    private static Uart instance;

    private Uart(Sic4310 sic4310) {
        super(sic4310);
    }

    public static Uart getInstance(Sic4310 sic4310) {
        if (instance == null) {
            instance = new Uart(sic4310);
        }
        return instance;
    }

    protected void setRegisterAddress() {
        UartProvider.ADDRESS_TRXRU_RESPONSE_TIME = (byte)3;
        UartProvider.ADDRESS_UART_BYTE_CONFIGURATION = (byte)4;
        UartProvider.ADDRESS_UART_DIVISOR_M = (byte)5;
        UartProvider.ADDRESS_UART_DIVISOR_N = (byte)6;
    }

    protected void setDefaultBit() {
        UartProvider.SPEED_OF_UART = 1843200;
        UartProvider.MAX_SIZE_FIFO = 64;
        UartProvider.TRXRU_RESPONSE_TIME = Define.Bit.parseBit((int[])new int[]{3, 2, 1, 0});
        UartProvider.STOP_BITS = Define.Bit.parseBit((int[])new int[]{3});
        UartProvider.PARITY = Define.Bit.parseBit((int[])new int[]{2, 1, 0});
        UartProvider.TRxRURespTimeShiftBit = 0;
        UartProvider.StopBits_1 = Define.Bit.parseBit();
        UartProvider.StopBits_2 = Define.Bit.parseBit((int[])new int[]{3});
        UartProvider.Parity_None = Define.Bit.parseBit();
        UartProvider.Parity_Space = Define.Bit.parseBit((int[])new int[]{2});
        UartProvider.Parity_Mask = Define.Bit.parseBit((int[])new int[]{2, 0});
        UartProvider.Parity_Even = Define.Bit.parseBit((int[])new int[]{2, 1});
        UartProvider.Parity_Odd = Define.Bit.parseBit((int[])new int[]{2, 1, 0});
        UartProvider.Mode_CTS = Gpio.Pin_UART_CTS;
        UartProvider.Mode_Tx = Gpio.Pin_UART_TXD;
        UartProvider.Mode_Rx = Gpio.Pin_UART_RXD;
        UartProvider.Mode_RTS = Gpio.Pin_UART_RTS;
    }

    @Override
    public byte getMode() {
        int direction = this.mRegister.readBuffer(8) & 0xF;
        int mode = this.mRegister.readBuffer(9) & 0xF;
        return (byte)((~direction & 5 | direction & 0xA) & mode);
    }

    @Override
    public void setMode(int UART_Mode) {
        int direction = UART_Mode & 0xA | ~UART_Mode & this.mRegister.readBuffer(8);
        int mode = UART_Mode & 0xF | ~UART_Mode & this.mRegister.readBuffer(9);
        this.mRegister.write(8, direction);
        this.mRegister.write(9, mode);
    }
}

