/*
 * Decompiled with CFR 0.152.
 */
package th.co.sic.module.nfc.sic4310;

import th.co.sic.module.nfc.Define;
import th.co.sic.module.nfc.SicChip;
import th.co.sic.module.nfc.providers.StatusProvider;

public class Status
extends StatusProvider {
    public static final byte CTS = Define.BIT5;
    public static final byte RTS = Define.BIT4;
    public static final byte DL_FF_EMT = Define.BIT3;
    public static final byte DL_FF_OVF = Define.BIT2;
    public static final byte UL_FF_EMT = Define.BIT1;
    public static final byte UL_FF_OVF = Define.BIT0;
    public static final byte UART_RDY = Define.BIT3;
    private static final String TAG = Status.class.getName();
    private static Status instance;

    private Status(SicChip chip) {
        super(chip);
    }

    public static Status getInstance(SicChip chip) {
        if (instance == null) {
            instance = new Status(chip);
        }
        return instance;
    }

    protected void setRegisterAddress() {
        StatusProvider.ADDRESS_POWER_STATUS = 1;
    }

    protected void setDefaultBit() {
        StatusProvider.SCAP_RDY = Define.BIT4;
        StatusProvider.XVDD_RDY = Define.BIT2;
        StatusProvider.RSPW_RDY = Define.BIT1;
        StatusProvider.LDO_ON = Define.BIT0;
    }

    public Byte getUARTStatus() {
        return this.getStatus(StatusProvider.ADDRESS_POWER_STATUS);
    }

    public boolean isPowerUARTReady() {
        Byte flag = this.getPowerStatus();
        return flag != null && (flag & UART_RDY) == UART_RDY;
    }

    public boolean isExternalUARTReady() {
        Byte flag = this.getUARTStatus();
        return flag != null && (flag & CTS) == CTS;
    }

    public boolean isUplinkFIFOReady() {
        Byte flag = this.getUARTStatus();
        return flag != null && (flag & RTS) == RTS;
    }

    public boolean isDownlinkFIFOEmpty() {
        Byte flag = this.getUARTStatus();
        return flag != null && (flag & DL_FF_EMT) == DL_FF_EMT;
    }

    public boolean isDownlinkFIFOOverflow() {
        Byte flag = this.getUARTStatus();
        return flag != null && (flag & DL_FF_OVF) == DL_FF_OVF;
    }

    public boolean isUplinkFIFOEmpty() {
        Byte flag = this.getUARTStatus();
        return flag != null && (flag & UL_FF_EMT) == UL_FF_EMT;
    }

    public boolean isUplinkFIFOOverflow() {
        Byte flag = this.getUARTStatus();
        return flag != null && (flag & UL_FF_OVF) == UL_FF_OVF;
    }
}

