/*
 * Decompiled with CFR 0.152.
 */
package th.co.sic.module.nfc.sic4310;

import th.co.sic.module.nfc.SicChip;
import th.co.sic.module.nfc.sic4310.Gpio;
import th.co.sic.module.nfc.sic4310.Peripheral;
import th.co.sic.module.nfc.sic4310.Register;
import th.co.sic.module.nfc.sic4310.Status;
import th.co.sic.module.nfc.sic4310.Uart;

public class Sic4310
extends SicChip {
    private static final String TAG = Sic4310.class.getSimpleName();
    private static Sic4310 instance;
    private Gpio mGpio;
    private Uart mUart;
    private Status mStatus;
    private Peripheral mPeripheral;

    private Sic4310() {
    }

    public static Sic4310 getInstance() {
        if (instance == null) {
            instance = new Sic4310();
        }
        return instance;
    }

    public boolean checkedUid() {
        byte[] uid = this.mNfcA.getTag().getId();
        return uid != null && uid.length == 7 && uid[1] == 2 && super.checkedUid();
    }

    protected void setPeripheral() {
        this.mRegister = Register.getInstance(this);
        this.mPeripheral = Peripheral.getInstance(this);
        this.mStatus = Status.getInstance(this);
        this.mGpio = Gpio.getInstance(this);
        this.mUart = Uart.getInstance(this);
    }

    public Register register() {
        return (Register)this.mRegister;
    }

    public Peripheral peripheral() {
        return this.mPeripheral;
    }

    public Gpio gpio() {
        return this.mGpio;
    }

    public Uart uart() {
        return this.mUart;
    }

    public Status status() {
        return this.mStatus;
    }

    public boolean isDownlinkFifoOverflow() {
        int flag = -127;
        return (this.response & flag) == flag;
    }

    public boolean isUplinkFifoEmpty() {
        int flag = -126;
        return (this.response & flag) == flag;
    }

    public boolean isUplinkFifoOverflow() {
        int flag = -124;
        return (this.response & flag) == flag;
    }

    public boolean isInsufficientPowerToSourceLoad() {
        int flag = -120;
        return (this.response & flag) == flag;
    }

    public boolean isVoltageOnXVddDrop() {
        int flag = -112;
        return (this.response & flag) == flag;
    }

    public boolean isUartFail() {
        int flag = -96;
        return (this.response & flag) == flag;
    }
}

