/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.query;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.springframework.core.CollectionFactory;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.data.domain.Slice;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class MyResultProcessor {
    private final ProjectingConverter converter;
    private final ProjectionFactory factory;
    private final ReturnedType type;

    public MyResultProcessor(ProjectionFactory factory, ReturnedType type) {
        this.converter = new ProjectingConverter(type, factory).withType(type);
        this.factory = factory;
        this.type = type;
    }

    public <T> T processResult(@Nullable Object source, Converter<Object, Object> preparingConverter) {
        if (source == null || this.type.isInstance(source) || !this.type.isProjecting()) {
            return (T)source;
        }
        Assert.notNull(preparingConverter, (String)"Preparing converter must not be null!");
        ChainingConverter converter = ChainingConverter.of(this.type.getReturnedType(), preparingConverter).and(this.converter);
        if (source instanceof Slice) {
            return (T)((Slice)source).map(converter::convert);
        }
        if (source instanceof Collection) {
            Collection collection = (Collection)source;
            Collection<Object> target = MyResultProcessor.createCollectionFor(collection);
            for (Object columns : collection) {
                target.add(this.type.isInstance(columns) ? columns : converter.convert(columns));
            }
            return (T)target;
        }
        return (T)converter.convert(source);
    }

    private static Collection<Object> createCollectionFor(Collection<?> source) {
        try {
            return CollectionFactory.createCollection(source.getClass(), (int)source.size());
        }
        catch (RuntimeException o_O) {
            return CollectionFactory.createApproximateCollection(source, (int)source.size());
        }
    }

    private static class ProjectingConverter
    implements Converter<Object, Object> {
        @NonNull
        private final ReturnedType type;
        @NonNull
        private final ProjectionFactory factory;
        @NonNull
        private final ConversionService conversionService;

        ProjectingConverter(ReturnedType type, ProjectionFactory factory) {
            this(type, factory, DefaultConversionService.getSharedInstance());
        }

        ProjectingConverter withType(ReturnedType type) {
            Assert.notNull((Object)type, (String)"ReturnedType must not be null!");
            return new ProjectingConverter(type, this.factory, this.conversionService);
        }

        @Nullable
        public Object convert(Object source) {
            Class targetType = this.type.getReturnedType();
            if (targetType.isInterface()) {
                return this.factory.createProjection(targetType, this.getProjectionTarget(source));
            }
            return this.conversionService.convert(source, targetType);
        }

        private Object getProjectionTarget(Object source) {
            if (source != null && source.getClass().isArray()) {
                source = Arrays.asList((Object[])source);
            }
            if (source instanceof Collection) {
                return ProjectingConverter.toMap((Collection)source, this.type.getInputProperties());
            }
            return source;
        }

        private static Map<String, Object> toMap(Collection<?> values, List<String> names) {
            int i = 0;
            HashMap<String, Object> result = new HashMap<String, Object>(values.size());
            for (Object element : values) {
                result.put(names.get(i++), element);
            }
            return result;
        }

        public ProjectingConverter(@NonNull ReturnedType type, @NonNull ProjectionFactory factory, @NonNull ConversionService conversionService) {
            if (type == null) {
                throw new NullPointerException("type is marked @NonNull but is null");
            }
            if (factory == null) {
                throw new NullPointerException("factory is marked @NonNull but is null");
            }
            if (conversionService == null) {
                throw new NullPointerException("conversionService is marked @NonNull but is null");
            }
            this.type = type;
            this.factory = factory;
            this.conversionService = conversionService;
        }
    }

    private static class ChainingConverter
    implements Converter<Object, Object> {
        @NonNull
        private final Class<?> targetType;
        @NonNull
        private final Converter<Object, Object> delegate;

        public ChainingConverter and(Converter<Object, Object> converter) {
            Assert.notNull(converter, (String)"Converter must not be null!");
            return new ChainingConverter(this.targetType, (Converter<Object, Object>)((Converter)source -> {
                Object intermediate = this.convert(source);
                return intermediate == null || this.targetType.isInstance(intermediate) ? intermediate : converter.convert(intermediate);
            }));
        }

        @Nullable
        public Object convert(Object source) {
            return this.delegate.convert(source);
        }

        private ChainingConverter(@NonNull Class<?> targetType, @NonNull Converter<Object, Object> delegate) {
            if (targetType == null) {
                throw new NullPointerException("targetType is marked @NonNull but is null");
            }
            if (delegate == null) {
                throw new NullPointerException("delegate is marked @NonNull but is null");
            }
            this.targetType = targetType;
            this.delegate = delegate;
        }

        public static ChainingConverter of(@NonNull Class<?> targetType, @NonNull Converter<Object, Object> delegate) {
            return new ChainingConverter(targetType, delegate);
        }
    }
}

