/*
 * Decompiled with CFR 0.152.
 */
package com.testdroid.jenkins.utils;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.testdroid.jenkins.auth.BitbarCredentials;
import com.testdroid.jenkins.auth.IBitbarCredentials;
import hudson.model.ItemGroup;
import hudson.security.ACL;
import hudson.util.Secret;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;

public final class BitbarCredentialsUtils {
    private BitbarCredentialsUtils() {
        throw new IllegalStateException("Utility class");
    }

    @Nonnull
    public static BitbarCredentials getBitbarCredentials(String credentialsId) {
        if (Objects.isNull(credentialsId)) {
            return BitbarCredentials.EMPTY;
        }
        List credentialsList = CredentialsProvider.lookupCredentials(IBitbarCredentials.class, (ItemGroup)Jenkins.get(), (Authentication)ACL.SYSTEM, Collections.emptyList());
        return Optional.ofNullable((IBitbarCredentials)CredentialsMatchers.firstOrNull((Iterable)credentialsList, (CredentialsMatcher)CredentialsMatchers.withId((String)credentialsId))).map(IBitbarCredentials::getCredentials).orElse(BitbarCredentials.EMPTY);
    }

    @Nonnull
    public static String getSecretText(Secret secret) {
        return Objects.nonNull(secret) ? secret.getPlainText() : "";
    }
}

