/*
 * Decompiled with CFR 0.152.
 */
package com.testdroid.jenkins.remotesupport;

import com.testdroid.api.APIException;
import com.testdroid.api.APIListResource;
import com.testdroid.api.dto.Context;
import com.testdroid.api.model.APIDeviceSession;
import com.testdroid.api.model.APIScreenshot;
import com.testdroid.api.model.APITestRun;
import com.testdroid.jenkins.Messages;
import com.testdroid.jenkins.TestdroidCloudSettings;
import com.testdroid.jenkins.auth.TestdroidApiUtil;
import com.testdroid.jenkins.remotesupport.MachineIndependentTask;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.jenkinsci.remoting.RoleChecker;

public class MachineIndependentResultsDownloader
extends MachineIndependentTask
implements Callable<Boolean, APIException> {
    private static final Logger LOGGER = Logger.getLogger(MachineIndependentResultsDownloader.class.getName());
    private boolean downloadScreenshots;
    private TaskListener listener;
    private long projectId;
    private String resultsPath;
    private long testRunId;

    public MachineIndependentResultsDownloader(TestdroidCloudSettings.DescriptorImpl settings, TaskListener listener, long projectId, long testRunId, String resultsPath, boolean downloadScreenshots) {
        super(settings);
        this.projectId = projectId;
        this.testRunId = testRunId;
        this.resultsPath = resultsPath;
        this.downloadScreenshots = downloadScreenshots;
        this.listener = listener;
    }

    public void checkRoles(RoleChecker checker) throws SecurityException {
    }

    public Boolean call() throws APIException {
        APITestRun testRun = TestdroidApiUtil.createNewApiClient(this).getUser().getProject(Long.valueOf(this.projectId)).getTestRun(Long.valueOf(this.testRunId));
        boolean success = false;
        APIListResource deviceSessionsResource = testRun.getDeviceSessionsResource(new Context(APIDeviceSession.class, 0, Integer.MAX_VALUE, "", ""));
        for (APIDeviceSession deviceSession : deviceSessionsResource.getEntity().getData()) {
            String deviceDisplayName = deviceSession.getDevice().getDisplayName();
            File resultDir = new File(String.format("%s/testdroid_result-%s-%d", this.resultsPath.endsWith(File.pathSeparator) ? this.resultsPath.substring(0, this.resultsPath.length() - File.pathSeparator.length()) : this.resultsPath, deviceDisplayName.replaceAll(" ", "_"), deviceSession.getId()));
            if (deviceSession.getState() != APIDeviceSession.State.EXCLUDED) {
                success = this.download(deviceSession.getOutputFiles(), resultDir, "results.zip", deviceDisplayName);
                if (!this.downloadScreenshots) continue;
                resultDir = new File(resultDir, "screenshots");
                APIListResource screenshotsResource = deviceSession.getScreenshotsResource(new Context(APIScreenshot.class, 0, Integer.MAX_VALUE, "", ""));
                for (APIScreenshot screenshot : screenshotsResource.getEntity().getData()) {
                    this.download(screenshot.getContent(), resultDir, screenshot.getOriginalName(), deviceDisplayName);
                }
                continue;
            }
            this.listener.getLogger().println(String.format(Messages.NO_RESULT_FROM_DEVICE_TEST_WAS_NOT_LAUNCHED_S(), deviceDisplayName));
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean download(InputStream inputStream, File resultDir, String fileName, String deviceName) {
        boolean bl;
        FileOutputStream outputStream = null;
        try {
            FileUtils.forceMkdir((File)resultDir);
            outputStream = new FileOutputStream(new File(resultDir, fileName));
            IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
            bl = true;
        }
        catch (Exception e) {
            try {
                String msg = String.format(Messages.ERROR_DURING_DOWNLOAD_S_FROM_S(), fileName, deviceName);
                this.listener.getLogger().println(msg);
                LOGGER.log(Level.WARNING, msg, e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(outputStream);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)outputStream);
            return false;
        }
        IOUtils.closeQuietly((OutputStream)outputStream);
        return bl;
    }
}

