/*
 * Decompiled with CFR 0.152.
 */
package com.testdroid.jenkins.scheduler;

import com.testdroid.api.APIException;
import com.testdroid.api.model.APITestRun;
import com.testdroid.jenkins.Messages;
import com.testdroid.jenkins.scheduler.TestRunFinishCheckScheduler;
import hudson.model.TaskListener;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class APIDrivenTestFinishCheckScheduler
implements TestRunFinishCheckScheduler {
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private ScheduledFuture<?> taskHandle;
    private final TaskListener listener;

    public APIDrivenTestFinishCheckScheduler(TaskListener listener) {
        this.listener = listener;
    }

    @Override
    public void schedule(Object object, APITestRun apiTestRun) {
        Runnable beeper = () -> {
            Object object2 = object;
            synchronized (object2) {
                if (this.checkResult(apiTestRun)) {
                    object.notify();
                }
            }
        };
        this.taskHandle = this.scheduler.scheduleAtFixedRate(beeper, 60L, 45L, TimeUnit.SECONDS);
    }

    @Override
    public void cancel(APITestRun apiTestRun) {
        if (this.taskHandle != null) {
            this.taskHandle.cancel(true);
        }
    }

    private boolean checkResult(APITestRun apiTestRun) {
        boolean result = false;
        try {
            this.listener.getLogger().println(Messages.CHECK_FOR_TESTRUN_STATE(apiTestRun.getId()));
            apiTestRun.refresh();
            this.listener.getLogger().println(Messages.TEST_RUN_STATE(apiTestRun.getId(), apiTestRun.getState()));
            if (apiTestRun.getState() == APITestRun.State.FINISHED) {
                result = true;
            }
        }
        catch (APIException exc) {
            this.listener.getLogger().println(Messages.API_GET_TESTRUN_ERROR(apiTestRun.getId(), exc.getStackTrace()));
            result = true;
        }
        return result;
    }
}

