/*
 * Decompiled with CFR 0.152.
 */
package com.testdroid.jenkins;

import com.testdroid.jenkins.utils.VersionString;
import hudson.model.BuildBadgeAction;
import org.apache.commons.lang.StringUtils;

public class CloudLink
implements BuildBadgeAction {
    private static final String PRE_254_ENDPOINT_FORMAT = "%s/#service/testrun/%s/%s";
    private static final String POST_254_ENDPOINT_FORMAT = "%s/#testing/test-run/%s/%s";
    private String cloudLink;

    public CloudLink(String cloudURL, Long projectId, Long testRunId, String cloudVersion) {
        VersionString v254 = new VersionString("2.54");
        VersionString currentVersion = new VersionString(cloudVersion);
        this.cloudLink = StringUtils.isBlank((String)cloudVersion) || currentVersion.compareTo(v254) >= 0 ? String.format(POST_254_ENDPOINT_FORMAT, cloudURL, projectId, testRunId) : String.format(PRE_254_ENDPOINT_FORMAT, cloudURL, projectId, testRunId);
    }

    public boolean hasLink() {
        return this.cloudLink != null;
    }

    public String getIconFileName() {
        return "/plugin/testdroid-run-in-cloud/images/cloud.gif";
    }

    public String getDisplayName() {
        return "See detailed results in Bitbar Cloud";
    }

    public String getUrlName() {
        return this.cloudLink;
    }
}

