/*
 * Decompiled with CFR 0.152.
 */
package com.testdroid.jenkins.utils;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;

public class VersionString
implements Comparable<VersionString> {
    private final String version;

    public VersionString(String version) {
        this.version = StringUtils.defaultIfBlank((String)version, (String)"");
    }

    private String zeroPad(String s, int len) {
        return StringUtils.leftPad((String)s, (int)len, (char)'0');
    }

    @Override
    public int compareTo(VersionString v2) {
        String[] parts1 = this.version.split("\\.|-");
        String[] parts2 = v2.version.split("\\.|-");
        int maxLen1 = Arrays.stream(parts1).max(Comparator.comparingInt(String::length)).get().length();
        int maxLen2 = Arrays.stream(parts2).max(Comparator.comparingInt(String::length)).get().length();
        int maxLen = Math.max(maxLen1, maxLen2);
        int comparison = 0;
        for (int i = 0; i < parts1.length && i < parts2.length && comparison == 0; ++i) {
            comparison = this.zeroPad(parts1[i], maxLen).compareTo(this.zeroPad(parts2[i], maxLen));
        }
        return comparison != 0 ? comparison : Integer.compare(parts1.length, parts2.length);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VersionString that = (VersionString)o;
        return Objects.equals(this.version, that.version);
    }

    public int hashCode() {
        return Objects.hash(this.version);
    }
}

