/*
 * Decompiled with CFR 0.152.
 */
package com.testdroid.jenkins;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.testdroid.api.APIException;
import com.testdroid.api.APIListResource;
import com.testdroid.api.dto.Context;
import com.testdroid.api.dto.Operand;
import com.testdroid.api.filter.BooleanFilterEntry;
import com.testdroid.api.filter.FilterEntry;
import com.testdroid.api.filter.StringFilterEntry;
import com.testdroid.api.model.APIDevice;
import com.testdroid.api.model.APIDeviceGroup;
import com.testdroid.api.model.APIFileConfig;
import com.testdroid.api.model.APIFramework;
import com.testdroid.api.model.APIProject;
import com.testdroid.api.model.APITestRun;
import com.testdroid.api.model.APITestRunConfig;
import com.testdroid.api.model.APITestRunParameter;
import com.testdroid.api.model.APIUser;
import com.testdroid.jenkins.AbstractBuilder;
import com.testdroid.jenkins.CloudLink;
import com.testdroid.jenkins.Messages;
import com.testdroid.jenkins.RunInCloudEnvInject;
import com.testdroid.jenkins.TestdroidCloudSettings;
import com.testdroid.jenkins.WaitForResultsBlock;
import com.testdroid.jenkins.model.TestRunStateCheckMethod;
import com.testdroid.jenkins.remotesupport.MachineIndependentFileUploader;
import com.testdroid.jenkins.remotesupport.MachineIndependentResultsDownloader;
import com.testdroid.jenkins.scheduler.TestRunFinishCheckScheduler;
import com.testdroid.jenkins.scheduler.TestRunFinishCheckSchedulerFactory;
import com.testdroid.jenkins.utils.AndroidLocale;
import com.testdroid.jenkins.utils.ApiClientAdapter;
import com.testdroid.jenkins.utils.LocaleUtil;
import com.testdroid.jenkins.utils.TestdroidApiUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Semaphore;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class RunInCloudBuilder
extends AbstractBuilder {
    private static final Logger LOGGER = Logger.getLogger(RunInCloudBuilder.class.getSimpleName());
    private static final String POST_HOOK_URL = "/plugin/testdroid-run-in-cloud/api/json/cloud-webhook";
    private static final String DEFAULT_TEST_TIMEOUT = "600";
    private static final Semaphore semaphore = new Semaphore(1);
    private static final List<String> PAID_ROLES = Arrays.asList("PRIORITY_SILVER", "PRIORITY_GOLD", "PRIORITY_PLATINUM");
    private String appPath;
    private String clusterId;
    private String dataPath;
    private boolean failBuildIfThisStepFailed;
    private String keyValuePairs;
    private String language;
    private String projectId;
    private String scheduler;
    private String screenshotsDirectory;
    private String testCasesSelect;
    private String testCasesValue;
    private String testPath;
    private String testRunName;
    private String testRunner;
    private WaitForResultsBlock waitForResultsBlock;
    private String withAnnotation;
    private String withoutAnnotation;
    private String testTimeout;
    private String credentialsId;
    private String cloudUrl;
    private Long frameworkId;
    private APIDevice.OsType osType;
    private String cloudUIUrl;

    public String getCloudUIUrl() {
        return this.cloudUIUrl;
    }

    public void setCloudUIUrl(String cloudUIUrl) {
        this.cloudUIUrl = cloudUIUrl;
    }

    @DataBoundConstructor
    public RunInCloudBuilder(String projectId, String appPath, String testPath, String dataPath, String testRunName, String scheduler, String testRunner, String clusterId, String language, String screenshotsDirectory, String keyValuePairs, String withAnnotation, String withoutAnnotation, String testCasesSelect, String testCasesValue, Boolean failBuildIfThisStepFailed, WaitForResultsBlock waitForResultsBlock, String testTimeout, String credentialsId, String cloudUrl, String cloudUIUrl, Long frameworkId, APIDevice.OsType osType) {
        this.projectId = projectId;
        this.appPath = appPath;
        this.dataPath = dataPath;
        this.testPath = testPath;
        this.testRunName = testRunName;
        this.scheduler = scheduler;
        this.testRunner = testRunner;
        this.screenshotsDirectory = screenshotsDirectory;
        this.keyValuePairs = keyValuePairs;
        this.withAnnotation = withAnnotation;
        this.withoutAnnotation = withoutAnnotation;
        this.testCasesSelect = testCasesSelect;
        this.testCasesValue = testCasesValue;
        this.clusterId = clusterId;
        this.language = language;
        this.failBuildIfThisStepFailed = failBuildIfThisStepFailed;
        this.testTimeout = testTimeout;
        this.credentialsId = credentialsId;
        this.cloudUrl = cloudUrl;
        this.frameworkId = frameworkId;
        this.osType = osType;
        this.waitForResultsBlock = waitForResultsBlock;
        this.cloudUIUrl = cloudUIUrl;
    }

    public String getTestRunName() {
        return this.testRunName;
    }

    public void setTestRunName(String testRunName) {
        this.testRunName = testRunName;
    }

    public String getAppPath() {
        return this.appPath;
    }

    public void setAppPath(String appPath) {
        this.appPath = appPath;
    }

    public String getTestPath() {
        return this.testPath;
    }

    public void setTestPath(String testPath) {
        this.testPath = testPath;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public void setClusterId(String clusterId) {
        this.clusterId = clusterId;
    }

    public String getTestRunner() {
        return this.testRunner;
    }

    public void setTestRunner(String testRunner) {
        this.testRunner = testRunner;
    }

    public String getScreenshotsDirectory() {
        return this.screenshotsDirectory;
    }

    public void setScreenshotsDirectory(String screenshotsDirectory) {
        this.screenshotsDirectory = screenshotsDirectory;
    }

    public String getKeyValuePairs() {
        return this.keyValuePairs;
    }

    public void setKeyValuePairs(String keyValuePairs) {
        this.keyValuePairs = keyValuePairs;
    }

    public String getWithAnnotation() {
        return this.withAnnotation;
    }

    public void setWithAnnotation(String withAnnotation) {
        this.withAnnotation = withAnnotation;
    }

    public String getWithoutAnnotation() {
        return this.withoutAnnotation;
    }

    public void setWithoutAnnotation(String withoutAnnotation) {
        this.withoutAnnotation = withoutAnnotation;
    }

    public String getTestCasesSelect() {
        if (StringUtils.isBlank((String)this.testCasesSelect)) {
            return APITestRunConfig.LimitationType.PACKAGE.name();
        }
        return this.testCasesSelect;
    }

    public void setTestCasesSelect(String testCasesSelect) {
        this.testCasesSelect = testCasesSelect;
    }

    public String getTestCasesValue() {
        return this.testCasesValue;
    }

    public void setTestCasesValue(String testCasesValue) {
        this.testCasesValue = testCasesValue;
    }

    public String getDataPath() {
        return this.dataPath;
    }

    public void setDataPath(String dataPath) {
        this.dataPath = dataPath;
    }

    public String getLanguage() {
        if (StringUtils.isBlank((String)this.language)) {
            this.language = LocaleUtil.formatLangCode(Locale.US);
        }
        if (this.language.contains("-")) {
            this.language = this.language.replace('-', '_');
        }
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getScheduler() {
        if (StringUtils.isBlank((String)this.scheduler)) {
            this.scheduler = APITestRunConfig.Scheduler.PARALLEL.name();
        }
        return this.scheduler;
    }

    public void setScheduler(String scheduler) {
        this.scheduler = scheduler.toLowerCase();
    }

    public String getTestTimeout() {
        if (StringUtils.isBlank((String)this.testTimeout)) {
            return DEFAULT_TEST_TIMEOUT;
        }
        return this.testTimeout;
    }

    public void setTestTimeout(String testTimeout) {
        this.testTimeout = testTimeout;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public void setCredentialsId(String credentialsId) {
        this.credentialsId = credentialsId;
    }

    public String getCloudUrl() {
        return this.cloudUrl;
    }

    public void setCloudUrl(String cloudUrl) {
        this.cloudUrl = cloudUrl;
    }

    public WaitForResultsBlock getWaitForResultsBlock() {
        return this.waitForResultsBlock;
    }

    public void setWaitForResultsBlock(WaitForResultsBlock waitForResultsBlock) {
        this.waitForResultsBlock = waitForResultsBlock;
    }

    public boolean isFailBuildIfThisStepFailed() {
        return this.failBuildIfThisStepFailed;
    }

    public void setFailBuildIfThisStepFailed(boolean failBuildIfThisStepFailed) {
        this.failBuildIfThisStepFailed = failBuildIfThisStepFailed;
    }

    public boolean isFullTest() {
        return StringUtils.isNotBlank((String)this.testPath);
    }

    public boolean isDataFile() {
        return StringUtils.isNotBlank((String)this.dataPath);
    }

    private boolean verifyParameters(TaskListener listener) {
        boolean result = true;
        if (StringUtils.isBlank((String)this.projectId)) {
            listener.getLogger().println(Messages.EMPTY_PROJECT() + "\n");
            result = false;
        }
        return result;
    }

    public boolean isWaitForResults() {
        return this.waitForResultsBlock != null;
    }

    public Long getFrameworkId() {
        return this.frameworkId;
    }

    public void setFrameworkId(Long frameworkId) {
        this.frameworkId = frameworkId;
    }

    public APIDevice.OsType getOsType() {
        if (this.osType == null) {
            this.osType = APIDevice.OsType.UNDEFINED;
        }
        return this.osType;
    }

    public void setOsType(APIDevice.OsType osType) {
        this.osType = osType;
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    private String evaluateHookUrl() {
        return this.isWaitForResults() ? (StringUtils.isNotBlank((String)this.waitForResultsBlock.getHookURL()) ? this.waitForResultsBlock.getHookURL() : String.format("%s%s", Jenkins.getInstance().getRootUrl(), POST_HOOK_URL)) : null;
    }

    private String evaluateResultsPath(FilePath workspace) {
        if (this.isWaitForResults()) {
            String resultsPath = this.waitForResultsBlock.getResultsPath();
            if (StringUtils.isNotBlank((String)resultsPath)) {
                try {
                    return this.getAbsolutePath(workspace, resultsPath);
                }
                catch (Exception exception) {
                    LOGGER.log(Level.WARNING, "Couldn't get absolute path for results. Using workspace...");
                }
            }
            return workspace.getRemote();
        }
        return null;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        return this.completeRun((Run<?, ?>)build, build.getWorkspace(), launcher, (TaskListener)listener);
    }

    public boolean completeRun(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener) {
        listener.getLogger().println(Messages.RUN_TEST_IN_CLOUD_STARTED());
        boolean result = this.runTest(build, workspace, launcher, listener);
        if (result) {
            listener.getLogger().println(Messages.RUN_TEST_IN_CLOUD_SUCCEEDED());
        } else {
            listener.getLogger().println(Messages.RUN_TEST_IN_CLOUD_FAILED());
        }
        return result || !this.failBuildIfThisStepFailed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean runTest(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener) {
        String appPathFinal = RunInCloudBuilder.applyMacro(build, listener, this.appPath);
        String testPathFinal = RunInCloudBuilder.applyMacro(build, listener, this.testPath);
        String dataPathFinal = RunInCloudBuilder.applyMacro(build, listener, this.dataPath);
        String withAnnotationFinal = RunInCloudBuilder.applyMacro(build, listener, this.withAnnotation);
        String testRunnerFinal = RunInCloudBuilder.applyMacro(build, listener, this.testRunner);
        String withoutAnnotationFinal = RunInCloudBuilder.applyMacro(build, listener, this.withoutAnnotation);
        TestdroidCloudSettings.DescriptorImpl cloudSettings = new TestdroidCloudSettings.DescriptorImpl();
        if (StringUtils.isNotBlank((String)this.getCredentialsId())) {
            StandardUsernamePasswordCredentials credentials = (StandardUsernamePasswordCredentials)CredentialsProvider.findCredentialById((String)this.getCredentialsId(), StandardUsernamePasswordCredentials.class, build, Collections.emptyList());
            if (credentials != null) {
                listener.getLogger().println(Messages.BUILD_STEP_USING_CREDENTIALS());
                cloudSettings = new TestdroidCloudSettings.DescriptorImpl(credentials.getUsername(), credentials.getPassword().getPlainText());
                if (StringUtils.isNotBlank((String)this.getCloudUrl())) {
                    cloudSettings.setCloudUrl(this.getCloudUrl());
                    if (StringUtils.isNotBlank((String)this.getCloudUIUrl())) {
                        cloudSettings.setNewCloudUrl(this.getCloudUIUrl());
                    }
                }
            } else {
                listener.getLogger().println(String.format(Messages.COULDNT_FIND_CREDENTIALS(), this.getCredentialsId()));
            }
        } else if (StringUtils.isNotBlank((String)this.cloudUrl)) {
            listener.getLogger().println(String.format(Messages.CLOUD_URL_SET_BUT_NO_CREDENTIALS(), this.cloudUrl, cloudSettings.getCloudUrl()));
        }
        boolean releaseDone = false;
        try {
            semaphore.acquire();
            ApiClientAdapter api = TestdroidApiUtil.createApiClient(cloudSettings);
            if (!api.isAuthenticated()) {
                listener.getLogger().println("Couldn't connect to the cloud!");
                boolean bl = false;
                return bl;
            }
            if (!this.verifyParameters(listener)) {
                boolean bl = false;
                return bl;
            }
            APIUser user = api.getUser();
            String cloudVersion = api.getCloudVersion();
            APIProject project = user.getProject(Long.valueOf(Long.parseLong(this.getProjectId().trim())));
            if (project == null) {
                listener.getLogger().println(Messages.CHECK_PROJECT_NAME());
                boolean bl = false;
                return bl;
            }
            APITestRunConfig config = project.getTestRunConfig();
            config.setDeviceLanguageCode(this.getLanguage());
            config.setScheduler(APITestRunConfig.Scheduler.valueOf((String)this.getScheduler().toUpperCase()));
            config.setUsedDeviceGroupId(Long.valueOf(Long.parseLong(this.getClusterId())));
            config.setDeviceIds(null);
            config.setHookURL(this.evaluateHookUrl());
            config.setScreenshotDir(this.getScreenshotsDirectory());
            config.setInstrumentationRunner(testRunnerFinal);
            config.setWithoutAnnotation(withoutAnnotationFinal);
            config.setWithAnnotation(withAnnotationFinal);
            config.setFrameworkId(Optional.ofNullable(this.frameworkId).orElse(config.getFrameworkId()));
            config.setOsType(Optional.ofNullable(this.osType).orElse(config.getOsType()));
            config.setTimeout(Long.valueOf(Long.parseLong(DEFAULT_TEST_TIMEOUT)));
            if (ApiClientAdapter.isPaidUser(user)) {
                try {
                    long runTimeout = Long.parseLong(this.getTestTimeout());
                    config.setTimeout(Long.valueOf(runTimeout));
                }
                catch (NumberFormatException e) {
                    listener.getLogger().println(Messages.TEST_TIMEOUT_NOT_NUMERIC_VALUE(this.getTestTimeout()));
                    LOGGER.log(Level.WARNING, "NumberFormatException when parsing timeout.", e);
                }
            } else {
                listener.getLogger().println(String.format(Messages.FREE_USERS_MAX_10_MINS(), user.getEmail()));
            }
            this.setLimitations(build, listener, config);
            this.createProvidedParameters(config);
            config = user.validateTestRunConfig(config);
            this.printTestJob(project, config, cloudSettings, cloudVersion, listener);
            this.getDescriptor().save();
            ArrayList<APIFileConfig> files = new ArrayList<APIFileConfig>();
            if (StringUtils.isNotBlank((String)this.getAppPath())) {
                FilePath appFile = new FilePath(launcher.getChannel(), this.getAbsolutePath(workspace, appPathFinal));
                listener.getLogger().println(String.format(Messages.UPLOADING_NEW_APPLICATION_S(), appPathFinal));
                Long appFileId = (Long)appFile.act((FilePath.FileCallable)new MachineIndependentFileUploader(cloudSettings, listener));
                if (appFileId == null) {
                    boolean bl = false;
                    return bl;
                }
                files.add(new APIFileConfig(appFileId, APIFileConfig.Action.INSTALL));
            } else {
                listener.getLogger().println("App path was blank. Using latest app in project.");
            }
            if (this.isFullTest()) {
                FilePath testFile = new FilePath(launcher.getChannel(), this.getAbsolutePath(workspace, testPathFinal));
                listener.getLogger().println(String.format(Messages.UPLOADING_NEW_INSTRUMENTATION_S(), testPathFinal));
                Long testFileId = (Long)testFile.act((FilePath.FileCallable)new MachineIndependentFileUploader(cloudSettings, listener));
                if (testFileId == null) {
                    boolean bl = false;
                    return bl;
                }
                files.add(new APIFileConfig(testFileId, APIFileConfig.Action.RUN_TEST));
            }
            if (this.isDataFile()) {
                FilePath dataFile = new FilePath(launcher.getChannel(), this.getAbsolutePath(workspace, dataPathFinal));
                listener.getLogger().println(String.format(Messages.UPLOADING_DATA_FILE_S(), dataPathFinal));
                Long dataFileId = (Long)dataFile.act((FilePath.FileCallable)new MachineIndependentFileUploader(cloudSettings, listener));
                if (dataFileId == null) {
                    boolean bl = false;
                    return bl;
                }
                files.add(new APIFileConfig(dataFileId, APIFileConfig.Action.COPY_TO_DEVICE));
            }
            listener.getLogger().println(Messages.RUNNING_TESTS());
            String finalTestRunName = RunInCloudBuilder.applyMacro(build, listener, this.getTestRunName());
            if (StringUtils.isBlank((String)finalTestRunName) || finalTestRunName.trim().startsWith("$")) {
                finalTestRunName = null;
            }
            config.setFiles(files);
            config.setTestRunName(finalTestRunName);
            config = user.validateTestRunConfig(config);
            APITestRun testRun = user.startTestRun(config);
            CloudLink cloudLinkAction = new CloudLink(cloudSettings.resolveCloudUiUrl(), project.getId(), testRun.getId(), cloudVersion);
            build.addAction((Action)cloudLinkAction);
            RunInCloudEnvInject variable = new RunInCloudEnvInject("CLOUD_LINK", cloudLinkAction.getUrlName());
            build.addAction((Action)variable);
            listener.getLogger().println(String.format("Started new Bitbar Cloud run at: %s (id: %s)", cloudLinkAction.getUrlName(), testRun.getId()));
            semaphore.release();
            releaseDone = true;
            boolean bl = this.waitForResults(user, project, testRun, workspace, launcher, listener, cloudSettings);
            return bl;
        }
        catch (APIException e) {
            listener.getLogger().println(String.format("%s: %s", Messages.ERROR_API(), e.getMessage()));
            LOGGER.log(Level.WARNING, Messages.ERROR_API(), e);
        }
        catch (IOException e) {
            listener.getLogger().println(String.format("%s: %s", Messages.ERROR_CONNECTION(), e.getLocalizedMessage()));
            LOGGER.log(Level.WARNING, Messages.ERROR_CONNECTION(), e);
        }
        catch (InterruptedException e) {
            listener.getLogger().println(String.format("%s: %s", Messages.ERROR_TESTDROID(), e.getLocalizedMessage()));
            LOGGER.log(Level.WARNING, Messages.ERROR_TESTDROID(), e);
        }
        catch (NumberFormatException e) {
            listener.getLogger().println(Messages.NO_DEVICE_GROUP_CHOSEN());
            LOGGER.log(Level.WARNING, Messages.NO_DEVICE_GROUP_CHOSEN());
        }
        finally {
            if (!releaseDone) {
                semaphore.release();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    private boolean waitForResults(APIUser user, APIProject project, APITestRun testRun, FilePath workspace, Launcher launcher, TaskListener listener, TestdroidCloudSettings.DescriptorImpl cloudSettings) {
        if (this.isWaitForResults()) {
            boolean isDownloadOk = false;
            TestRunFinishCheckScheduler scheduler = TestRunFinishCheckSchedulerFactory.createTestRunFinishScheduler(this.waitForResultsBlock.getTestRunStateCheckMethod());
            try {
                String msg;
                boolean testRunToAbort = false;
                listener.getLogger().println("Waiting for results...");
                scheduler.schedule((Object)this, user, project.getId(), testRun.getId());
                try {
                    RunInCloudBuilder runInCloudBuilder = this;
                    synchronized (runInCloudBuilder) {
                        ((Object)((Object)this)).wait(this.waitForResultsBlock.getWaitForResultsTimeout() * 1000);
                    }
                    scheduler.cancel(project.getId(), testRun.getId());
                    testRun.refresh();
                    if (testRun.getState() == APITestRun.State.FINISHED) {
                        isDownloadOk = (Boolean)launcher.getChannel().call((Callable)new MachineIndependentResultsDownloader(cloudSettings, listener, project.getId(), testRun.getId(), this.evaluateResultsPath(workspace), this.waitForResultsBlock.isDownloadScreenshots()));
                        if (!isDownloadOk) {
                            listener.getLogger().println(Messages.DOWNLOAD_RESULTS_FAILED());
                            LOGGER.log(Level.WARNING, Messages.DOWNLOAD_RESULTS_FAILED());
                        }
                    } else {
                        testRunToAbort = true;
                        msg = String.format(Messages.DOWNLOAD_RESULTS_FAILED_WITH_REASON_S(), "Test run is not finished yet!");
                        listener.getLogger().println(msg);
                        LOGGER.log(Level.WARNING, msg);
                    }
                }
                catch (InterruptedException e) {
                    testRunToAbort = true;
                    listener.getLogger().println(e.getMessage());
                    LOGGER.log(Level.WARNING, e.getMessage(), e);
                }
                if (testRunToAbort && this.waitForResultsBlock.isForceFinishAfterBreak()) {
                    msg = "Force finish test in Cloud";
                    listener.getLogger().println(msg);
                    LOGGER.log(Level.WARNING, msg);
                    testRun.abort();
                }
            }
            catch (APIException e) {
                listener.getLogger().println(String.format("%s: %s", Messages.ERROR_API(), e.getMessage()));
                LOGGER.log(Level.WARNING, Messages.ERROR_API(), e);
            }
            catch (IOException e) {
                listener.getLogger().println(String.format("%s: %s", Messages.ERROR_CONNECTION(), e.getLocalizedMessage()));
                LOGGER.log(Level.WARNING, Messages.ERROR_CONNECTION(), e);
            }
            finally {
                scheduler.cancel(project.getId(), testRun.getId());
            }
            return isDownloadOk;
        }
        return true;
    }

    private void setLimitations(Run<?, ?> build, TaskListener listener, APITestRunConfig config) {
        if (StringUtils.isNotBlank((String)this.getTestCasesValue())) {
            config.setLimitationType(APITestRunConfig.LimitationType.valueOf((String)this.getTestCasesSelect().toUpperCase()));
            config.setLimitationValue(RunInCloudBuilder.applyMacro(build, listener, this.getTestCasesValue()));
        } else {
            config.setLimitationType(null);
            config.setLimitationValue("");
        }
    }

    private void createProvidedParameters(APITestRunConfig config) {
        ArrayList apiTestRunParameters = new ArrayList();
        if (this.keyValuePairs != null) {
            String[] splitKeyValuePairs = this.keyValuePairs.split(";");
            apiTestRunParameters.addAll(Arrays.stream(splitKeyValuePairs).filter(StringUtils::isNotEmpty).map(s -> {
                String[] pair = s.split(":");
                return pair.length == 2 ? new APITestRunParameter(pair[0], pair[1]) : null;
            }).filter(Objects::nonNull).collect(Collectors.toList()));
        }
        config.setTestRunParameters(apiTestRunParameters);
    }

    private void printTestJob(APIProject project, APITestRunConfig config, TestdroidCloudSettings.DescriptorImpl cloudSettings, String cloudVersion, TaskListener listener) {
        listener.getLogger().println(Messages.TEST_RUN_CONFIGURATION());
        listener.getLogger().println(String.format("%s: %s (version %s)", Messages.CLOUD_URL(), cloudSettings.getCloudUrl(), cloudVersion));
        listener.getLogger().println(String.format("%s: %s", Messages.USER_EMAIL(), cloudSettings.getEmail()));
        listener.getLogger().println(String.format("%s: %s", Messages.PROJECT(), project.getName()));
        listener.getLogger().println(Messages.OS_TYPE_VALUE(config.getOsType()));
        listener.getLogger().println(Messages.FRAMEWORK_ID_VALUE(config.getFrameworkId()));
        listener.getLogger().println(String.format("%s: %s", Messages.LOCALE(), config.getDeviceLanguageCode()));
        listener.getLogger().println(String.format("%s: %s", Messages.SCHEDULER(), config.getScheduler()));
        listener.getLogger().println(String.format("%s: %s", Messages.TIMEOUT(), config.getTimeout()));
    }

    private String getAbsolutePath(FilePath workspace, String path) throws IOException, InterruptedException {
        if (StringUtils.isBlank((String)path)) {
            return "";
        }
        String trimmed = StringUtils.trim((String)path);
        if (trimmed.startsWith(File.separator)) {
            return trimmed;
        }
        URI workspaceURI = workspace.toURI();
        return workspaceURI.getPath() + trimmed;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder>
    implements Serializable {
        public static final ListBoxModel.Option EMPTY_OPTION = new ListBoxModel.Option("", "");
        private static final long serialVersionUID = 1L;

        public DescriptorImpl() {
            super(RunInCloudBuilder.class);
            this.load();
        }

        public String getDisplayName() {
            return Messages.TESTDROID_RUN_TESTS_IN_CLOUD();
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.save();
            return super.configure(req, formData);
        }

        public boolean isApplicable(Class<? extends AbstractProject> arg0) {
            return true;
        }

        public boolean isAuthenticated() {
            return TestdroidApiUtil.getGlobalApiClient().isAuthenticated();
        }

        public boolean isPaidUser() {
            boolean result = false;
            if (this.isAuthenticated()) {
                try {
                    Date now = new Date();
                    result = Arrays.stream(TestdroidApiUtil.getGlobalApiClient().getUser().getRoles()).anyMatch(r -> PAID_ROLES.contains(r.getName()) && (r.getExpireTime() == null || r.getExpireTime().after(now)));
                }
                catch (APIException e) {
                    LOGGER.log(Level.WARNING, Messages.ERROR_API());
                }
            }
            return result;
        }

        public ListBoxModel doFillProjectIdItems() {
            ListBoxModel projects = new ListBoxModel();
            try {
                APIUser user = TestdroidApiUtil.getGlobalApiClient().getUser();
                Context context = new Context(APIProject.class, 0, Integer.MAX_VALUE, "", "");
                APIListResource projectResource = user.getProjectsResource(context);
                for (APIProject project : projectResource.getEntity().getData()) {
                    projects.add(project.getName(), project.getId().toString());
                }
            }
            catch (APIException e) {
                LOGGER.log(Level.WARNING, Messages.ERROR_API());
            }
            return projects;
        }

        public ListBoxModel doFillOsTypeItems() {
            ListBoxModel osTypes = new ListBoxModel();
            osTypes.addAll((Collection)Arrays.stream(APIDevice.OsType.values()).map(t -> new ListBoxModel.Option(t.getDisplayName(), t.name())).collect(Collectors.toList()));
            return osTypes;
        }

        public FormValidation doCheckOsType(@QueryParameter APIDevice.OsType value) {
            return value == APIDevice.OsType.UNDEFINED ? FormValidation.error((String)Messages.DEFINE_OS_TYPE()) : FormValidation.ok();
        }

        public ListBoxModel doFillSchedulerItems() {
            ListBoxModel schedulers = new ListBoxModel();
            schedulers.add(Messages.SCHEDULER_PARALLEL(), APITestRunConfig.Scheduler.PARALLEL.name());
            schedulers.add(Messages.SCHEDULER_SERIAL(), APITestRunConfig.Scheduler.SERIAL.name());
            schedulers.add(Messages.SCHEDULER_SINGLE(), APITestRunConfig.Scheduler.SINGLE.name());
            return schedulers;
        }

        public ListBoxModel doFillClusterIdItems() {
            ListBoxModel deviceGroups = new ListBoxModel();
            try {
                APIUser user = TestdroidApiUtil.getGlobalApiClient().getUser();
                Context context = new Context(APIDeviceGroup.class, 0, Integer.MAX_VALUE, "", "");
                context.setExtraParams(Collections.singletonMap("withPublic", Boolean.TRUE));
                APIListResource deviceGroupResource = user.getDeviceGroupsResource(context);
                for (APIDeviceGroup deviceGroup : deviceGroupResource.getEntity().getData()) {
                    deviceGroups.add(String.format("%s (%d device(s))", deviceGroup.getDisplayName(), deviceGroup.getDeviceCount()), deviceGroup.getId().toString());
                }
            }
            catch (APIException e) {
                LOGGER.log(Level.WARNING, Messages.ERROR_API());
            }
            return deviceGroups;
        }

        public ListBoxModel doFillLanguageItems() {
            ListBoxModel language = new ListBoxModel();
            for (Locale locale : AndroidLocale.LOCALES) {
                String langDisplay = String.format("%s (%s)", locale.getDisplayLanguage(), locale.getDisplayCountry());
                String langCode = LocaleUtil.formatLangCode(locale);
                language.add(langDisplay, langCode);
            }
            return language;
        }

        public ListBoxModel doFillTestCasesSelectItems() {
            ListBoxModel testCases = new ListBoxModel();
            for (APITestRunConfig.LimitationType limitationType : APITestRunConfig.LimitationType.values()) {
                String value = limitationType.name();
                testCases.add(value.toLowerCase(), value);
            }
            return testCases;
        }

        public ListBoxModel doFillTestRunStateCheckMethodItems() {
            ListBoxModel items = new ListBoxModel();
            for (TestRunStateCheckMethod method : TestRunStateCheckMethod.values()) {
                items.add(method.name(), method.name());
            }
            return items;
        }

        public ListBoxModel doFillFrameworkIdItems(@QueryParameter APIDevice.OsType osType) {
            ListBoxModel frameworks = new ListBoxModel();
            frameworks.add((Object)EMPTY_OPTION);
            if (osType != APIDevice.OsType.UNDEFINED) {
                try {
                    APIUser user = TestdroidApiUtil.getGlobalApiClient().getUser();
                    Context context = new Context(APIFramework.class, 0, Integer.MAX_VALUE, "", "");
                    context.addFilter((FilterEntry)new StringFilterEntry("osType", Operand.EQ, osType.name()));
                    context.addFilter((FilterEntry)new BooleanFilterEntry("forProjects", Operand.EQ, Boolean.TRUE));
                    context.addFilter((FilterEntry)new BooleanFilterEntry("canRunFromUI", Operand.EQ, Boolean.TRUE));
                    APIListResource availableFrameworksResource = user.getAvailableFrameworksResource(context);
                    frameworks.addAll((Collection)availableFrameworksResource.getEntity().getData().stream().map(f -> new ListBoxModel.Option(f.getName(), f.getId().toString())).collect(Collectors.toList()));
                }
                catch (APIException e) {
                    LOGGER.log(Level.WARNING, Messages.ERROR_API());
                }
            }
            return frameworks;
        }

        public FormValidation doCheckFrameworkId(@QueryParameter String value) {
            return DescriptorImpl.parseLong(value).isPresent() ? FormValidation.ok() : FormValidation.error((String)Messages.DEFINE_FRAMEWORK());
        }

        private static Optional<Long> parseLong(String value) {
            try {
                return Optional.of(Long.parseLong(value));
            }
            catch (NumberFormatException nfe) {
                return Optional.empty();
            }
        }
    }
}

