/*
 * Decompiled with CFR 0.152.
 */
package tenqube.parser.core;

import android.content.ContentResolver;
import android.content.Context;
import android.database.SQLException;
import android.provider.Settings;
import android.text.TextUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import tenqube.parser.constants.Constants;
import tenqube.parser.core.CardTableData;
import tenqube.parser.core.DateUtil;
import tenqube.parser.core.ParserService;
import tenqube.parser.core.TransactionTableData;
import tenqube.parser.core.Utils;
import tenqube.parser.model.RegData;
import tenqube.parser.model.SMS;
import tenqube.parser.util.LogUtil;
import tenqube.parser.util.Validator;

class RegHandler {
    private static final String TAG = LogUtil.makeLogTag(RegHandler.class);
    private Context mContext;

    public RegHandler(Context context) {
        this.mContext = context;
    }

    TransactionTableData getTransactionWithReg(ArrayList<RegData> regDatas, SMS sms) {
        String newFullSms = Utils.transformFullSMS(sms.getFullSms());
        if (Validator.invalidStr("fullSms", newFullSms)) {
            return null;
        }
        if (regDatas == null) {
            regDatas = new ArrayList();
        }
        LogUtil.LOGI(TAG, "regDatas size" + regDatas.size(), ParserService.mIsDebug);
        for (RegData regData : regDatas) {
            String parsedSpentDate;
            String regExpression = regData.regExpression;
            String[] results = regExpression.split(";title");
            LogUtil.LOGI(TAG, " regId" + regData.regId, ParserService.mIsDebug);
            LogUtil.LOGI(TAG, " length" + results.length, ParserService.mIsDebug);
            LogUtil.LOGI(TAG, " sms.getTitle()" + sms.getTitle(), ParserService.mIsDebug);
            if (results.length == 2 && !TextUtils.isEmpty((CharSequence)sms.getTitle())) {
                newFullSms = newFullSms + ";title" + sms.getTitle();
            }
            Pattern pattern = Pattern.compile(regExpression, 106);
            Matcher matcher = pattern.matcher(newFullSms);
            LogUtil.LOGI(TAG, "newFullSms " + newFullSms, ParserService.mIsDebug);
            if (!matcher.matches()) continue;
            LogUtil.LOGI(TAG, "Matched regId" + regData.regId, ParserService.mIsDebug);
            TransactionTableData parsedTran = new TransactionTableData();
            parsedTran.regId = regData.regId;
            parsedTran.userPriority = regData.userPriority;
            parsedTran.identifier = this.getIdentifier();
            parsedTran.isSuccess = 1;
            parsedTran.isCurrentTran = true;
            parsedTran.categoryCode = 10;
            parsedTran.memo = "";
            parsedTran.smsId = sms.getSmsId();
            parsedTran.fullSms = sms.getFullSms();
            parsedTran.smsDate = sms.getSmsDate();
            parsedTran.smsType = sms.getSmsType();
            parsedTran.sender = sms.getSender();
            if (Validator.invalidStr("sender", parsedTran.sender)) {
                LogUtil.LOGI(TAG, "invalidStr(SENDER)" + parsedTran.sender, ParserService.mIsDebug);
                return null;
            }
            CardTableData parsedCard = new CardTableData();
            String parsedCardName = this.getCardName(this.getParsedData(regData.cardName, matcher));
            String string = parsedCard.cardName = TextUtils.isEmpty((CharSequence)parsedCardName) || parsedCardName.contains("null") ? "\ub0b4\uc6a9\uc5c6\uc74c" : parsedCardName.trim();
            if (Validator.invalidStr("cardName", parsedCard.cardName)) {
                LogUtil.LOGI(TAG, "invalidStr(CARD_NAME)" + parsedCard.cardName, ParserService.mIsDebug);
                return null;
            }
            parsedCard.cardNum = this.getCardNum(regData.cardNum, matcher);
            parsedCard.cardType = this.getCardType(regData.cardType, matcher);
            parsedCard.cardSubType = this.getCardSubType(regData.cardSubType, matcher);
            parsedTran.parsedBalance = this.getBalance(regData.balance, matcher);
            if (parsedTran.parsedBalance != null) {
                parsedCard.balance = parsedTran.parsedBalance;
            }
            parsedTran.cardTableData = parsedCard;
            String isBank = parsedTran.cardTableData.cardType == Constants.CardType.BANK_ACCOUNT.ordinal() ? "1" : "0";
            parsedTran.originInfos = parsedTran.sender + ";" + isBank + ";" + parsedTran.cardTableData.cardName;
            parsedTran.dwType = this.getDWType(regData.dwType, matcher);
            parsedTran.spentMoney = this.getSpentMoney(regData.spentMoney, matcher);
            if (parsedTran.spentMoney == 0.0) {
                LogUtil.LOGI(TAG, "parsedTran.spentMoney" + parsedTran.spentMoney, ParserService.mIsDebug);
                return null;
            }
            if (this.isCancel(regData.isCancel, matcher)) {
                parsedTran.spentMoney *= -1.0;
            }
            String string2 = parsedTran.spentDate = TextUtils.isEmpty((CharSequence)(parsedSpentDate = this.getParsedData(regData.spentDate, matcher))) ? sms.getSmsDate() : Utils.transformDate(DateUtil.convertStringToCalendarFULL(sms.getSmsDate()), parsedSpentDate);
            if (parsedTran.spentMoney < 0.0) {
                parsedTran.spentDate = Utils.getCanceledSpentDate(DateUtil.convertStringToCalendarFULL(sms.getSmsDate()), DateUtil.convertStringToCalendarFULL(parsedTran.spentDate));
            }
            if (!Validator.isDate(parsedTran.spentDate)) {
                LogUtil.LOGI(TAG, "invalidStr(spentDate)" + parsedTran.spentDate, ParserService.mIsDebug);
                return null;
            }
            parsedTran.installmentCount = this.getInstallmentCount(regData.installmentCount, matcher);
            parsedTran.finishDate = DateUtil.getFinishDate(parsedTran.spentDate, parsedTran.installmentCount);
            String parsedKeyword = this.parseKeyword(regData, sms, matcher);
            parsedTran.keyword = TextUtils.isEmpty((CharSequence)parsedKeyword) || parsedKeyword.contains("null") ? "\ub0b4\uc6a9\uc5c6\uc74c" : parsedKeyword;
            parsedTran.keyword = Utils.transformKeyword(parsedTran.keyword);
            if (Validator.invalidStr("keyword", parsedTran.keyword)) {
                LogUtil.LOGI(TAG, "invalidStr(KEYWORD)" + parsedTran.keyword, ParserService.mIsDebug);
                return null;
            }
            parsedTran.categoryCode = parsedTran.dwType == Constants.DWType.DEPOSIT.ordinal() ? 90 : 10;
            parsedTran.currency = this.getCurrency(regData.currency, matcher);
            if (!TextUtils.isEmpty((CharSequence)parsedTran.currency)) {
                parsedTran.memo = parsedTran.currency + " " + Utils.transformSpentMoney(parsedTran.spentMoney);
            }
            String userName = this.getUserName(regData.userName, matcher);
            try {
                if (!TextUtils.isEmpty((CharSequence)userName)) {
                    userName = userName.replace("(", "").replace(")", "").replace("*", "\\*");
                    parsedTran.fullSms = parsedTran.fullSms.replaceFirst(userName, "qlip");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return parsedTran;
        }
        return null;
    }

    private String parseKeyword(RegData regData, SMS sms, Matcher matcher) {
        if (!TextUtils.isEmpty((CharSequence)sms.getTitle()) && sms.getTitle().length() > 1) {
            if ("12345678901234567890123456789012345678901234567890title".equals(regData.keyword)) {
                return sms.getTitle();
            }
            if (regData.keyword.contains("title,")) {
                int titleIndex = regData.keyword.indexOf("title,");
                String regs = regData.keyword.substring(titleIndex + 6);
                return this.getParsedData(regs, matcher);
            }
            return this.getParsedData(regData.keyword, matcher);
        }
        return this.getParsedData(regData.keyword, matcher);
    }

    private String getCardName(String cardName) {
        if (TextUtils.isEmpty((CharSequence)cardName)) {
            return "";
        }
        return cardName.replace("\uce74\ub4dc", "").replace("-", "");
    }

    private String getCardNum(String cardNum, Matcher matcher) {
        return !TextUtils.isEmpty((CharSequence)cardNum) && Validator.isNumber(cardNum) ? Utils.getCardNumUntilFour(Utils.getMatcher(Integer.parseInt(cardNum), matcher)).trim() : "";
    }

    private int getCardType(String cardType, Matcher matcher) {
        return !TextUtils.isEmpty((CharSequence)cardType) && Validator.isNumber(cardType) ? this.getCardTypeStr(Utils.getMatcher(Integer.parseInt(cardType), matcher)) : this.getCardTypeStr(cardType);
    }

    private int getCardTypeStr(String cardType) {
        if (TextUtils.isEmpty((CharSequence)cardType)) {
            return Constants.CardType.CARD.ordinal();
        }
        if ("\uccb4\ud06c".equals(cardType)) {
            return Constants.CardType.CHECK.ordinal();
        }
        if ("\uc740\ud589".equals(cardType)) {
            return Constants.CardType.BANK_ACCOUNT.ordinal();
        }
        return Constants.CardType.CARD.ordinal();
    }

    private int getCardSubType(String cardSubType, Matcher matcher) {
        return !TextUtils.isEmpty((CharSequence)cardSubType) && Validator.isNumber(cardSubType) ? this.getCardSubTypeStr(Utils.getMatcher(Integer.parseInt(cardSubType), matcher)) : this.getCardSubTypeStr(cardSubType);
    }

    private int getCardSubTypeStr(String cardSubType) {
        if (TextUtils.isEmpty((CharSequence)cardSubType)) {
            return Constants.CardSubType.NORMAL.ordinal();
        }
        if ("\ubc95\uc778".equals(cardSubType)) {
            return Constants.CardSubType.CORPORATION.ordinal();
        }
        if ("\uac00\uc871".equals(cardSubType)) {
            return Constants.CardSubType.FAMILY.ordinal();
        }
        return Constants.CardSubType.NORMAL.ordinal();
    }

    private Double getBalance(String balance, Matcher matcher) {
        String balanceStr;
        if (!TextUtils.isEmpty((CharSequence)balance) && Validator.isNumber(balance) && !TextUtils.isEmpty((CharSequence)(balanceStr = Utils.getMatcher(Integer.parseInt(balance), matcher)))) {
            try {
                return Double.parseDouble(balanceStr.replace(",", "").replace(" ", ""));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    private double getSpentMoney(String spentMoney, Matcher matcher) {
        LogUtil.LOGI(TAG, "getSpentMoney1" + spentMoney, ParserService.mIsDebug);
        if (!TextUtils.isEmpty((CharSequence)spentMoney) && Validator.isNumber(spentMoney)) {
            String spentMoneyStr = Utils.getMatcher(Integer.parseInt(spentMoney), matcher);
            LogUtil.LOGI(TAG, "getSpentMoney2" + spentMoneyStr, ParserService.mIsDebug);
            if (TextUtils.isEmpty((CharSequence)spentMoneyStr)) {
                return 0.0;
            }
            if (spentMoneyStr.contains("\ub9cc\uc6d0")) {
                return Utils.transformSpentMoney(spentMoneyStr);
            }
            try {
                LogUtil.LOGI(TAG, "getSpentMoney3" + spentMoneyStr.replace(",", "").replace(" ", "").replace("O", "0").trim(), ParserService.mIsDebug);
                return Double.parseDouble(spentMoneyStr.replace(",", "").replace(" ", "").replace("O", "0").trim());
            }
            catch (NumberFormatException e) {
                return 0.0;
            }
        }
        return 0.0;
    }

    private int getInstallmentCount(String installmentCount, Matcher matcher) {
        if (!TextUtils.isEmpty((CharSequence)installmentCount) && Validator.isNumber(installmentCount)) {
            String installmentStr = Utils.getMatcher(Integer.parseInt(installmentCount), matcher);
            if (TextUtils.isEmpty((CharSequence)installmentStr)) {
                return 1;
            }
            try {
                return Integer.parseInt(installmentStr);
            }
            catch (NumberFormatException e) {
                return 1;
            }
        }
        return 1;
    }

    private int getDWType(String dwType, Matcher matcher) {
        return !TextUtils.isEmpty((CharSequence)dwType) && Validator.isNumber(dwType) ? this.getDWTypeStr(Utils.getMatcher(Integer.parseInt(dwType), matcher)) : this.getDWTypeStr(dwType);
    }

    private int getDWTypeStr(String dwType) {
        if (TextUtils.isEmpty((CharSequence)dwType)) {
            return Constants.DWType.WITHDRAW.ordinal();
        }
        return dwType.equals("\uc785\uae08") || dwType.equals("\uc785") ? Constants.DWType.DEPOSIT.ordinal() : Constants.DWType.WITHDRAW.ordinal();
    }

    private boolean isCancel(String isCancel, Matcher matcher) {
        return !TextUtils.isEmpty((CharSequence)isCancel) && Validator.isNumber(isCancel) ? this.isCancel(Utils.getMatcher(Integer.parseInt(isCancel), matcher)) : this.isCancel(isCancel);
    }

    private boolean isCancel(String isCancel) {
        return !TextUtils.isEmpty((CharSequence)isCancel) && ("\ucde8".equals(isCancel) || isCancel.contains("\ucde8\uc18c") || isCancel.contains("\uc815\uc815"));
    }

    private String getCurrency(String currency, Matcher matcher) {
        return !TextUtils.isEmpty((CharSequence)currency) && Validator.isNumber(currency) ? Utils.transformCurrency(Utils.getMatcher(Integer.parseInt(currency), matcher)) : Utils.transformCurrency(currency);
    }

    private String getUserName(String userName, Matcher matcher) {
        return !TextUtils.isEmpty((CharSequence)userName) && Validator.isNumber(userName) ? Utils.getMatcher(Integer.parseInt(userName), matcher) : "";
    }

    private String getParsedData(String regStr, Matcher matcher) {
        StringBuilder valueStr = new StringBuilder();
        if (!TextUtils.isEmpty((CharSequence)regStr)) {
            if (regStr.contains(",")) {
                String[] subMapping;
                for (String sub : subMapping = regStr.split(",")) {
                    if (TextUtils.isEmpty((CharSequence)sub)) continue;
                    valueStr.append(Validator.isNumber(sub) ? Utils.getMatcher(Integer.parseInt(sub), matcher) : sub);
                }
            } else {
                valueStr.append(Validator.isNumber(regStr) ? Utils.getMatcher(Integer.parseInt(regStr), matcher) : regStr);
            }
        }
        return valueStr.toString();
    }

    boolean isDuplicate(String duplTranInfo, String parsedTranInfo) {
        try {
            String[] dupleTranInfos = duplTranInfo.split(";");
            String[] parsedTranInfos = parsedTranInfo.split(";");
            String duplSender = dupleTranInfos[0];
            String duplIsBank = dupleTranInfos[1];
            String duplCardName = dupleTranInfos[2];
            String parsedSender = parsedTranInfos[0];
            String parsedIsBank = parsedTranInfos[1];
            String parsedCardName = parsedTranInfos[2];
            return !(duplSender.equals(parsedSender) && duplIsBank.equals(parsedIsBank) || !this.isPay(duplCardName, parsedCardName) && !Utils.matchingCardName(duplCardName, parsedCardName, duplIsBank, parsedIsBank));
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean isPay(String duplCardName, String parsedCardName) {
        return "\uc0bc\uc131\ud398\uc774".equals(duplCardName) || "\uc0bc\uc131\ud398\uc774".equals(parsedCardName) || "LG Pay".equals(duplCardName) || "LG Pay".equals(parsedCardName);
    }

    TransactionTableData combineTran(TransactionTableData duplicationTran, TransactionTableData parsedTran) {
        parsedTran.cardTableData.balance = duplicationTran.cardTableData.balance;
        parsedTran.isOffset = duplicationTran.isOffset;
        parsedTran.categoryCode = duplicationTran.categoryCode == 88 || duplicationTran.categoryCode == 98 ? duplicationTran.categoryCode : parsedTran.categoryCode;
        parsedTran.isDuplicate = 1;
        parsedTran.identifier = duplicationTran.identifier;
        parsedTran = this.combineDwType(duplicationTran, parsedTran);
        parsedTran.installmentCount = this.combineInstallmentCount(duplicationTran.installmentCount, parsedTran.installmentCount);
        parsedTran.keyword = this.combineKeyword(duplicationTran.keyword, parsedTran.keyword);
        parsedTran.cardTableData = this.combineCard(duplicationTran.cardTableData, parsedTran.cardTableData, parsedTran.smsType);
        parsedTran.originInfos = this.combineOriginInfo(duplicationTran.originInfos, parsedTran.originInfos);
        return parsedTran;
    }

    private TransactionTableData combineDwType(TransactionTableData duplicationTran, TransactionTableData parsedTran) {
        if (duplicationTran.dwType != parsedTran.dwType && duplicationTran.dwType == Constants.DWType.WITHDRAW.ordinal()) {
            parsedTran.spentMoney = duplicationTran.spentMoney;
            parsedTran.dwType = duplicationTran.dwType;
        }
        return parsedTran;
    }

    private int combineInstallmentCount(int duplInstallmentCount, int parsedInstallmentCount) {
        if (parsedInstallmentCount < duplInstallmentCount) {
            return duplInstallmentCount;
        }
        return parsedInstallmentCount;
    }

    private String combineKeyword(String duplKeyword, String parsedKeyword) {
        if (TextUtils.isEmpty((CharSequence)parsedKeyword) || "\ub0b4\uc6a9\uc5c6\uc74c".equals(parsedKeyword) || "none".equals(parsedKeyword) || !TextUtils.isEmpty((CharSequence)duplKeyword) && !"\ub0b4\uc6a9\uc5c6\uc74c".equals(duplKeyword) && !"none".equals(duplKeyword) && parsedKeyword.length() < duplKeyword.length()) {
            return duplKeyword;
        }
        return parsedKeyword;
    }

    private CardTableData combineCard(CardTableData duplicationCard, CardTableData parsedCard, int parsedSMSType) {
        if ("\uc0bc\uc131\ud398\uc774".equals(duplicationCard.cardName) || "LG Pay".equals(duplicationCard.cardName)) {
            return parsedCard;
        }
        if ("\uc0bc\uc131\ud398\uc774".equals(parsedCard.cardName) || "LG Pay".equals(parsedCard.cardName)) {
            return duplicationCard;
        }
        if (parsedCard.cardType == duplicationCard.cardType) {
            if (parsedCard.cardName.length() < parsedCard.cardName.length()) {
                return duplicationCard;
            }
            if (parsedCard.cardName.length() == duplicationCard.cardName.length() && parsedSMSType == Constants.SMSType.NOTIFICATION.ordinal()) {
                return duplicationCard;
            }
        } else if (parsedCard.cardType == Constants.CardType.BANK_ACCOUNT.ordinal()) {
            return duplicationCard;
        }
        return parsedCard;
    }

    private String combineOriginInfo(String duplOriginInfo, String parsedInfo) {
        try {
            String[] parsedOriginInfos = parsedInfo.split(";");
            String[] duplOriginInfos = duplOriginInfo.split(";");
            if (parsedOriginInfos.length > 1 && duplOriginInfos.length > 1) {
                String duplSender = duplOriginInfos[0];
                if ("com.lge.lgpay".equals(duplSender) || "com.samsung.android.spay".equals(duplSender)) {
                    return parsedInfo;
                }
                String parsedIsBank = parsedOriginInfos[1];
                String duplIsBank = duplOriginInfos[1];
                if ("1".equals(parsedIsBank) || parsedIsBank.equals(duplIsBank)) {
                    return duplOriginInfo;
                }
            }
            return parsedInfo;
        }
        catch (Exception e) {
            return parsedInfo;
        }
    }

    TransactionTableData combineTranWithOffset(TransactionTableData offsetTran, TransactionTableData parsedTran) {
        if (parsedTran.spentMoney < 0.0) {
            parsedTran.cardTableData = offsetTran.cardTableData;
            parsedTran.isOffset = 1;
            parsedTran.categoryCode = offsetTran.categoryCode;
        } else {
            offsetTran.cardTableData = parsedTran.cardTableData;
            offsetTran.isOffset = 1;
        }
        return parsedTran;
    }

    TransactionTableData combineTranWithMovingAsset(TransactionTableData tran) {
        tran.categoryCode = tran.dwType == Constants.DWType.DEPOSIT.ordinal() ? 98 : 88;
        return tran;
    }

    TransactionTableData updateBalance(TransactionTableData tran) throws SQLException {
        if (tran.parsedBalance != null) {
            tran.cardTableData.balance = tran.parsedBalance;
            return tran;
        }
        if (tran.isDuplicate == 0) {
            tran.cardTableData.balance = tran.dwType == Constants.DWType.DEPOSIT.ordinal() ? tran.cardTableData.balance + tran.spentMoney : tran.cardTableData.balance - tran.spentMoney;
        }
        return tran;
    }

    private String getIdentifier() {
        try {
            String androidDeviceId = Settings.Secure.getString((ContentResolver)this.mContext.getContentResolver(), (String)"android_id");
            if (androidDeviceId == null) {
                androidDeviceId = "NoAndroidId";
            }
            String end = Calendar.getInstance().getTimeInMillis() + "";
            String start = androidDeviceId.hashCode() + "";
            if (start.startsWith("-")) {
                start = start.substring(1, start.length());
            }
            start = start.length() > 5 ? start.substring(0, 5) : start;
            end = end.length() > 8 ? end.substring(end.length() - 8) : end;
            return start + end;
        }
        catch (Exception e) {
            LogUtil.LOGE("error", e.toString());
            return Calendar.getInstance().getTimeInMillis() + "";
        }
    }
}

