/*
 * Decompiled with CFR 0.152.
 */
package tenqube.parser.core;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteException;
import android.text.TextUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import tenqube.parser.constants.Constants;
import tenqube.parser.core.BaseQueryHelper;
import tenqube.parser.core.CardTableData;
import tenqube.parser.core.DatabaseHelper;
import tenqube.parser.core.DateUtil;
import tenqube.parser.core.ParserMapper;
import tenqube.parser.core.ParserReaderContract;
import tenqube.parser.core.ParserService;
import tenqube.parser.core.PrefUtils;
import tenqube.parser.core.RegHandler;
import tenqube.parser.core.TransactionTableData;
import tenqube.parser.core.Utils;
import tenqube.parser.model.Bank;
import tenqube.parser.model.RegData;
import tenqube.parser.model.Sender;
import tenqube.parser.model.Transaction;
import tenqube.parser.util.LogUtil;

class ParserDao
extends BaseQueryHelper {
    ParserDao(Context context) throws SecurityException, SQLException {
        super(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isBankMsgWithKakao(String title) {
        LogUtil.LOGI(TAG, "isBankMsgWithKakao", ParserService.mIsDebug);
        if (TextUtils.isEmpty((CharSequence)title)) {
            return false;
        }
        String query = " SELECT  EXISTS ( SELECT  1  FROM  BANKS WHERE sender = '" + title + "' " + " OR " + "sender" + " like '%" + title + "%' )";
        try (Cursor c = null;){
            c = this.runQuery(query);
            if (c != null && c.moveToFirst()) {
                boolean bl = c.getInt(0) == 1;
                return bl;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getRepSender(String sender) {
        LogUtil.LOGI(TAG, "getRepSender", ParserService.mIsDebug);
        String transformSender = Utils.transformSender(sender);
        Cursor c = null;
        String query = " SELECT repSender FROM  SENDERS WHERE sender IN ('" + sender + "','" + transformSender + "')" + " LIMIT " + "1";
        LogUtil.LOGI(TAG, "getRepSender query:" + query, ParserService.mIsDebug);
        try {
            c = this.runQuery(query);
            if (c != null && c.moveToFirst()) {
                String string = c.getString(c.getColumnIndex("repSender"));
                return string;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            if (c != null) {
                c.close();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ArrayList<RegData> getRegDatasWithBulk(String repSender, int smsType) {
        LogUtil.LOGI(TAG, "getRegDatasWithBulk", ParserService.mIsDebug);
        Cursor c = null;
        ArrayList<RegData> regDatas = new ArrayList<RegData>();
        String query = " SELECT * FROM  REG_EXPRESSION WHERE smsType IN  (" + smsType + ", 3 )";
        query = query + " AND sender = '" + repSender + "'";
        query = query + " ORDER BY priority DESC ,user_priority DESC ";
        try {
            c = this.runQuery(query);
            if (c != null && c.moveToFirst()) {
                regDatas = new ArrayList();
                while (!c.isAfterLast()) {
                    regDatas.add(ParserReaderContract.RegExpressionTable.populateModel(c, this.mContext));
                    c.moveToNext();
                }
            }
        }
        catch (SQLiteException e) {
            e.printStackTrace();
        }
        finally {
            if (c != null) {
                c.close();
            }
        }
        return regDatas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<RegData> findByIds(ArrayList<Integer> ids) {
        LogUtil.LOGI(TAG, "findByIds", ParserService.mIsDebug);
        Cursor c = null;
        ArrayList<RegData> regDatas = new ArrayList<RegData>();
        String query = " SELECT * FROM  REG_EXPRESSION WHERE regId IN  (" + TextUtils.join((CharSequence)",", ids) + ")";
        try {
            c = this.runQuery(query);
            if (c != null && c.moveToFirst()) {
                regDatas = new ArrayList();
                while (!c.isAfterLast()) {
                    regDatas.add(ParserReaderContract.RegExpressionTable.populateModel(c, this.mContext));
                    c.moveToNext();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (c != null) {
                c.close();
            }
        }
        return regDatas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<String, String> getSendersMap() {
        LogUtil.LOGI(TAG, "setSenders", ParserService.mIsDebug);
        HashMap<String, String> mSendersMap = new HashMap<String, String>();
        String query = " SELECT sender,repSender FROM  SENDERS";
        try (Cursor c = null;){
            c = this.runQuery(query);
            if (c != null && c.moveToFirst()) {
                while (!c.isAfterLast()) {
                    String key = c.getString(c.getColumnIndex("sender"));
                    String repSender = c.getString(c.getColumnIndex("repSender"));
                    if (!repSender.equals("ALL")) {
                        mSendersMap.put(key, repSender);
                    }
                    c.moveToNext();
                }
            }
        }
        return mSendersMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getRepSender(String sender, String displaySender) {
        String transformSender;
        LogUtil.LOGI(TAG, "getRepSender", ParserService.mIsDebug);
        Cursor c = null;
        String query = "";
        if (TextUtils.isEmpty((CharSequence)displaySender) || sender.equals(displaySender)) {
            transformSender = Utils.transformSender(sender);
            query = query + " SELECT repSender FROM  SENDERS WHERE sender IN ('" + sender + "','" + transformSender + "')" + " LIMIT " + "1";
        } else {
            transformSender = Utils.transformSender(sender);
            String transformDisplaySender = Utils.transformSender(displaySender);
            query = query + " SELECT repSender FROM  SENDERS WHERE sender IN ('" + sender + "','" + transformSender + "','" + displaySender + "','" + transformDisplaySender + "')" + " LIMIT " + "1";
        }
        LogUtil.LOGI(TAG, "getRepSender query:" + query, ParserService.mIsDebug);
        try {
            c = this.runQuery(query);
            if (c != null && c.moveToFirst()) {
                transformSender = c.getString(c.getColumnIndex("repSender"));
                return transformSender;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            if (c != null) {
                c.close();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ArrayList<Transaction> getFailTransaction(ParserMapper mapper) {
        LogUtil.LOGI(TAG, "getFailTransaction", ParserService.mIsDebug);
        ArrayList<Transaction> failTrans = new ArrayList<Transaction>();
        String query = " SELECT * FROM " + this.getJoinTable() + " WHERE " + " tran." + "isSuccess" + "=" + 0 + " ORDER BY " + " tran." + "spentDate" + " ASC ";
        try (Cursor c = null;){
            c = this.runQuery(query);
            if (c != null && c.moveToFirst()) {
                while (!c.isAfterLast()) {
                    TransactionTableData failTran = ParserReaderContract.TransactionsTable.populateModel(c);
                    failTran.cardTableData = ParserReaderContract.CardTable.populateModel(c);
                    Transaction tran = mapper.transform(failTran);
                    if (tran != null) {
                        failTrans.add(tran);
                    }
                    c.moveToNext();
                }
            }
        }
        return failTrans;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CardTableData getCard(CardTableData parsedCard) throws SQLException {
        LogUtil.LOGI(TAG, "getCard", ParserService.mIsDebug);
        String query = " SELECT * FROM  CARDS WHERE cardName='" + parsedCard.cardName + "'" + " AND " + "cardNum" + "='" + parsedCard.cardNum + "'" + " AND " + "cardType" + "=" + parsedCard.cardType + " AND " + "cardSubType" + "=" + parsedCard.cardSubType;
        try (Cursor c = null;){
            c = this.runQuery(query);
            if (c != null) {
                if (c.moveToFirst()) {
                    while (!c.isAfterLast()) {
                        parsedCard = ParserReaderContract.CardTable.populateModel(c);
                        c.moveToNext();
                    }
                }
            } else {
                parsedCard.cardId = (int)this.insert(" CARDS", ParserReaderContract.CardTable.populateContent(parsedCard));
            }
        }
        return parsedCard;
    }

    void updateUserPriority(int id, int userPriority) {
        ContentValues values = new ContentValues();
        values.put("user_priority", Integer.valueOf(++userPriority));
        this.update(" REG_EXPRESSION", values, "regId=" + id, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ArrayList<RegData> getRegDatas(String sender, int smsType) {
        LogUtil.LOGI(TAG, "getRegDatas", ParserService.mIsDebug);
        Cursor c = null;
        ArrayList<RegData> regDatas = null;
        smsType = Utils.getSMSType(smsType);
        String query = " SELECT * FROM  REG_EXPRESSION WHERE smsType IN  (" + smsType + ", 3 )";
        query = query + ("ALL".equals(sender) ? "" : " AND sender = '" + sender + "'");
        query = query + " ORDER BY priority DESC ,user_priority DESC ";
        try {
            LogUtil.LOGI(TAG, "getRegDatas query:" + query, ParserService.mIsDebug);
            c = this.runQuery(query);
            if (c != null && c.moveToFirst()) {
                regDatas = new ArrayList<RegData>();
                while (!c.isAfterLast()) {
                    RegData reg = ParserReaderContract.RegExpressionTable.populateModel(c, this.mContext);
                    regDatas.add(reg);
                    c.moveToNext();
                }
            }
        }
        catch (SQLiteException e) {
            LogUtil.LOGE(TAG, e.toString());
        }
        finally {
            if (c != null) {
                c.close();
            }
        }
        return regDatas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TransactionTableData getDuplicationTran(TransactionTableData tran, RegHandler mRegHandler) throws SQLException {
        LogUtil.LOGI(TAG, "getDuplicationTran", ParserService.mIsDebug);
        Cursor c = null;
        Calendar cal = DateUtil.convertStringToCalendarFULL(tran.spentDate);
        cal.add(12, 5);
        String endDate = DateUtil.getStringDateAsYYYYMMddHHmm(cal);
        if ("\uc0bc\uc131\ud398\uc774".equals(tran.cardTableData.cardName)) {
            cal.add(11, -13);
        } else {
            cal.add(12, -15);
        }
        String startDate = DateUtil.getStringDateAsYYYYMMddHHmm(cal);
        String query = " SELECT * FROM " + this.getJoinTable() + " WHERE " + "strftime(" + "'%Y-%m-%d %H:%M'" + "," + "spentDate" + ")>'" + startDate + "' " + " AND " + " strftime(" + "'%Y-%m-%d %H:%M'" + "," + "spentDate" + ")<='" + endDate + "' " + " AND " + "((" + "spentMoney" + "=" + tran.spentMoney + " AND " + "dwType" + "=" + tran.dwType + ")" + " OR " + "(" + "spentMoney" + "=" + -1.0 * tran.spentMoney + " AND " + "dwType" + "!=" + tran.dwType + "))" + " ORDER BY " + "spentDate" + " DESC " + " LIMIT " + " 1 ";
        try {
            c = this.runQuery(query);
            if (c != null && c.moveToFirst()) {
                while (!c.isAfterLast()) {
                    TransactionTableData duplicationTran = ParserReaderContract.TransactionsTable.populateModel(c);
                    duplicationTran.cardTableData = ParserReaderContract.CardTable.populateModel(c);
                    if (mRegHandler.isDuplicate(duplicationTran.originInfos, tran.originInfos)) {
                        TransactionTableData transactionTableData = duplicationTran;
                        return transactionTableData;
                    }
                    c.moveToNext();
                }
            }
        }
        catch (SQLiteException e) {
            LogUtil.LOGE(TAG, e.toString());
        }
        finally {
            if (c != null) {
                c.close();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TransactionTableData getOffsetTran(TransactionTableData tran, boolean isDuplicate) throws SQLException {
        LogUtil.LOGI(TAG, "getOffsetTran", ParserService.mIsDebug);
        if (tran.spentMoney < 0.0) {
            Cursor c = null;
            Calendar cal = DateUtil.convertStringToCalendarFULL(tran.spentDate);
            cal.add(5, 1);
            String endDate = DateUtil.getStringDateAsYYYYMMddHHmmss(cal);
            cal.add(2, -2);
            String startDate = DateUtil.getStringDateAsYYYYMMddHHmmss(cal);
            String query = " SELECT * FROM " + this.getJoinTable() + " WHERE " + " tran." + "spentDate" + " >='" + startDate + "' " + " AND " + " tran." + "spentDate" + " < '" + endDate + "'" + " AND " + " tran." + "spentMoney" + "=" + -1.0 * tran.spentMoney + " AND " + " tran." + "dwType" + "=" + tran.dwType;
            query = query + " AND ( card.cardName like '%" + tran.cardTableData.cardName + "%'" + " OR " + " card." + "cardName" + " like '%" + Utils.transformCardName(tran.cardTableData.cardName) + "%')" + " ORDER BY " + " tran." + "spentDate" + " DESC " + " LIMIT " + "1";
            LogUtil.LOGI(TAG, "offset query" + query);
            try {
                c = this.runQuery(query);
                if (c != null && c.moveToFirst()) {
                    TransactionTableData offsetTran = ParserReaderContract.TransactionsTable.populateModel(c);
                    if (this.isContainKeyword(offsetTran.keyword, tran.keyword)) {
                        offsetTran.isOffset = 1;
                        offsetTran.cardTableData = ParserReaderContract.CardTable.populateModel(c);
                        TransactionTableData transactionTableData = offsetTran;
                        return transactionTableData;
                    }
                    TransactionTableData transactionTableData = null;
                    return transactionTableData;
                }
            }
            catch (SQLiteException e) {
                e.printStackTrace();
            }
            finally {
                if (c != null) {
                    c.close();
                }
            }
        }
        return null;
    }

    private boolean isContainKeyword(String offsetKeyword, String tranKeyword) {
        try {
            return offsetKeyword.contains(tranKeyword) || tranKeyword.contains(offsetKeyword);
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TransactionTableData getMovingAssetTran(TransactionTableData tran) throws SQLException {
        LogUtil.LOGI(TAG, "getMovingAssetTran", ParserService.mIsDebug);
        if (tran.cardTableData.cardType == Constants.CardType.BANK_ACCOUNT.ordinal()) {
            Calendar cal = DateUtil.convertStringToCalendarFULL(tran.spentDate);
            cal.add(12, 3);
            String endDate = DateUtil.getStringDateAsYYYYMMddHHmm(cal);
            cal.add(12, -6);
            String startDate = DateUtil.getStringDateAsYYYYMMddHHmm(cal);
            String query = " SELECT * FROM " + this.getJoinTable() + " WHERE " + "strftime(" + "'%Y-%m-%d %H:%M'" + "," + "spentDate" + ")>'" + startDate + "' " + " AND " + " strftime(" + "'%Y-%m-%d %H:%M'" + "," + "spentDate" + ")<='" + endDate + "' " + " AND " + "dwType" + "!=" + tran.dwType + " AND " + "spentMoney" + "=" + tran.spentMoney + " AND " + "categoryCode" + " NOT IN(98,88)" + " AND " + "(" + "cardName" + "!='" + tran.cardTableData.cardName + "'" + " OR " + "cardNum" + "!='" + tran.cardTableData.cardNum + "')" + " AND " + "cardType" + "=" + Constants.CardType.BANK_ACCOUNT.ordinal() + " LIMIT " + " 1";
            try (Cursor c = null;){
                c = this.runQuery(query);
                if (c != null && c.moveToFirst()) {
                    TransactionTableData movingAssetTran = ParserReaderContract.TransactionsTable.populateModel(c);
                    movingAssetTran.cardTableData = ParserReaderContract.CardTable.populateModel(c);
                    TransactionTableData transactionTableData = movingAssetTran;
                    return transactionTableData;
                }
            }
        }
        return null;
    }

    void mergeTransaction(TransactionTableData tran) throws SQLException {
        LogUtil.LOGI(TAG, "mergeTransaction", ParserService.mIsDebug);
        if (tran == null) {
            return;
        }
        ContentValues values = ParserReaderContract.TransactionsTable.populateContent(tran);
        String[] selectionArgs = new String[]{tran.identifier + ""};
        long suc = this.update(" TRANSACTIONS", values, "identifier= ?", selectionArgs);
        if (suc == 0L) {
            this.insert(" TRANSACTIONS", values);
        }
        values = ParserReaderContract.CardTable.populateContent(tran.cardTableData);
        selectionArgs = new String[]{tran.cardTableData.cardId + ""};
        suc = this.update(" CARDS", values, "_id= ?", selectionArgs);
        if (suc == 0L) {
            this.insert(" CARDS", values);
        }
    }

    void initDb() throws SQLException {
        LogUtil.LOGI(TAG, "initDb", ParserService.mIsDebug);
        PrefUtils.getInstance(this.mContext).clear();
        DatabaseHelper.getInstance(this.mContext).onCreate(this.wdb);
    }

    void initTransactions() throws SQLiteException {
        PrefUtils.getInstance(this.mContext).saveIntValue("MAX_SMS_DATE", 0);
        PrefUtils.getInstance(this.mContext).saveIntValue("MAX_SMS_ID", 0);
        PrefUtils.getInstance(this.mContext).saveIntValue("MAX_MMS_ID", 0);
        this.wdb.execSQL(" DROP TABLE IF EXISTS  BANKS");
        this.wdb.execSQL(" CREATE TABLE  BANKS (bankId INTEGER  PRIMARY KEY  , sender TEXT  NOT NULL  UNIQUE  )");
        this.wdb.execSQL("CREATE INDEX qlip_banks_idx ON  BANKS (sender)");
        this.wdb.execSQL(" DROP TABLE IF EXISTS  CARDS");
        this.wdb.execSQL(" CREATE TABLE  CARDS (_id INTEGER  PRIMARY KEY  AUTOINCREMENT  , cardName TEXT  NOT NULL  DEFAULT  'none'  , cardNum TEXT  , cardType INTEGER  NOT NULL  DEFAULT  0  , cardSubType INTEGER  NOT NULL  DEFAULT  0  , balance REAL  NOT NULL  DEFAULT  0  )");
        this.wdb.execSQL("CREATE INDEX qlip_card_idx ON  CARDS (cardName,cardNum,cardType,cardSubType)");
        this.wdb.execSQL(" DROP TABLE IF EXISTS  TRANSACTIONS");
        this.wdb.execSQL(" CREATE TABLE  TRANSACTIONS (identifier TEXT  NOT NULL  UNIQUE  , cardId INTEGER  NOT NULL  DEFAULT  0  , smsId INTEGER  NOT NULL  DEFAULT  0  , fullSms TEXT  NOT NULL  DEFAULT  'none'  , sender TEXT  NOT NULL  DEFAULT  'none'  , smsType INTEGER  NOT NULL  DEFAULT  0  , smsDate DATETIME  NOT NULL  DEFAULT  0  , regId INTEGER  NOT NULL  DEFAULT  0  , spentMoney REAL  NOT NULL  DEFAULT  0  , spentDate DATETIME  NOT NULL  DEFAULT  0  , finishDate DATETIME  NOT NULL  DEFAULT  0  , keyword TEXT  NOT NULL  DEFAULT  'none'  , installmentCount INTEGER  NOT NULL  DEFAULT 1 , dwType INTEGER  NOT NULL  DEFAULT  0  , currency TEXT  , isOffset INTEGER  NOT NULL  DEFAULT  0  , isDuplicate INTEGER  NOT NULL  DEFAULT  0  , memo TEXT  , spentLatitude REAL  NOT NULL  DEFAULT  0  , spentLongitude REAL  NOT NULL  DEFAULT  0  , categoryCode INTEGER  NOT NULL  DEFAULT 101010 , isSuccess INTEGER  NOT NULL  DEFAULT 1 , originInfos TEXT  NOT NULL  DEFAULT  'none' )");
        this.wdb.execSQL("CREATE INDEX qlip_transaction_idx ON  TRANSACTIONS (identifier)");
        this.wdb.execSQL("CREATE INDEX qlip_transaction_idx2 ON  TRANSACTIONS (spentDate,dwType,isOffset,keyword)");
        this.wdb.execSQL("CREATE INDEX qlip_transaction_idx3 ON  TRANSACTIONS (spentDate,dwType,spentMoney,categoryCode)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getMinSendersId() {
        LogUtil.LOGI(TAG, "getMinSendersId", ParserService.mIsDebug);
        String query = " SELECT MIN(senderId) FROM  SENDERS";
        try (Cursor c = null;){
            c = this.runQuery(query);
            if (c != null && c.moveToFirst()) {
                int n = c.getInt(0);
                return n;
            }
        }
        return 0;
    }

    void mergeRegDatas(ArrayList<RegData> regDatas, int bulkSize) throws SQLException {
        LogUtil.LOGI(TAG, "mergeRegDatas", ParserService.mIsDebug);
        if (regDatas == null) {
            return;
        }
        ArrayList<String> deleteIds = new ArrayList<String>();
        ArrayList<String> insertValues = new ArrayList<String>();
        for (RegData regData : regDatas) {
            if (regData.isDelete == 1) {
                deleteIds.add(regData.regId + "");
            } else {
                LogUtil.LOGI(TAG, "regDatas:" + regData.getInsertValue(), ParserService.mIsDebug);
                insertValues.add(regData.getInsertValue());
            }
            if (deleteIds.size() == bulkSize) {
                this.delete(" REG_EXPRESSION", "regId IN (" + TextUtils.join((CharSequence)",", deleteIds) + ")", null);
                deleteIds.clear();
            }
            if (insertValues.size() != bulkSize) continue;
            String insertQuery = "INSERT OR REPLACE INTO REG_EXPRESSION(regId,sender,regExpression,cardName,cardType,cardSubType,cardNum,spentMoney,spentDate,keyword,installmentCount,dwType,isCancel,currency,balance,userName,smsType,priority)VALUES" + TextUtils.join((CharSequence)",", insertValues);
            LogUtil.LOGI(TAG, "regDatas: insertQuery" + insertQuery, ParserService.mIsDebug);
            this.wdb.execSQL(insertQuery);
            insertValues.clear();
        }
        if (deleteIds.size() != 0) {
            this.delete(" REG_EXPRESSION", "regId IN (" + TextUtils.join((CharSequence)",", deleteIds) + ")", null);
            deleteIds.clear();
        }
        if (insertValues.size() != 0) {
            String insertQuery = "INSERT OR REPLACE INTO REG_EXPRESSION(regId,sender,regExpression,cardName,cardType,cardSubType,cardNum,spentMoney,spentDate,keyword,installmentCount,dwType,isCancel,currency,balance,userName,smsType,priority)VALUES" + TextUtils.join((CharSequence)",", insertValues);
            this.wdb.execSQL(insertQuery);
            insertValues.clear();
        }
    }

    void mergeSenders(ArrayList<Sender> senders, int bulkSize) throws SQLException {
        LogUtil.LOGI(TAG, "mergeSenders", ParserService.mIsDebug);
        if (senders == null) {
            return;
        }
        ArrayList<String> deleteIds = new ArrayList<String>();
        ArrayList<String> insertValues = new ArrayList<String>();
        for (Sender sender : senders) {
            if (sender.isDelete == 1) {
                deleteIds.add(sender.senderId + "");
            } else {
                insertValues.add(sender.getInsertValue());
            }
            if (deleteIds.size() == bulkSize) {
                this.delete(" SENDERS", "senderId IN (" + TextUtils.join((CharSequence)",", deleteIds) + ")", null);
                deleteIds.clear();
            }
            if (insertValues.size() != bulkSize) continue;
            String insertQuery = "INSERT OR REPLACE INTO SENDERS(senderId,smsType,sender,repSender)VALUES" + TextUtils.join((CharSequence)",", insertValues);
            this.wdb.execSQL(insertQuery);
            insertValues.clear();
        }
        if (deleteIds.size() != 0) {
            this.delete(" SENDERS", "senderId IN (" + TextUtils.join((CharSequence)",", deleteIds) + ")", null);
            deleteIds.clear();
        }
        if (insertValues.size() != 0) {
            String insertQuery = "INSERT OR REPLACE INTO SENDERS(senderId,smsType,sender,repSender)VALUES" + TextUtils.join((CharSequence)",", insertValues);
            this.wdb.execSQL(insertQuery);
            insertValues.clear();
        }
    }

    void mergeBanks(ArrayList<Bank> banks, int bulkSize) throws SQLException {
        LogUtil.LOGI(TAG, "mergeBanks", ParserService.mIsDebug);
        ArrayList<String> deleteIds = new ArrayList<String>();
        ArrayList<String> insertValues = new ArrayList<String>();
        if (banks == null) {
            return;
        }
        for (Bank bank : banks) {
            if (bank.isDelete == 1) {
                deleteIds.add(bank.id + "");
            } else {
                insertValues.add(bank.getInsertValue());
            }
            if (deleteIds.size() == bulkSize) {
                this.delete(" BANKS", "bankId IN (" + TextUtils.join((CharSequence)",", deleteIds) + ")", null);
                deleteIds.clear();
            }
            if (insertValues.size() != bulkSize) continue;
            String insertQuery = "INSERT OR REPLACE INTO BANKS(bankId,sender)VALUES" + TextUtils.join((CharSequence)",", insertValues);
            this.wdb.execSQL(insertQuery);
            insertValues.clear();
        }
        if (deleteIds.size() != 0) {
            this.delete(" BANKS", "bankId IN (" + TextUtils.join((CharSequence)",", deleteIds) + ")", null);
            deleteIds.clear();
        }
        if (insertValues.size() != 0) {
            String insertQuery = "INSERT OR REPLACE INTO BANKS(bankId,sender)VALUES" + TextUtils.join((CharSequence)",", insertValues);
            this.wdb.execSQL(insertQuery);
            insertValues.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isNotiDuplicate(String fullSms, String sender, int smsType) {
        LogUtil.LOGI(TAG, "isNotiDuplicate", ParserService.mIsDebug);
        Cursor c = null;
        String query = " SELECT  *  FROM  TRANSACTIONS WHERE fullSms = '" + fullSms + "'" + " AND " + "sender" + " = '" + sender + "'" + " AND " + "smsType" + " = " + smsType;
        LogUtil.LOGI(TAG, "isNotiDuplicate " + query, ParserService.mIsDebug);
        try {
            c = this.runQuery(query);
            if (c != null && c.moveToFirst()) {
                LogUtil.LOGI(TAG, "isNotiDuplicate : true", ParserService.mIsDebug);
                boolean bl = true;
                return bl;
            }
        }
        catch (SQLException e) {
            LogUtil.LOGE(TAG, e.toString());
        }
        finally {
            if (c != null) {
                c.close();
            }
        }
        LogUtil.LOGI(TAG, "isNotiDuplicate : false", ParserService.mIsDebug);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isNotiDuplicate(String smsDate, String fullSms, String sender, int smsType) {
        LogUtil.LOGI(TAG, "isNotiDuplicate", ParserService.mIsDebug);
        Cursor c = null;
        String query = " SELECT  *  FROM  TRANSACTIONS WHERE smsDate = '" + smsDate + "' " + " AND " + "fullSms" + " = '" + fullSms + "'" + " AND " + "sender" + " = '" + sender + "'" + " AND " + "smsType" + " = " + smsType;
        LogUtil.LOGI(TAG, "isNotiDuplicate " + query, ParserService.mIsDebug);
        try {
            c = this.runQuery(query);
            if (c != null && c.moveToFirst()) {
                LogUtil.LOGI(TAG, "isNotiDuplicate : true", ParserService.mIsDebug);
                boolean bl = true;
                return bl;
            }
        }
        catch (SQLException e) {
            LogUtil.LOGE(TAG, e.toString());
        }
        finally {
            if (c != null) {
                c.close();
            }
        }
        LogUtil.LOGI(TAG, "isNotiDuplicate : false", ParserService.mIsDebug);
        return false;
    }
}

