package tenqube.parser.core;


import android.content.ContentValues;

import tenqube.parser.model.SMS;

class TransactionTableData{

    public TransactionTableData() {

    }

    public ContentValues toContentValues() {
        ContentValues values = new ContentValues();
        values.put(ParserReaderContract.TransactionsTable.COLUMN_IDENTIFIER, identifier);
        values.put(ParserReaderContract.TransactionsTable.COLUMN_CARD_ID, cardTableData.cardId);
        values.put(ParserReaderContract.TransactionsTable.COLUMN_SMS_ID, smsId);
        values.put(ParserReaderContract.TransactionsTable.COLUMN_FULL_SMS, fullSms);
        values.put(ParserReaderContract.TransactionsTable.COLUMN_SENDER, sender);
        values.put(ParserReaderContract.TransactionsTable.COLUMN_SMS_DATE, smsDate);
        values.put(ParserReaderContract.TransactionsTable.COLUMN_SMS_TYPE, smsType);
        values.put(ParserReaderContract.TransactionsTable.COLUMN_REG_ID, regId);
        values.put(ParserReaderContract.TransactionsTable.COLUMN_SPENT_MONEY, spentMoney);
        values.put(ParserReaderContract.TransactionsTable.COLUMN_SPENT_DATE, spentDate);
        values.put(ParserReaderContract.TransactionsTable.COLUMN_FINISH_DATE, finishDate);
        values.put(ParserReaderContract.TransactionsTable.COLUMN_KEYWORD, keyword);
        values.put(ParserReaderContract.TransactionsTable.COLUMN_INSTALLMENT_COUNT, installmentCount);
        values.put(ParserReaderContract.TransactionsTable.COLUMN_DW_TYPE, dwType);
        values.put(ParserReaderContract.TransactionsTable.COLUMN_CURRENCY, currency);

        values.put(ParserReaderContract.TransactionsTable.COLUMN_IS_OFFSET, isOffset);

        values.put(ParserReaderContract.TransactionsTable.COLUMN_IS_DUPLICATE, isDuplicate);

        values.put(ParserReaderContract.TransactionsTable.COLUMN_MEMO, memo);

        values.put(ParserReaderContract.TransactionsTable.COLUMN_SPENT_LATITUDE, spentLatitude);
        values.put(ParserReaderContract.TransactionsTable.COLUMN_SPENT_LONGITUDE, spentLongitude);
        values.put(ParserReaderContract.TransactionsTable.COLUMN_CATEGORY_CODE, categoryCode);
        values.put(ParserReaderContract.TransactionsTable.COLUMN_IS_SUCCESS, isSuccess);
        values.put(ParserReaderContract.TransactionsTable.COLUMN_ORIGIN_INFOS, originInfos);

        return values;
    }

    @Override
    public String toString() {
        return "TransactionTableData{" +
                "identifier='" + identifier + '\'' +
                ", cardTableData=" + cardTableData +
                ", originInfos='" + originInfos + '\'' +
                ", parsedBalance=" + parsedBalance +
                ", sender='" + sender + '\'' +
                ", smsId='" + smsId + '\'' +
                ", fullSms='" + fullSms + '\'' +
                ", smsDate='" + smsDate + '\'' +
                ", smsType=" + smsType +
                ", spentMoney=" + spentMoney +
                ", spentDate='" + spentDate + '\'' +
                ", finishDate='" + finishDate + '\'' +
                ", keyword='" + keyword + '\'' +
                ", installmentCount=" + installmentCount +
                ", dwType=" + dwType +
                ", currency='" + currency + '\'' +
                ", isOffset=" + isOffset +
                ", isDuplicate=" + isDuplicate +
                ", memo='" + memo + '\'' +
                ", spentLatitude=" + spentLatitude +
                ", spentLongitude=" + spentLongitude +
                ", categoryCode=" + categoryCode +
                ", isSuccess=" + isSuccess +
                ", isCurrentTran=" + isCurrentTran +
                '}';
    }

    /**
     * 클라이언트 키값
     */
    public String identifier;

    /**
     * 카드 정보
     */
    public CardTableData cardTableData;


    /**
     * 중복 처리를 위한 초기값 저장
     */
    public String originInfos;

    /**
     * 파싱된 잔액
     */
    public Double parsedBalance = null;


    /**
     * 카드사 or 은행사 전화번호
     */
    public String sender;



    /**
     * 문자 아이디
     */
    public int smsId;

    /**
     * 매칭된 regId
     */
    public int regId;

    public int userPriority;
    /**
     * 문자 메세지
     */
    public String fullSms;

    /**
     * 문자 날짜
     */
    public String smsDate;

    /**
     * 문자 타입
     * 0:notification 1:mms 2:sms
     */
    public int smsType;

    /**
     * 사용금액
     */
    public double spentMoney;

    /**
     * 사용날짜
     */
    public String spentDate;

    /**
     * 할부 마지막 날짜
     */
    public String finishDate;

    /**
     * 키워드
     */
    public String keyword;

    /**
     * 할부 개월수
     */
    public int installmentCount;

    /**
     * 0:수입 1:지출
     */
    public int dwType;

    /**
     * 통화
     */
    public String currency;

    /**
     * 승인 - 취소 상쇄 여부
     * 0: 상쇄 안됨 1: 상쇄됨
     */
    public int isOffset;

    /**
     * 중복 여부
     * 0: 중복아님 1: 중복
     */
    public int isDuplicate;

    /**
     * 메모
     */
    public String memo;

    /**
     * 위도
     */
    public double spentLatitude;

    /**
     * 경도
     */
    public double spentLongitude;


    /**
     * 카테고리 코드
     */
    public int categoryCode;

    /**
     * 서버 성공 여부
     */
    public int isSuccess;

    /**
     * 실시간 내역 여부
     */
    public boolean isCurrentTran;

}
