/*
 * Decompiled with CFR 0.152.
 */
package tenqube.parser.core;

import android.content.Context;
import android.content.res.AssetManager;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper;
import android.text.TextUtils;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import tenqube.parser.core.ParserService;
import tenqube.parser.model.Bank;
import tenqube.parser.model.RegData;
import tenqube.parser.model.Sender;
import tenqube.parser.util.LogUtil;

class DatabaseHelper
extends SQLiteOpenHelper {
    private static DatabaseHelper mInstance = null;
    private static final String DATABASE_NAME = ".tenqube.db";
    private static final int DATABASE_VERSION = 1;
    private static final String TAG = LogUtil.makeLogTag(DatabaseHelper.class);
    private Context mContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatabaseHelper getInstance(Context context) {
        Class<DatabaseHelper> clazz = DatabaseHelper.class;
        synchronized (DatabaseHelper.class) {
            if (mInstance == null) {
                mInstance = new DatabaseHelper(context);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return mInstance;
        }
    }

    private DatabaseHelper(Context context) {
        super(context, DATABASE_NAME, null, 1);
        this.mContext = context;
    }

    public void onCreate(SQLiteDatabase db) throws SQLiteException {
        db.execSQL(" DROP TABLE IF EXISTS  REG_EXPRESSION");
        db.execSQL(" CREATE TABLE  REG_EXPRESSION (regId INTEGER  PRIMARY KEY  , sender TEXT  NOT NULL  DEFAULT  'none'  , regExpression TEXT  NOT NULL  DEFAULT  'none'  , cardName TEXT  NOT NULL  DEFAULT  'none'  , cardType TEXT  NOT NULL  DEFAULT  'none'  , cardSubType TEXT  NOT NULL  DEFAULT  'none'  , cardNum TEXT  , spentMoney TEXT  NOT NULL  DEFAULT  'none'  , spentDate TEXT  , keyword TEXT  NOT NULL  DEFAULT  'none'  , installmentCount TEXT  , dwType TEXT  NOT NULL  DEFAULT  'none'  , isCancel TEXT  NOT NULL  DEFAULT  'none'  , currency TEXT  , balance TEXT  NOT NULL  DEFAULT  'none'  , userName TEXT  , priority INTEGER  NOT NULL  DEFAULT  0  , user_priority INTEGER  NOT NULL  DEFAULT  0  , smsType INTEGER  NOT NULL  DEFAULT  0  )");
        db.execSQL("CREATE INDEX qlip_reg_idx ON  REG_EXPRESSION (smsType , sender , priority , user_priority)");
        db.execSQL(" DROP TABLE IF EXISTS  SENDERS");
        db.execSQL(" CREATE TABLE  SENDERS (senderId INTEGER  PRIMARY KEY  , smsType INTEGER  NOT NULL  DEFAULT  0  , sender TEXT  NOT NULL  UNIQUE  , repSender TEXT  NOT NULL  DEFAULT  'none'  )");
        db.execSQL("CREATE INDEX qlip_senders_idx ON  SENDERS (sender)");
        db.execSQL(" DROP TABLE IF EXISTS  BANKS");
        db.execSQL(" CREATE TABLE  BANKS (bankId INTEGER  PRIMARY KEY  , sender TEXT  NOT NULL  UNIQUE  )");
        db.execSQL("CREATE INDEX qlip_banks_idx ON  BANKS (sender)");
        db.execSQL(" DROP TABLE IF EXISTS  CARDS");
        db.execSQL(" CREATE TABLE  CARDS (_id INTEGER  PRIMARY KEY  AUTOINCREMENT  , cardName TEXT  NOT NULL  DEFAULT  'none'  , cardNum TEXT  , cardType INTEGER  NOT NULL  DEFAULT  0  , cardSubType INTEGER  NOT NULL  DEFAULT  0  , balance REAL  NOT NULL  DEFAULT  0  )");
        db.execSQL("CREATE INDEX qlip_card_idx ON  CARDS (cardName,cardNum,cardType,cardSubType)");
        db.execSQL(" DROP TABLE IF EXISTS  TRANSACTIONS");
        db.execSQL(" CREATE TABLE  TRANSACTIONS (identifier TEXT  NOT NULL  UNIQUE  , cardId INTEGER  NOT NULL  DEFAULT  0  , smsId INTEGER  NOT NULL  DEFAULT  0  , fullSms TEXT  NOT NULL  DEFAULT  'none'  , sender TEXT  NOT NULL  DEFAULT  'none'  , smsType INTEGER  NOT NULL  DEFAULT  0  , smsDate DATETIME  NOT NULL  DEFAULT  0  , regId INTEGER  NOT NULL  DEFAULT  0  , spentMoney REAL  NOT NULL  DEFAULT  0  , spentDate DATETIME  NOT NULL  DEFAULT  0  , finishDate DATETIME  NOT NULL  DEFAULT  0  , keyword TEXT  NOT NULL  DEFAULT  'none'  , installmentCount INTEGER  NOT NULL  DEFAULT 1 , dwType INTEGER  NOT NULL  DEFAULT  0  , currency TEXT  , isOffset INTEGER  NOT NULL  DEFAULT  0  , isDuplicate INTEGER  NOT NULL  DEFAULT  0  , memo TEXT  , spentLatitude REAL  NOT NULL  DEFAULT  0  , spentLongitude REAL  NOT NULL  DEFAULT  0  , categoryCode INTEGER  NOT NULL  DEFAULT 101010 , isSuccess INTEGER  NOT NULL  DEFAULT 1 , originInfos TEXT  NOT NULL  DEFAULT  'none' )");
        db.execSQL("CREATE INDEX qlip_transaction_idx ON  TRANSACTIONS (identifier)");
        db.execSQL("CREATE INDEX qlip_transaction_idx2 ON  TRANSACTIONS (spentDate,dwType,isOffset,keyword)");
        db.execSQL("CREATE INDEX qlip_transaction_idx3 ON  TRANSACTIONS (spentDate,dwType,spentMoney,categoryCode)");
        this.insertRegDatas(db);
        this.insertSenders(db);
        this.insertBanks(db);
    }

    private void insertRegDatas(SQLiteDatabase db) throws SQLiteException {
        if (db != null) {
            AssetManager am = this.mContext.getAssets();
            ArrayList<String> values = new ArrayList<String>();
            int i = 0;
            try {
                String line;
                InputStream inStream = am.open("parsing_rule_encrypt.tsv");
                BufferedReader buffer = new BufferedReader(new InputStreamReader(inStream));
                while ((line = buffer.readLine()) != null) {
                    if (i == 0) {
                        ++i;
                        continue;
                    }
                    String[] colums = line.split("\t");
                    RegData regData = new RegData();
                    regData.regId = Integer.parseInt(colums[0]);
                    regData.regExpression = TextUtils.isEmpty((CharSequence)colums[1]) ? "" : colums[1];
                    regData.sender = TextUtils.isEmpty((CharSequence)colums[2]) ? "" : colums[2];
                    regData.cardName = TextUtils.isEmpty((CharSequence)colums[3]) ? "" : colums[3];
                    regData.cardNum = TextUtils.isEmpty((CharSequence)colums[4]) ? "" : colums[4];
                    regData.cardType = TextUtils.isEmpty((CharSequence)colums[5]) ? "" : colums[5];
                    regData.cardSubType = TextUtils.isEmpty((CharSequence)colums[6]) ? "" : colums[6];
                    regData.balance = TextUtils.isEmpty((CharSequence)colums[7]) ? "" : colums[7];
                    regData.spentMoney = TextUtils.isEmpty((CharSequence)colums[8]) ? "" : colums[8];
                    regData.spentDate = TextUtils.isEmpty((CharSequence)colums[9]) ? "" : colums[9];
                    regData.keyword = TextUtils.isEmpty((CharSequence)colums[10]) ? "" : colums[10];
                    regData.installmentCount = TextUtils.isEmpty((CharSequence)colums[11]) ? "" : colums[11];
                    regData.dwType = TextUtils.isEmpty((CharSequence)colums[12]) ? "" : colums[12];
                    regData.isCancel = TextUtils.isEmpty((CharSequence)colums[13]) ? "" : colums[13];
                    regData.currency = TextUtils.isEmpty((CharSequence)colums[14]) ? "" : colums[14];
                    regData.userName = TextUtils.isEmpty((CharSequence)colums[15]) ? "" : colums[15];
                    regData.priority = TextUtils.isEmpty((CharSequence)colums[16]) ? 0 : Integer.parseInt(colums[16]);
                    regData.smsType = TextUtils.isEmpty((CharSequence)colums[17]) ? 2 : Integer.parseInt(colums[17]);
                    values.add(regData.getInsertValue());
                    if (values.size() == 200) {
                        db.execSQL("INSERT OR REPLACE INTO REG_EXPRESSION(regId,sender,regExpression,cardName,cardType,cardSubType,cardNum,spentMoney,spentDate,keyword,installmentCount,dwType,isCancel,currency,balance,userName,smsType,priority)VALUES" + TextUtils.join((CharSequence)",", values));
                        values.clear();
                    }
                    ++i;
                }
                if (!values.isEmpty()) {
                    db.execSQL("INSERT OR REPLACE INTO REG_EXPRESSION(regId,sender,regExpression,cardName,cardType,cardSubType,cardNum,spentMoney,spentDate,keyword,installmentCount,dwType,isCancel,currency,balance,userName,smsType,priority)VALUES" + TextUtils.join((CharSequence)",", values));
                    values.clear();
                }
                LogUtil.LOGI(TAG, "inserted parsing rule size: " + i, ParserService.mIsDebug);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void insertSenders(SQLiteDatabase db) throws SQLiteException {
        if (db != null) {
            ArrayList<String> values = new ArrayList<String>();
            AssetManager am = this.mContext.getAssets();
            int i = 0;
            try {
                String line;
                InputStream inStream = am.open("senders.tsv");
                BufferedReader buffer = new BufferedReader(new InputStreamReader(inStream));
                while ((line = buffer.readLine()) != null) {
                    if (i == 0) {
                        ++i;
                        continue;
                    }
                    String[] colums = line.split("\t");
                    Sender sender = new Sender();
                    sender.senderId = Integer.parseInt(colums[0]);
                    sender.smsType = Integer.parseInt(colums[1]);
                    sender.sender = colums[2];
                    sender.repSender = colums[3];
                    values.add(sender.getInsertValue());
                    ++i;
                }
                if (!values.isEmpty()) {
                    String insertQuery = "INSERT OR REPLACE INTO SENDERS(senderId,smsType,sender,repSender)VALUES" + TextUtils.join((CharSequence)",", values);
                    db.execSQL(insertQuery);
                    values.clear();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void insertBanks(SQLiteDatabase db) throws SQLiteException {
        if (db != null) {
            ArrayList<String> values = new ArrayList<String>();
            AssetManager am = this.mContext.getAssets();
            int i = 0;
            try {
                String line;
                InputStream inStream = am.open("banks.tsv");
                BufferedReader buffer = new BufferedReader(new InputStreamReader(inStream));
                while ((line = buffer.readLine()) != null) {
                    if (i == 0) {
                        ++i;
                        continue;
                    }
                    String[] colums = line.split("\t");
                    Bank bank = new Bank();
                    bank.id = Integer.parseInt(colums[0]);
                    bank.name = colums[1];
                    values.add(bank.getInsertValue());
                    ++i;
                }
                if (!values.isEmpty()) {
                    String insertQuery = "INSERT OR REPLACE INTO BANKS(bankId,sender)VALUES" + TextUtils.join((CharSequence)",", values);
                    db.execSQL(insertQuery);
                    values.clear();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void onUpgrade(SQLiteDatabase db, int i, int i2) throws SQLiteException {
    }
}

