/*
 * Decompiled with CFR 0.152.
 */
package tenqube.parser.core;

import android.annotation.SuppressLint;
import android.content.ContentValues;
import android.content.Context;
import android.database.SQLException;
import android.database.sqlite.SQLiteException;
import android.text.TextUtils;
import android.util.ArrayMap;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import tenqube.parser.constants.Constants;
import tenqube.parser.core.CardTableData;
import tenqube.parser.core.DateUtil;
import tenqube.parser.core.ParserDao;
import tenqube.parser.core.ParserMapper;
import tenqube.parser.core.ParserReaderContract;
import tenqube.parser.core.ParserService;
import tenqube.parser.core.PrefUtils;
import tenqube.parser.core.RegHandler;
import tenqube.parser.core.TransactionTableData;
import tenqube.parser.core.Utils;
import tenqube.parser.model.ParserResult;
import tenqube.parser.model.ParsingRule;
import tenqube.parser.model.RegData;
import tenqube.parser.model.SMS;
import tenqube.parser.model.Sender;
import tenqube.parser.model.Transaction;
import tenqube.parser.util.LogUtil;

class ParserPresenter {
    private static final String TAG = LogUtil.makeLogTag(ParserPresenter.class);
    private Context mContext;
    private ParserMapper mMapper;
    private RegHandler mRegHandler;
    private ParserDao mParserDao;
    private Map<String, ArrayList<RegData>> mRegMap = new HashMap<String, ArrayList<RegData>>();
    private Map<String, String> mSendersMap = new HashMap<String, String>();
    private Map<String, ArrayList<TransactionTableData>> mDuplMap = new HashMap<String, ArrayList<TransactionTableData>>();
    private Map<String, ArrayList<TransactionTableData>> mMovingAssetMap = new HashMap<String, ArrayList<TransactionTableData>>();
    private Map<String, ArrayList<TransactionTableData>> mOffsetMap = new HashMap<String, ArrayList<TransactionTableData>>();
    private Map<String, TransactionTableData> mTransactionMap = new HashMap<String, TransactionTableData>();
    private Map<String, CardTableData> mCardMap = new HashMap<String, CardTableData>();

    ParserPresenter(Context context) {
        this.mContext = context;
        this.mParserDao = new ParserDao(context);
        this.mMapper = new ParserMapper();
        this.mRegHandler = new RegHandler(context);
        LogUtil.LOGI(TAG, "ParsingHelper constructor", ParserService.mIsDebug);
    }

    void initTransactions() {
        this.mParserDao.initTransactions();
    }

    void setSendersWithBulk() {
        LogUtil.LOGI(TAG, "setSenders", ParserService.mIsDebug);
        this.mSendersMap = this.mParserDao.getSendersMap();
    }

    ArrayList<Transaction> parseWithBulk(SMS sms) {
        ArrayList<Transaction> resultTrans;
        TransactionTableData offsetTran = null;
        TransactionTableData movingAssetTran = null;
        if (!Utils.isSpendSMS(sms.getFullSms())) {
            return null;
        }
        String repSender = this.getRepSender(sms);
        LogUtil.LOGI(TAG, "0. sender \ub300\ud45c \ud544\ud130" + repSender, ParserService.mIsDebug);
        if (repSender == null) {
            return null;
        }
        if (this.isExistTranWithBulk(sms.getSmsId(), sms.getSmsDate())) {
            LogUtil.LOGI(TAG, "maxSmsId:" + PrefUtils.getInstance(this.mContext).loadIntValue("MAX_SMS_ID", 0), ParserService.mIsDebug);
            LogUtil.LOGI(TAG, "smsId:" + sms.getSmsId(), ParserService.mIsDebug);
            LogUtil.LOGI(TAG, "smsDate:" + sms.getSmsDate(), ParserService.mIsDebug);
            LogUtil.LOGI(TAG, "isExistTranWithBulk: \uc774\ubbf8 \uc874\uc7ac", ParserService.mIsDebug);
            return null;
        }
        TransactionTableData transaction = this.getBulkTransactionWithReg(sms, repSender);
        if (transaction == null) {
            LogUtil.LOGI(TAG, "1. \uc815\uaddc\ud45c\ud604\uc2dd\uc744 \ud1b5\ud55c \ub370\uc774\ud130 \ud655\uc778: FALSE", ParserService.mIsDebug);
            LogUtil.LOGI(TAG, "NOT PARSED: " + sms.toString(), ParserService.mIsDebug);
            return null;
        }
        LogUtil.LOGI(TAG, "1. \uc815\uaddc\ud45c\ud604\uc2dd\uc744 \ud1b5\ud55c \ub370\uc774\ud130 \ud655\uc778: TRUE" + transaction.toString(), ParserService.mIsDebug);
        LogUtil.LOGI(TAG, "2. \uc911\ubcf5 \ub370\uc774\ud130 \ud655\uc778", ParserService.mIsDebug);
        TransactionTableData duplicationTran = this.getDuplicationTranWithBulk(transaction);
        if (duplicationTran != null) {
            LogUtil.LOGI(TAG, "2. \uc911\ubcf5 \ub370\uc774\ud130 \ud655\uc778: TRUE" + duplicationTran.toString(), ParserService.mIsDebug);
            transaction = this.mRegHandler.combineTran(duplicationTran, transaction);
            String key = Utils.makeSpentMoneyDwTypeKey(transaction.spentMoney, transaction.dwType);
            if (this.mDuplMap != null) {
                ArrayList<TransactionTableData> duplTrans = this.mDuplMap.get(key);
                duplTrans.add(transaction);
                this.mDuplMap.put(key, duplTrans);
            }
        } else {
            LogUtil.LOGI(TAG, "2. \uc911\ubcf5 \ub370\uc774\ud130 \ud655\uc778: FALSE", ParserService.mIsDebug);
            offsetTran = this.getOffsetTranWithBulk(transaction);
            LogUtil.LOGI(TAG, "3. \uc911\ubcf5 x \uc0c1\uc1c4 Tran \ud655\uc778", ParserService.mIsDebug);
            if (offsetTran != null) {
                LogUtil.LOGI(TAG, "3. \uc911\ubcf5 x -> \uc0c1\uc1c4 Tran \ud655\uc778: TRUE" + offsetTran.toString(), ParserService.mIsDebug);
                transaction = this.mRegHandler.combineTranWithOffset(offsetTran, transaction);
            } else {
                LogUtil.LOGI(TAG, "3. \uc911\ubcf5 x -> \uc0c1\uc1c4 Tran \ud655\uc778: FALSE", ParserService.mIsDebug);
                LogUtil.LOGI(TAG, "4. \uc911\ubcf5 x -> \uc0c1\uc1c4 x -> \uc790\uc0b0\uc774\ub3d9 Tran \ud655\uc778", ParserService.mIsDebug);
                movingAssetTran = this.getMovingAssetTranWithBulk(transaction);
                if (movingAssetTran != null) {
                    LogUtil.LOGI(TAG, "4. \uc911\ubcf5 x \uc0c1\uc1c4 x \uc790\uc0b0\uc774\ub3d9 Tran \ud655\uc778: TRUE" + movingAssetTran.toString(), ParserService.mIsDebug);
                    transaction = this.mRegHandler.combineTranWithMovingAsset(transaction);
                    movingAssetTran = this.mRegHandler.combineTranWithMovingAsset(movingAssetTran);
                } else {
                    LogUtil.LOGI(TAG, "4. \uc911\ubcf5 x \uc0c1\uc1c4 x \uc790\uc0b0\uc774\ub3d9 Tran \ud655\uc778: FALSE", ParserService.mIsDebug);
                }
            }
        }
        if (transaction != null) {
            transaction = this.mRegHandler.updateBalance(transaction);
            transaction.isCurrentTran = true;
        }
        if ((resultTrans = this.getResultTransactionsWithBulk(transaction, offsetTran, movingAssetTran)).size() == 0) {
            return null;
        }
        LogUtil.LOGI(TAG, "\ucd5c\uc885 \ub9ac\ud134 \uc0ac\uc774\uc988:" + resultTrans.size(), ParserService.mIsDebug);
        return resultTrans;
    }

    public String getRepSender(SMS sms) {
        String repSender = this.getRepSenderWithBulk(Utils.transformSender(sms.getSender()));
        if (repSender == null) {
            repSender = this.getRepSenderWithBulk(sms.getSender());
        }
        if (repSender == null) {
            repSender = this.getRepSenderWithBulk(Utils.transformSender(sms.getDisplaySender()));
        }
        if (repSender == null) {
            repSender = this.getRepSenderWithBulk(sms.getDisplaySender());
        }
        if (repSender == null) {
            repSender = Utils.transformRepSender(sms.getFullSms());
        }
        return repSender;
    }

    private ArrayList<Transaction> getResultTransactionsWithBulk(TransactionTableData parsedTransaction, TransactionTableData offsetTran, TransactionTableData movingAssetTran) {
        LogUtil.LOGI(TAG, "getResultTransactionsWithBulk", ParserService.mIsDebug);
        ArrayList<Transaction> resultTrans = new ArrayList<Transaction>();
        try {
            ArrayList<TransactionTableData> transactions = new ArrayList<TransactionTableData>();
            if (parsedTransaction != null) {
                transactions.add(parsedTransaction);
            }
            if (offsetTran != null) {
                transactions.add(offsetTran);
            }
            if (movingAssetTran != null) {
                transactions.add(movingAssetTran);
            }
            for (TransactionTableData tran : transactions) {
                Transaction resultTran;
                if (this.mTransactionMap != null) {
                    this.mTransactionMap.put(tran.identifier, tran);
                }
                if (this.mCardMap != null) {
                    this.mCardMap.put(Utils.makeCardKey(tran.cardTableData), tran.cardTableData);
                }
                if ((resultTran = this.mMapper.transform(tran)) == null) continue;
                resultTrans.add(resultTran);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return resultTrans;
    }

    private String getRepSenderWithBulk(String sender) {
        if (TextUtils.isEmpty((CharSequence)sender)) {
            return null;
        }
        LogUtil.LOGI(TAG, "getRepSender", ParserService.mIsDebug);
        return this.mSendersMap == null ? this.mParserDao.getRepSender(sender) : this.mSendersMap.get(sender);
    }

    private TransactionTableData getBulkTransactionWithReg(SMS sms, String repSender) {
        LogUtil.LOGI(TAG, "getBulkTransactionWithReg start" + sms.toString(), ParserService.mIsDebug);
        String newFullSms = Utils.transformFullSMS(sms.getFullSms());
        LogUtil.LOGI(TAG, "getBulkTransactionWithReg newFullSms" + newFullSms, ParserService.mIsDebug);
        TransactionTableData parsedTran = this.mRegHandler.getTransactionWithReg(this.getRegDatasWithBulk(repSender, sms.getSmsType()), sms);
        if (parsedTran != null) {
            parsedTran.cardTableData = this.getCardWithBulk(parsedTran.cardTableData);
            if (parsedTran.userPriority < 10) {
                this.updateUserPriorityWithBulk(repSender, sms.getSmsType());
            }
        }
        return parsedTran;
    }

    private ArrayList<RegData> getRegDatasWithBulk(String repSender, int smsType) {
        ArrayList<RegData> regDatas;
        smsType = Utils.getSMSType(smsType);
        String key = Utils.makeRegKey(repSender, smsType);
        if (this.mRegMap == null) {
            this.mRegMap = new HashMap<String, ArrayList<RegData>>();
        }
        if ((regDatas = this.mRegMap.get(key)) == null) {
            regDatas = this.mParserDao.getRegDatasWithBulk(repSender, smsType);
        }
        return regDatas;
    }

    private CardTableData getCardWithBulk(CardTableData parsedCard) throws SQLException {
        String key;
        CardTableData cardTableData;
        LogUtil.LOGI(TAG, "getCard", ParserService.mIsDebug);
        if (this.mCardMap == null) {
            this.mCardMap = new HashMap<String, CardTableData>();
        }
        if ((cardTableData = this.mCardMap.get(key = Utils.makeCardKey(parsedCard))) != null) {
            return cardTableData;
        }
        cardTableData = this.mParserDao.getCard(parsedCard);
        this.mCardMap.put(key, cardTableData);
        return cardTableData;
    }

    private boolean isExistTranWithBulk(long smsId, String smsDate) {
        return smsId != 0L && ((long)PrefUtils.getInstance(this.mContext).loadIntValue("MAX_SMS_ID", 0) == smsId || (long)PrefUtils.getInstance(this.mContext).loadIntValue("MAX_SMS_DATE", 0) > DateUtil.convertStringToCalendarFULL(smsDate).getTimeInMillis());
    }

    private TransactionTableData getDuplicationTranWithBulk(TransactionTableData tran) throws SQLException {
        LogUtil.LOGI(TAG, "getDuplicationTran", ParserService.mIsDebug);
        TransactionTableData duplicationTran = null;
        try {
            ArrayList<TransactionTableData> duplTrans;
            String key = Utils.makeSpentMoneyDwTypeKey(tran.spentMoney, tran.dwType);
            LogUtil.LOGI(TAG, "getDuplicationTran key" + key, ParserService.mIsDebug);
            if (this.mDuplMap == null) {
                this.mDuplMap = new HashMap<String, ArrayList<TransactionTableData>>();
            }
            if ((duplicationTran = this.getDuplicationTranWithBulk(key, duplTrans = this.mDuplMap.get(key), tran, true)) == null) {
                int dwType = tran.dwType == Constants.DWType.DEPOSIT.ordinal() ? Constants.DWType.WITHDRAW.ordinal() : Constants.DWType.DEPOSIT.ordinal();
                key = Utils.makeSpentMoneyDwTypeKey(-1.0 * tran.spentMoney, dwType);
                duplTrans = this.mDuplMap.get(key);
                duplicationTran = this.getDuplicationTranWithBulk(key, duplTrans, tran, false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return duplicationTran;
    }

    private TransactionTableData getDuplicationTranWithBulk(String key, ArrayList<TransactionTableData> duplTrans, TransactionTableData tran, boolean isInsert) {
        LogUtil.LOGI(TAG, "getDuplicationTranWithBulk", ParserService.mIsDebug);
        TransactionTableData duplicationTran = null;
        try {
            if (duplTrans == null || duplTrans.isEmpty()) {
                if (isInsert) {
                    duplTrans = new ArrayList();
                    duplTrans.add(tran);
                    if (this.mDuplMap != null) {
                        this.mDuplMap.put(key, duplTrans);
                    }
                }
                return null;
            }
            Calendar spendCal = DateUtil.convertStringToCalendarFULL(tran.spentDate);
            Calendar fixedCal = DateUtil.convertStringToCalendarFULL(tran.spentDate);
            fixedCal.add(11, -14);
            spendCal.add(12, 5);
            long endSpendTime = spendCal.getTimeInMillis();
            long fixedSpendTime = fixedCal.getTimeInMillis();
            if ("\uc0bc\uc131\ud398\uc774".equals(tran.cardTableData.cardName) || "LG Pay".equals(tran.cardTableData.cardName)) {
                spendCal.add(11, -13);
            } else {
                spendCal.add(12, -15);
            }
            long startSpendTime = spendCal.getTimeInMillis();
            for (int i = duplTrans.size() - 1; i >= 0; --i) {
                TransactionTableData dupl = duplTrans.get(i);
                long duplSpendTime = DateUtil.convertStringToCalendarFULL(dupl.spentDate).getTimeInMillis();
                if (duplSpendTime < fixedSpendTime || startSpendTime >= duplSpendTime || endSpendTime < duplSpendTime || !this.mRegHandler.isDuplicate(dupl.originInfos, tran.originInfos)) continue;
                duplicationTran = dupl;
                duplTrans.remove(i);
                break;
            }
            if (isInsert && duplicationTran == null) {
                duplTrans.add(tran);
            }
            if (this.mDuplMap != null) {
                this.mDuplMap.put(key, duplTrans);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return duplicationTran;
    }

    @SuppressLint(value={"NewApi"})
    private TransactionTableData getOffsetTranWithBulk(TransactionTableData parsedTran) throws SQLException {
        LogUtil.LOGI(TAG, "getOffsetTran", ParserService.mIsDebug);
        try {
            String key;
            ArrayList<TransactionTableData> offsetTrans;
            if (parsedTran.spentMoney < 0.0) {
                String key2 = Utils.makeSpentMoneyDwTypeKey(-1.0 * parsedTran.spentMoney, parsedTran.dwType);
                ArrayList<TransactionTableData> offsetTrans2 = this.mOffsetMap.get(key2);
                if (offsetTrans2 == null || offsetTrans2.isEmpty()) {
                    return null;
                }
                TransactionTableData offsetTran = null;
                Calendar spendCal = DateUtil.convertStringToCalendarFULL(parsedTran.spentDate);
                spendCal.add(5, 1);
                long endSpendTime = spendCal.getTimeInMillis();
                spendCal.add(2, -2);
                long startSpendTime = spendCal.getTimeInMillis();
                for (int i = offsetTrans2.size() - 1; i >= 0; --i) {
                    TransactionTableData offset = offsetTrans2.get(i);
                    long offsetSpendTime = DateUtil.convertStringToCalendarFULL(offset.spentDate).getTimeInMillis();
                    if (startSpendTime > offsetSpendTime || endSpendTime <= offsetSpendTime || !parsedTran.keyword.equals(offset.keyword) && !offset.cardTableData.cardName.contains(parsedTran.cardTableData.cardName) && !offset.cardTableData.cardName.contains(Utils.transformCardName(parsedTran.cardTableData.cardName))) continue;
                    offsetTran = offset;
                    offsetTran.isOffset = 1;
                    offsetTrans2.remove(i);
                    break;
                }
                if (this.mOffsetMap != null) {
                    this.mOffsetMap.put(key2, offsetTrans2);
                }
                return offsetTran;
            }
            if (this.mOffsetMap == null) {
                this.mOffsetMap = new ArrayMap();
            }
            if ((offsetTrans = this.mOffsetMap.get(key = Utils.makeSpentMoneyDwTypeKey(parsedTran.spentMoney, parsedTran.dwType))) == null) {
                offsetTrans = new ArrayList();
            }
            offsetTrans.add(parsedTran);
            this.mOffsetMap.put(key, offsetTrans);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private TransactionTableData getMovingAssetTranWithBulk(TransactionTableData tran) throws SQLException {
        LogUtil.LOGI(TAG, "getMovingAssetTran", ParserService.mIsDebug);
        try {
            if (tran.cardTableData.cardType == Constants.CardType.BANK_ACCOUNT.ordinal()) {
                ArrayList<TransactionTableData> assetTrans;
                String key = tran.spentMoney + "";
                if (this.mMovingAssetMap == null) {
                    this.mMovingAssetMap = new HashMap<String, ArrayList<TransactionTableData>>();
                }
                if ((assetTrans = this.mMovingAssetMap.get(key)) == null || assetTrans.isEmpty()) {
                    assetTrans = new ArrayList();
                    assetTrans.add(tran);
                    this.mMovingAssetMap.put(key, assetTrans);
                    return null;
                }
                TransactionTableData movingAssetTran = null;
                Calendar spendCal = DateUtil.convertStringToCalendarFULL(tran.spentDate);
                spendCal.add(12, 3);
                long endSpendTime = spendCal.getTimeInMillis();
                spendCal.add(12, -6);
                long startSpendTime = spendCal.getTimeInMillis();
                for (int i = assetTrans.size() - 1; i >= 0; --i) {
                    TransactionTableData asset = assetTrans.get(i);
                    long assetSpendTime = DateUtil.convertStringToCalendarFULL(asset.spentDate).getTimeInMillis();
                    if (startSpendTime >= assetSpendTime || endSpendTime < assetSpendTime || asset.cardTableData.cardName.equals(tran.cardTableData.cardName) && asset.cardTableData.cardNum.equals(tran.cardTableData.cardNum) || asset.dwType == tran.dwType) continue;
                    movingAssetTran = asset;
                    assetTrans.remove(i);
                    break;
                }
                if (movingAssetTran == null) {
                    assetTrans.add(tran);
                }
                this.mMovingAssetMap.put(key, assetTrans);
                return movingAssetTran;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    void initMap() {
        this.mRegMap = new HashMap<String, ArrayList<RegData>>();
        this.mSendersMap = new HashMap<String, String>();
        this.mDuplMap = new HashMap<String, ArrayList<TransactionTableData>>();
        this.mMovingAssetMap = new HashMap<String, ArrayList<TransactionTableData>>();
        this.mOffsetMap = new HashMap<String, ArrayList<TransactionTableData>>();
        this.mTransactionMap = new HashMap<String, TransactionTableData>();
        this.mCardMap = new HashMap<String, CardTableData>();
    }

    void insertTransactionAndMaxSmsId(ArrayList<Transaction> transactions) {
        LogUtil.LOGI(TAG, "insertTransactionAndMaxSmsId", ParserService.mIsDebug);
        int maxSMSId = 0;
        int maxMMSId = 0;
        int maxSmsDate = 0;
        try {
            HashMap<Integer, RegData> regDataMap = new HashMap<Integer, RegData>();
            HashMap<Integer, CardTableData> cardMap = new HashMap<Integer, CardTableData>();
            ArrayList<ContentValues> tranValues = new ArrayList<ContentValues>();
            for (int i = 0; i < transactions.size(); ++i) {
                TransactionTableData transactionTableData;
                Transaction tran = transactions.get(i);
                if (this.mTransactionMap != null && (transactionTableData = this.mTransactionMap.get(tran.identifier)) != null) {
                    CardTableData cardTableData;
                    tranValues.add(transactionTableData.toContentValues());
                    transactionTableData.isSuccess = 1;
                    String key = Utils.makeRegKey(Utils.transformSender(transactionTableData.sender), Utils.getSMSType(transactionTableData.smsType));
                    ArrayList<RegData> regDatas = this.mRegMap.get(key);
                    if (regDatas != null) {
                        for (RegData regData : regDatas) {
                            if (regData.regId != transactionTableData.regId) continue;
                            regDataMap.put(regData.regId, regData);
                            break;
                        }
                    }
                    if (this.mCardMap != null && (cardTableData = this.mCardMap.get(Utils.makeCardKey(transactionTableData.cardTableData))) != null && transactionTableData.cardTableData.cardId == cardTableData.cardId) {
                        cardMap.put(cardTableData.cardId, cardTableData);
                    }
                }
                if (tran.smsType == Constants.SMSType.SMS.ordinal()) {
                    int smsDate;
                    if (maxSMSId < tran.smsId) {
                        maxSMSId = tran.smsId;
                    }
                    if (maxSmsDate >= (smsDate = (int)DateUtil.convertStringToCalendarFULL(tran.smsDate).getTimeInMillis())) continue;
                    maxSmsDate = smsDate;
                    continue;
                }
                if (tran.smsType != Constants.SMSType.MMS.ordinal() || maxMMSId >= tran.smsId) continue;
                maxMMSId = tran.smsId;
            }
            for (Map.Entry elem : cardMap.entrySet()) {
                ContentValues values1 = ParserReaderContract.CardTable.populateContent((CardTableData)elem.getValue());
                String[] selectionArgs = new String[]{elem.getKey() + ""};
                this.mParserDao.update(" CARDS", values1, "_id= ?", selectionArgs);
            }
            for (Map.Entry elem : regDataMap.entrySet()) {
                ContentValues regValues = new ContentValues();
                regValues.put("user_priority", Integer.valueOf(((RegData)elem.getValue()).userPriority));
                this.mParserDao.update(" REG_EXPRESSION", regValues, "regId=" + elem.getKey(), null);
            }
            for (ContentValues value : tranValues) {
                try {
                    this.mParserDao.insertOrReplace(" TRANSACTIONS", value);
                }
                catch (Exception exception) {}
            }
            if (maxSMSId != 0) {
                PrefUtils.getInstance(this.mContext).saveIntValue("MAX_SMS_ID", maxSMSId);
            }
            if (maxSmsDate != 0) {
                PrefUtils.getInstance(this.mContext).saveIntValue("MAX_SMS_DATE", maxSmsDate);
            }
            if (maxMMSId != 0) {
                PrefUtils.getInstance(this.mContext).saveIntValue("MAX_MMS_ID", maxMMSId);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void updateUserPriorityWithBulk(String repSender, int smsType) {
        String key;
        ArrayList<RegData> regDatas;
        if (this.mRegMap != null && (regDatas = this.mRegMap.get(key = Utils.makeRegKey(repSender, Utils.getSMSType(smsType)))) != null) {
            Collections.sort(regDatas, new Utils.RegComparator());
            this.mRegMap.put(key, regDatas);
        }
    }

    void onBulkComplete() {
        this.mRegMap = null;
        this.mSendersMap = null;
        this.mDuplMap = null;
        this.mMovingAssetMap = null;
        this.mOffsetMap = null;
        this.mTransactionMap = null;
        this.mCardMap = null;
    }

    ParserResult parse(SMS sms) {
        ArrayList<Transaction> resultTrans;
        ParserResult parserResult = new ParserResult();
        TransactionTableData offsetTran = null;
        TransactionTableData movingAssetTran = null;
        if (!Utils.isSpendSMS(sms.getFullSms())) {
            return this.setNotParsedResult(sms, false, parserResult);
        }
        if ("com.kakao.talk".equals(sms.getSender()) && !this.mParserDao.isBankMsgWithKakao(sms.getTitle())) {
            parserResult.resultCode = 0;
            return parserResult;
        }
        String repSender = this.mParserDao.getRepSender(sms.getSender(), sms.getDisplaySender());
        if (repSender == null) {
            repSender = Utils.transformRepSender(sms.getFullSms());
        }
        LogUtil.LOGI(TAG, "0. sender \ub300\ud45c \ud544\ud130" + repSender, ParserService.mIsDebug);
        if (repSender == null) {
            return this.setNotParsedResult(sms, false, parserResult);
        }
        LogUtil.LOGI(TAG, "1. \uc815\uaddc\ud45c\ud604\uc2dd\uc744 \ud1b5\ud55c \ub370\uc774\ud130 \ud655\uc778", ParserService.mIsDebug);
        TransactionTableData transaction = this.getTransactionWithReg(sms, repSender);
        if (transaction == null) {
            LogUtil.LOGI(TAG, "1. \uc815\uaddc\ud45c\ud604\uc2dd\uc744 \ud1b5\ud55c \ub370\uc774\ud130 \ud655\uc778: FALSE", ParserService.mIsDebug);
            LogUtil.LOGI(TAG, "NOT PARSED" + sms.toString(), ParserService.mIsDebug);
            return this.setNotParsedResult(sms, true, parserResult);
        }
        LogUtil.LOGI(TAG, "1. \uc815\uaddc\ud45c\ud604\uc2dd\uc744 \ud1b5\ud55c \ub370\uc774\ud130 \ud655\uc778: TRUE" + transaction.toString(), ParserService.mIsDebug);
        if (sms.shouldIgnoreDate() ? this.mParserDao.isNotiDuplicate(transaction.fullSms, transaction.sender, transaction.smsType) : this.mParserDao.isNotiDuplicate(transaction.smsDate, transaction.fullSms, transaction.sender, transaction.smsType)) {
            return this.setNotParsedResult(sms, false, parserResult);
        }
        LogUtil.LOGI(TAG, "2. \uc911\ubcf5 \ub370\uc774\ud130 \ud655\uc778", ParserService.mIsDebug);
        TransactionTableData duplicationTran = this.mParserDao.getDuplicationTran(transaction, this.mRegHandler);
        if (duplicationTran != null) {
            LogUtil.LOGI(TAG, "2. \uc911\ubcf5 \ub370\uc774\ud130 \ud655\uc778: TRUE" + duplicationTran.toString(), ParserService.mIsDebug);
            transaction = this.mRegHandler.combineTran(duplicationTran, transaction);
        } else {
            LogUtil.LOGI(TAG, "2. \uc911\ubcf5 \ub370\uc774\ud130 \ud655\uc778: FALSE", ParserService.mIsDebug);
            offsetTran = this.mParserDao.getOffsetTran(transaction);
            LogUtil.LOGI(TAG, "3. \uc911\ubcf5 x \uc0c1\uc1c4 Tran \ud655\uc778", ParserService.mIsDebug);
            if (offsetTran != null) {
                LogUtil.LOGI(TAG, "3. \uc911\ubcf5 x -> \uc0c1\uc1c4 Tran \ud655\uc778: TRUE" + offsetTran.toString(), ParserService.mIsDebug);
                transaction = this.mRegHandler.combineTranWithOffset(offsetTran, transaction);
            } else {
                LogUtil.LOGI(TAG, "3. \uc911\ubcf5 x -> \uc0c1\uc1c4 Tran \ud655\uc778: FALSE", ParserService.mIsDebug);
                LogUtil.LOGI(TAG, "4. \uc911\ubcf5 x -> \uc0c1\uc1c4 x -> \uc790\uc0b0\uc774\ub3d9 Tran \ud655\uc778", ParserService.mIsDebug);
                movingAssetTran = this.mParserDao.getMovingAssetTran(transaction);
                if (movingAssetTran != null) {
                    LogUtil.LOGI(TAG, "4. \uc911\ubcf5 x \uc0c1\uc1c4 x \uc790\uc0b0\uc774\ub3d9 Tran \ud655\uc778: TRUE" + movingAssetTran.toString(), ParserService.mIsDebug);
                    transaction = this.mRegHandler.combineTranWithMovingAsset(transaction);
                    movingAssetTran = this.mRegHandler.combineTranWithMovingAsset(movingAssetTran);
                } else {
                    LogUtil.LOGI(TAG, "4. \uc911\ubcf5 x \uc0c1\uc1c4 x \uc790\uc0b0\uc774\ub3d9 Tran \ud655\uc778: FALSE", ParserService.mIsDebug);
                }
            }
        }
        if (transaction != null) {
            transaction = this.mRegHandler.updateBalance(transaction);
        }
        if ((resultTrans = this.getResultTransactions(transaction, offsetTran, movingAssetTran)).size() == 0) {
            return this.setNotParsedResult(sms, true, parserResult);
        }
        LogUtil.LOGI(TAG, "\ucd5c\uc885 \ub9ac\ud134 \uc0ac\uc774\uc988:" + resultTrans.size(), ParserService.mIsDebug);
        parserResult.transactions = resultTrans;
        parserResult.resultCode = 1;
        return parserResult;
    }

    private ParserResult setNotParsedResult(SMS sms, boolean isSender, ParserResult parserResult) {
        parserResult.resultCode = !TextUtils.isEmpty((CharSequence)sms.getFullSms()) && (sms.getFullSms().contains("\uc6d0") || sms.getFullSms().contains(":") || sms.getFullSms().contains("/") || sms.getFullSms().contains(".")) ? (isSender ? -5 : -6) : 0;
        return parserResult;
    }

    private ArrayList<Transaction> getResultTransactions(TransactionTableData transaction, TransactionTableData offsetTran, TransactionTableData movingAssetTran) {
        ArrayList<Transaction> resultTrans = new ArrayList<Transaction>();
        try {
            ArrayList<TransactionTableData> transactions = new ArrayList<TransactionTableData>();
            if (transaction != null) {
                transactions.add(transaction);
            }
            if (offsetTran != null) {
                transactions.add(offsetTran);
            }
            if (movingAssetTran != null) {
                transactions.add(movingAssetTran);
            }
            for (TransactionTableData tran : transactions) {
                this.mParserDao.mergeTransaction(tran);
                Transaction resultTran = this.mMapper.transform(tran);
                if (resultTran == null) continue;
                LogUtil.LOGI(TAG, "result" + resultTran.toString(), ParserService.mIsDebug);
                resultTrans.add(resultTran);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return resultTrans;
    }

    private TransactionTableData getTransactionWithReg(SMS sms, String repSender) throws SQLException {
        LogUtil.LOGI(TAG, "getTransactionWithReg start" + sms.toString(), ParserService.mIsDebug);
        ArrayList<RegData> regDatas = this.mParserDao.getRegDatas(repSender, sms.getSmsType());
        TransactionTableData parsedTran = this.mRegHandler.getTransactionWithReg(regDatas, sms);
        if (parsedTran != null) {
            parsedTran.cardTableData = this.mParserDao.getCard(parsedTran.cardTableData);
            if (parsedTran.userPriority < 10) {
                this.mParserDao.updateUserPriority(parsedTran.regId, parsedTran.userPriority);
            }
        }
        return parsedTran;
    }

    void deleteOldTransaction(String smsDate) {
        LogUtil.LOGI(TAG, "deleteOldTransaction", ParserService.mIsDebug);
        Calendar cal = DateUtil.convertStringToCalendarFULL(smsDate);
        cal.add(2, -2);
        this.mParserDao.delete(" TRANSACTIONS", "smsDate<'" + DateUtil.getStringDateAsYYYYMMddHHmmss(cal) + "'", null);
    }

    void updateIsSuccess(ArrayList<Transaction> transactions, int isSuccess) throws SQLException {
        LogUtil.LOGI(TAG, "updateIsSuccess", ParserService.mIsDebug);
        ArrayList<String> identifierList = new ArrayList<String>();
        for (Transaction transaction : transactions) {
            identifierList.add("'" + transaction.identifier + "'");
        }
        ContentValues values = new ContentValues();
        values.put("isSuccess", Integer.valueOf(isSuccess));
        this.mParserDao.update(" TRANSACTIONS", values, "identifier IN (" + TextUtils.join((CharSequence)",", identifierList) + ")", null);
    }

    void syncParsingRule(ParsingRule parsingRule, int bulkSize) {
        try {
            LogUtil.LOGI(TAG, "syncParsingRule", ParserService.mIsDebug);
            this.mParserDao.mergeRegDatas(parsingRule.regDatas, bulkSize);
            this.mParserDao.mergeSenders(parsingRule.senders, bulkSize);
            this.mParserDao.mergeBanks(parsingRule.banks, bulkSize);
        }
        catch (SQLiteException e) {
            e.printStackTrace();
        }
    }

    void initDb() throws SQLException {
        LogUtil.LOGI(TAG, "initDb", ParserService.mIsDebug);
        this.mParserDao.initDb();
    }

    void addTestOriginNumber(String number) throws SQLException {
        LogUtil.LOGI(TAG, "addTestOriginNumber", ParserService.mIsDebug);
        int minId = this.mParserDao.getMinSendersId();
        int id = minId >= 0 ? -1 : minId - 1;
        Sender sender = new Sender();
        sender.senderId = id;
        sender.sender = Utils.transformSender(number);
        sender.repSender = "ALL";
        sender.smsType = Constants.SMSType.SMS.ordinal();
        ContentValues values = ParserReaderContract.SendersTable.populateContent(sender);
        String[] selectionArgs = new String[]{sender.sender};
        long suc = this.mParserDao.update(" SENDERS", values, "sender= ?", selectionArgs);
        if (suc == 0L) {
            this.mParserDao.insert(" SENDERS", values);
        }
    }

    ArrayList<RegData> getParsingRule(ArrayList<Integer> regIds) {
        return this.mParserDao.findByIds(regIds);
    }
}

