/*
 * Decompiled with CFR 0.152.
 */
package tenqube.parser.core;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.provider.BaseColumns;
import android.text.TextUtils;
import java.util.Calendar;
import tenqube.parser.core.AES128Cipher;
import tenqube.parser.core.CardTableData;
import tenqube.parser.core.DateUtil;
import tenqube.parser.core.TransactionTableData;
import tenqube.parser.model.Bank;
import tenqube.parser.model.RegData;
import tenqube.parser.model.Sender;

final class ParserReaderContract {
    private static final String TEXT_TYPE = " TEXT ";
    private static final String REAL_TYPE = " REAL ";
    private static final String INTEGER_TYPE = " INTEGER ";
    private static final String COMMA_SEP = " , ";
    private static final String DATE_TYPE = " DATETIME ";
    private static final String DEFAULT = " DEFAULT ";
    private static final String NOT_NULL = " NOT NULL ";
    private static final String PRIMARY_KEY = " PRIMARY KEY ";
    private static final String UNIQUE = " UNIQUE ";
    private static final String AUTOINCREMENT = " AUTOINCREMENT ";
    private static final String CREATE_TABLE = " CREATE TABLE ";
    private static final String CREATE_TABLE_IF_NOT_EXISTS = " CREATE TABLE IF NOT EXISTS ";
    private static final String DROP_TABLE_IF_EXISTS = " DROP TABLE IF EXISTS ";
    private static final String DEFAULT_TEXT = " 'none' ";
    private static final String DEFAULT_INT = " 0 ";
    private static final String DEFAULT_DATE = " current_timestamp ";

    private ParserReaderContract() {
    }

    static class TransactionsTable
    implements BaseColumns {
        static final String TABLE_NAME = " TRANSACTIONS";
        static final String ALIAS = " tran.";
        static final String AS_ALIAS = " AS tran ";
        static final String COLUMN_IDENTIFIER = "identifier";
        static final String COLUMN_CARD_ID = "cardId";
        static final String COLUMN_SMS_ID = "smsId";
        static final String COLUMN_FULL_SMS = "fullSms";
        static final String COLUMN_SENDER = "sender";
        static final String COLUMN_SMS_DATE = "smsDate";
        static final String COLUMN_SMS_TYPE = "smsType";
        static final String COLUMN_REG_ID = "regId";
        static final String COLUMN_SPENT_MONEY = "spentMoney";
        static final String COLUMN_SPENT_DATE = "spentDate";
        static final String COLUMN_FINISH_DATE = "finishDate";
        static final String COLUMN_KEYWORD = "keyword";
        static final String COLUMN_INSTALLMENT_COUNT = "installmentCount";
        static final String COLUMN_DW_TYPE = "dwType";
        static final String COLUMN_CURRENCY = "currency";
        static final String COLUMN_IS_OFFSET = "isOffset";
        static final String COLUMN_IS_DUPLICATE = "isDuplicate";
        static final String COLUMN_MEMO = "memo";
        static final String COLUMN_SPENT_LATITUDE = "spentLatitude";
        static final String COLUMN_SPENT_LONGITUDE = "spentLongitude";
        static final String COLUMN_CATEGORY_CODE = "categoryCode";
        static final String COLUMN_IS_SUCCESS = "isSuccess";
        static final String COLUMN_ORIGIN_INFOS = "originInfos";
        static final String INSERT_TRANSACTION = "INSERT OR REPLACE INTO TRANSACTIONS(identifier,cardId,smsId,fullSms,sender,smsDate,smsType,regId,spentMoney,spentDate,finishDate,keyword,installmentCount,dwType,currency,isOffset,isDuplicate,memo,spentLatitude,spentLongitude,categoryCode,isSuccess,originInfos)VALUES";
        static final String indexing = "CREATE INDEX qlip_transaction_idx ON  TRANSACTIONS (identifier)";
        static final String indexing_2 = "CREATE INDEX qlip_transaction_idx2 ON  TRANSACTIONS (spentDate,dwType,isOffset,keyword)";
        static final String indexing_3 = "CREATE INDEX qlip_transaction_idx3 ON  TRANSACTIONS (spentDate,dwType,spentMoney,categoryCode)";
        static final String SQL_CREATE_ENTRIES = " CREATE TABLE  TRANSACTIONS (identifier TEXT  NOT NULL  UNIQUE  , cardId INTEGER  NOT NULL  DEFAULT  0  , smsId INTEGER  NOT NULL  DEFAULT  0  , fullSms TEXT  NOT NULL  DEFAULT  'none'  , sender TEXT  NOT NULL  DEFAULT  'none'  , smsType INTEGER  NOT NULL  DEFAULT  0  , smsDate DATETIME  NOT NULL  DEFAULT  0  , regId INTEGER  NOT NULL  DEFAULT  0  , spentMoney REAL  NOT NULL  DEFAULT  0  , spentDate DATETIME  NOT NULL  DEFAULT  0  , finishDate DATETIME  NOT NULL  DEFAULT  0  , keyword TEXT  NOT NULL  DEFAULT  'none'  , installmentCount INTEGER  NOT NULL  DEFAULT 1 , dwType INTEGER  NOT NULL  DEFAULT  0  , currency TEXT  , isOffset INTEGER  NOT NULL  DEFAULT  0  , isDuplicate INTEGER  NOT NULL  DEFAULT  0  , memo TEXT  , spentLatitude REAL  NOT NULL  DEFAULT  0  , spentLongitude REAL  NOT NULL  DEFAULT  0  , categoryCode INTEGER  NOT NULL  DEFAULT 101010 , isSuccess INTEGER  NOT NULL  DEFAULT 1 , originInfos TEXT  NOT NULL  DEFAULT  'none' )";
        static final String SQL_DELETE_ENTRIES = " DROP TABLE IF EXISTS  TRANSACTIONS";

        TransactionsTable() {
        }

        static TransactionTableData populateModel(Cursor c) {
            TransactionTableData model = new TransactionTableData();
            model.identifier = c.getString(c.getColumnIndex(COLUMN_IDENTIFIER));
            model.cardTableData = new CardTableData();
            model.cardTableData.cardId = c.getInt(c.getColumnIndex(COLUMN_CARD_ID));
            model.smsId = c.getInt(c.getColumnIndex(COLUMN_SMS_ID));
            model.fullSms = c.getString(c.getColumnIndex(COLUMN_FULL_SMS));
            model.sender = c.getString(c.getColumnIndex(COLUMN_SENDER));
            model.smsDate = c.getString(c.getColumnIndex(COLUMN_SMS_DATE));
            model.smsType = c.getInt(c.getColumnIndex(COLUMN_SMS_TYPE));
            model.regId = c.getInt(c.getColumnIndex(COLUMN_REG_ID));
            model.spentMoney = c.getDouble(c.getColumnIndex(COLUMN_SPENT_MONEY));
            model.spentDate = c.getString(c.getColumnIndex(COLUMN_SPENT_DATE));
            model.finishDate = c.getString(c.getColumnIndex(COLUMN_FINISH_DATE));
            model.keyword = c.getString(c.getColumnIndex(COLUMN_KEYWORD));
            model.installmentCount = c.getInt(c.getColumnIndex(COLUMN_INSTALLMENT_COUNT));
            model.dwType = c.getInt(c.getColumnIndex(COLUMN_DW_TYPE));
            model.currency = c.getString(c.getColumnIndex(COLUMN_CURRENCY));
            model.isOffset = c.getInt(c.getColumnIndex(COLUMN_IS_OFFSET));
            model.isDuplicate = c.getInt(c.getColumnIndex(COLUMN_IS_DUPLICATE));
            model.memo = c.getString(c.getColumnIndex(COLUMN_MEMO));
            model.spentLatitude = c.getDouble(c.getColumnIndex(COLUMN_SPENT_LATITUDE));
            model.spentLongitude = c.getDouble(c.getColumnIndex(COLUMN_SPENT_LONGITUDE));
            model.categoryCode = c.getInt(c.getColumnIndex(COLUMN_CATEGORY_CODE));
            model.isSuccess = c.getInt(c.getColumnIndex(COLUMN_IS_SUCCESS));
            model.originInfos = c.getString(c.getColumnIndex(COLUMN_ORIGIN_INFOS));
            return model;
        }

        static ContentValues populateContent(TransactionTableData model) {
            ContentValues values = new ContentValues();
            values.put(COLUMN_IDENTIFIER, model.identifier);
            values.put(COLUMN_CARD_ID, Integer.valueOf(model.cardTableData.cardId));
            values.put(COLUMN_SMS_ID, Integer.valueOf(model.smsId));
            values.put(COLUMN_FULL_SMS, model.fullSms == null ? "none" : model.fullSms);
            values.put(COLUMN_SENDER, model.sender == null ? "none" : model.sender);
            values.put(COLUMN_SMS_DATE, model.smsDate == null ? DateUtil.getStringDateAsYYYYMMddHHmmss(Calendar.getInstance()) : model.smsDate);
            values.put(COLUMN_SMS_TYPE, Integer.valueOf(model.smsType));
            values.put(COLUMN_REG_ID, Integer.valueOf(model.regId));
            values.put(COLUMN_SPENT_MONEY, Double.valueOf(model.spentMoney));
            values.put(COLUMN_SPENT_DATE, model.spentDate == null ? DateUtil.getStringDateAsYYYYMMddHHmmss(Calendar.getInstance()) : model.spentDate);
            values.put(COLUMN_FINISH_DATE, model.finishDate == null ? DateUtil.getStringDateAsYYYYMMddHHmmss(Calendar.getInstance()) : model.finishDate);
            values.put(COLUMN_KEYWORD, model.keyword == null ? "\ub0b4\uc6a9\uc5c6\uc74c" : model.keyword);
            values.put(COLUMN_INSTALLMENT_COUNT, Integer.valueOf(model.installmentCount));
            values.put(COLUMN_DW_TYPE, Integer.valueOf(model.dwType));
            values.put(COLUMN_CURRENCY, model.currency);
            values.put(COLUMN_IS_OFFSET, Integer.valueOf(model.isOffset));
            values.put(COLUMN_IS_DUPLICATE, Integer.valueOf(model.isDuplicate));
            values.put(COLUMN_MEMO, model.memo == null ? "none" : model.memo);
            values.put(COLUMN_SPENT_LATITUDE, Double.valueOf(model.spentLatitude));
            values.put(COLUMN_SPENT_LONGITUDE, Double.valueOf(model.spentLongitude));
            values.put(COLUMN_CATEGORY_CODE, Integer.valueOf(model.categoryCode));
            values.put(COLUMN_IS_SUCCESS, Integer.valueOf(1));
            values.put(COLUMN_ORIGIN_INFOS, model.originInfos == null ? "none" : model.originInfos);
            return values;
        }
    }

    static class CardTable
    implements BaseColumns {
        static final String TABLE_NAME = " CARDS";
        static final String AS_ALIAS = " AS card ";
        static final String ALIAS = " card.";
        static final String COLUMN_CARD_NAME = "cardName";
        static final String COLUMN_CARD_NUM = "cardNum";
        static final String COLUMN_CARD_TYPE = "cardType";
        static final String COLUMN_CARD_SUB_TYPE = "cardSubType";
        static final String COLUMN_CARD_BALANCE = "balance";
        static final String SQL_CREATE_ENTRIES = " CREATE TABLE  CARDS (_id INTEGER  PRIMARY KEY  AUTOINCREMENT  , cardName TEXT  NOT NULL  DEFAULT  'none'  , cardNum TEXT  , cardType INTEGER  NOT NULL  DEFAULT  0  , cardSubType INTEGER  NOT NULL  DEFAULT  0  , balance REAL  NOT NULL  DEFAULT  0  )";
        static final String indexing = "CREATE INDEX qlip_card_idx ON  CARDS (cardName,cardNum,cardType,cardSubType)";
        static final String INSERT_CARD = "INSERT OR REPLACE INTO CARDS(cardName,cardNum,cardType,cardSubType,balance)VALUES";
        static final String SQL_DELETE_ENTRIES = " DROP TABLE IF EXISTS  CARDS";

        CardTable() {
        }

        static CardTableData populateModel(Cursor c) {
            CardTableData cardTableData = new CardTableData();
            cardTableData.cardId = c.getInt(c.getColumnIndex("_id"));
            cardTableData.cardName = c.getString(c.getColumnIndex(COLUMN_CARD_NAME));
            cardTableData.cardNum = c.getString(c.getColumnIndex(COLUMN_CARD_NUM));
            cardTableData.cardType = c.getInt(c.getColumnIndex(COLUMN_CARD_TYPE));
            cardTableData.cardSubType = c.getInt(c.getColumnIndex(COLUMN_CARD_SUB_TYPE));
            cardTableData.balance = c.getDouble(c.getColumnIndex(COLUMN_CARD_BALANCE));
            return cardTableData;
        }

        static ContentValues populateContent(CardTableData model) {
            ContentValues values = new ContentValues();
            values.put(COLUMN_CARD_NAME, model.cardName == null ? "none" : model.cardName);
            values.put(COLUMN_CARD_NUM, model.cardNum == null ? "none" : model.cardNum);
            values.put(COLUMN_CARD_TYPE, Integer.valueOf(model.cardType));
            values.put(COLUMN_CARD_SUB_TYPE, Integer.valueOf(model.cardSubType));
            values.put(COLUMN_CARD_BALANCE, Double.valueOf(model.balance));
            return values;
        }
    }

    static class SendersTable
    implements BaseColumns {
        static final String TABLE_NAME = " SENDERS";
        static final String COLUMN_SENDER_ID = "senderId";
        static final String COLUMN_SMS_TYPE = "smsType";
        static final String COLUMN_SENDER = "sender";
        static final String COLUMN_REP_SENDER = "repSender";
        static final String SQL_CREATE_ENTRIES = " CREATE TABLE  SENDERS (senderId INTEGER  PRIMARY KEY  , smsType INTEGER  NOT NULL  DEFAULT  0  , sender TEXT  NOT NULL  UNIQUE  , repSender TEXT  NOT NULL  DEFAULT  'none'  )";
        static final String indexing = "CREATE INDEX qlip_senders_idx ON  SENDERS (sender)";
        static final String SQL_DELETE_ENTRIES = " DROP TABLE IF EXISTS  SENDERS";
        static final String INSERT_SENDER = "INSERT OR REPLACE INTO SENDERS(senderId,smsType,sender,repSender)VALUES";

        SendersTable() {
        }

        static Sender populateModel(Cursor c) {
            Sender sender = new Sender();
            sender.senderId = c.getInt(c.getColumnIndex(COLUMN_SENDER_ID));
            sender.smsType = c.getInt(c.getColumnIndex(COLUMN_SMS_TYPE));
            sender.sender = c.getString(c.getColumnIndex(COLUMN_SENDER));
            sender.repSender = c.getString(c.getColumnIndex(COLUMN_REP_SENDER));
            return sender;
        }

        static ContentValues populateContent(Sender model) {
            ContentValues values = new ContentValues();
            values.put(COLUMN_SENDER_ID, Integer.valueOf(model.senderId));
            values.put(COLUMN_SMS_TYPE, Integer.valueOf(model.smsType));
            values.put(COLUMN_SENDER, TextUtils.isEmpty((CharSequence)model.sender) ? "" : model.sender);
            values.put(COLUMN_REP_SENDER, TextUtils.isEmpty((CharSequence)model.repSender) ? "" : model.repSender);
            return values;
        }
    }

    static class BanksTable
    implements BaseColumns {
        static final String TABLE_NAME = " BANKS";
        static final String COLUMN_BANK_ID = "bankId";
        static final String COLUMN_NAME = "sender";
        static final String SQL_CREATE_ENTRIES = " CREATE TABLE  BANKS (bankId INTEGER  PRIMARY KEY  , sender TEXT  NOT NULL  UNIQUE  )";
        static final String indexing = "CREATE INDEX qlip_banks_idx ON  BANKS (sender)";
        static final String SQL_DELETE_ENTRIES = " DROP TABLE IF EXISTS  BANKS";
        static final String INSERT_BANK = "INSERT OR REPLACE INTO BANKS(bankId,sender)VALUES";

        BanksTable() {
        }

        static Bank populateModel(Cursor c) {
            Bank bank = new Bank();
            bank.id = c.getInt(c.getColumnIndex(COLUMN_BANK_ID));
            bank.name = c.getString(c.getColumnIndex(COLUMN_NAME));
            return bank;
        }

        static ContentValues populateContent(Bank model) {
            ContentValues values = new ContentValues();
            values.put(COLUMN_BANK_ID, Integer.valueOf(model.id));
            values.put(COLUMN_NAME, model.name);
            return values;
        }
    }

    static class RegExpressionTable
    implements BaseColumns {
        static final String TABLE_NAME = " REG_EXPRESSION";
        static final String COLUMN_REG_ID = "regId";
        static final String COLUMN_SENDER = "sender";
        static final String COLUMN_REG_EXPRESSION = "regExpression";
        static final String COLUMN_CARD_NAME = "cardName";
        static final String COLUMN_CARD_TYPE = "cardType";
        static final String COLUMN_CARD_SUB_TYPE = "cardSubType";
        static final String COLUMN_CARD_NUM = "cardNum";
        static final String COLUMN_SPENT_MONEY = "spentMoney";
        static final String COLUMN_SPENT_DATE = "spentDate";
        static final String COLUMN_KEYWORD = "keyword";
        static final String COLUMN_INSTALLMENT_COUNT = "installmentCount";
        static final String COLUMN_DW_TYPE = "dwType";
        static final String COLUMN_IS_CANCEL = "isCancel";
        static final String COLUMN_CURRENCY = "currency";
        static final String COLUMN_BALANCE = "balance";
        static final String COLUMN_USER_NAME = "userName";
        static final String COLUMN_PRIORITY = "priority";
        static final String COLUMN_USER_PRIORITY = "user_priority";
        static final String COLUMN_SMS_TYPE = "smsType";
        static final String indexing = "CREATE INDEX qlip_reg_idx ON  REG_EXPRESSION (smsType , sender , priority , user_priority)";
        static final String INSERT_REG = "INSERT OR REPLACE INTO REG_EXPRESSION(regId,sender,regExpression,cardName,cardType,cardSubType,cardNum,spentMoney,spentDate,keyword,installmentCount,dwType,isCancel,currency,balance,userName,smsType,priority)VALUES";
        static final String SQL_CREATE_ENTRIES = " CREATE TABLE  REG_EXPRESSION (regId INTEGER  PRIMARY KEY  , sender TEXT  NOT NULL  DEFAULT  'none'  , regExpression TEXT  NOT NULL  DEFAULT  'none'  , cardName TEXT  NOT NULL  DEFAULT  'none'  , cardType TEXT  NOT NULL  DEFAULT  'none'  , cardSubType TEXT  NOT NULL  DEFAULT  'none'  , cardNum TEXT  , spentMoney TEXT  NOT NULL  DEFAULT  'none'  , spentDate TEXT  , keyword TEXT  NOT NULL  DEFAULT  'none'  , installmentCount TEXT  , dwType TEXT  NOT NULL  DEFAULT  'none'  , isCancel TEXT  NOT NULL  DEFAULT  'none'  , currency TEXT  , balance TEXT  NOT NULL  DEFAULT  'none'  , userName TEXT  , priority INTEGER  NOT NULL  DEFAULT  0  , user_priority INTEGER  NOT NULL  DEFAULT  0  , smsType INTEGER  NOT NULL  DEFAULT  0  )";
        static final String SQL_DELETE_ENTRIES = " DROP TABLE IF EXISTS  REG_EXPRESSION";

        RegExpressionTable() {
        }

        static RegData populateModel(Cursor c, Context context) {
            RegData model = new RegData();
            model.regId = c.getInt(c.getColumnIndex(COLUMN_REG_ID));
            model.sender = c.getString(c.getColumnIndex(COLUMN_SENDER));
            model.regExpression = AES128Cipher.getInstance(context).decrypt(c.getString(c.getColumnIndex(COLUMN_REG_EXPRESSION)));
            model.cardName = c.getString(c.getColumnIndex(COLUMN_CARD_NAME));
            model.cardType = c.getString(c.getColumnIndex(COLUMN_CARD_TYPE));
            model.cardSubType = c.getString(c.getColumnIndex(COLUMN_CARD_SUB_TYPE));
            model.cardNum = c.getString(c.getColumnIndex(COLUMN_CARD_NUM));
            model.spentMoney = c.getString(c.getColumnIndex(COLUMN_SPENT_MONEY));
            model.spentDate = c.getString(c.getColumnIndex(COLUMN_SPENT_DATE));
            model.keyword = c.getString(c.getColumnIndex(COLUMN_KEYWORD));
            model.installmentCount = c.getString(c.getColumnIndex(COLUMN_INSTALLMENT_COUNT));
            model.dwType = c.getString(c.getColumnIndex(COLUMN_DW_TYPE));
            model.isCancel = c.getString(c.getColumnIndex(COLUMN_IS_CANCEL));
            model.currency = c.getString(c.getColumnIndex(COLUMN_CURRENCY));
            model.balance = c.getString(c.getColumnIndex(COLUMN_BALANCE));
            model.userName = c.getString(c.getColumnIndex(COLUMN_USER_NAME));
            model.priority = c.getInt(c.getColumnIndex(COLUMN_PRIORITY));
            model.userPriority = c.getInt(c.getColumnIndex(COLUMN_USER_PRIORITY));
            model.smsType = c.getInt(c.getColumnIndex(COLUMN_SMS_TYPE));
            return model;
        }

        static ContentValues populateContent(RegData model) {
            ContentValues values = new ContentValues();
            values.put(COLUMN_REG_ID, Integer.valueOf(model.regId));
            values.put(COLUMN_SENDER, TextUtils.isEmpty((CharSequence)model.sender) ? "" : model.sender);
            values.put(COLUMN_REG_EXPRESSION, TextUtils.isEmpty((CharSequence)model.regExpression) ? "" : model.regExpression);
            values.put(COLUMN_CARD_NAME, TextUtils.isEmpty((CharSequence)model.cardName) ? "" : model.cardName);
            values.put(COLUMN_CARD_TYPE, TextUtils.isEmpty((CharSequence)model.cardType) ? "" : model.cardType);
            values.put(COLUMN_CARD_SUB_TYPE, TextUtils.isEmpty((CharSequence)model.cardSubType) ? "" : model.cardSubType);
            values.put(COLUMN_CARD_NUM, TextUtils.isEmpty((CharSequence)model.cardNum) ? "" : model.cardNum);
            values.put(COLUMN_SPENT_MONEY, TextUtils.isEmpty((CharSequence)model.spentMoney) ? "" : model.spentMoney);
            values.put(COLUMN_SPENT_DATE, TextUtils.isEmpty((CharSequence)model.spentDate) ? "" : model.spentDate);
            values.put(COLUMN_KEYWORD, TextUtils.isEmpty((CharSequence)model.cardName) ? "\ub0b4\uc6a9\uc5c6\uc74c" : model.keyword);
            values.put(COLUMN_INSTALLMENT_COUNT, TextUtils.isEmpty((CharSequence)model.installmentCount) ? "" : model.installmentCount);
            values.put(COLUMN_DW_TYPE, TextUtils.isEmpty((CharSequence)model.dwType) ? "" : model.dwType);
            values.put(COLUMN_IS_CANCEL, TextUtils.isEmpty((CharSequence)model.isCancel) ? "" : model.isCancel);
            values.put(COLUMN_CURRENCY, TextUtils.isEmpty((CharSequence)model.currency) ? "" : model.currency);
            values.put(COLUMN_BALANCE, TextUtils.isEmpty((CharSequence)model.balance) ? "" : model.balance);
            values.put(COLUMN_USER_NAME, TextUtils.isEmpty((CharSequence)model.userName) ? "" : model.userName);
            values.put(COLUMN_PRIORITY, Integer.valueOf(model.priority));
            values.put(COLUMN_SMS_TYPE, Integer.valueOf(model.smsType));
            return values;
        }
    }
}

