/*
 * Decompiled with CFR 0.152.
 */
package tenqube.parser.core;

import android.text.TextUtils;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

class DateUtil {
    static final DecimalFormat decimalFormat = new DecimalFormat("00");

    DateUtil() {
    }

    static String getStringDateAsYYYYMMddHHmm(Calendar cal) {
        if (cal == null) {
            cal = Calendar.getInstance();
        }
        return cal.get(1) + "-" + decimalFormat.format(cal.get(2) + 1) + "-" + decimalFormat.format(cal.get(5)) + " " + decimalFormat.format(cal.get(11)) + ":" + decimalFormat.format(cal.get(12));
    }

    static String getStringDateAsYYYYMMddHHmmss(Calendar cal) {
        if (cal == null) {
            cal = Calendar.getInstance();
        }
        return cal.get(1) + "-" + decimalFormat.format(cal.get(2) + 1) + "-" + decimalFormat.format(cal.get(5)) + " " + decimalFormat.format(cal.get(11)) + ":" + decimalFormat.format(cal.get(12)) + ":" + decimalFormat.format(cal.get(13));
    }

    static Calendar convertStringToCalendarFULL(String date) {
        Calendar cal = Calendar.getInstance();
        if (date == null || TextUtils.isEmpty((CharSequence)date)) {
            return cal;
        }
        try {
            SimpleDateFormat fullDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.KOREA);
            Date d = fullDF.parse(date);
            cal.setTime(d);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return cal;
    }

    static String getFinishDate(String spentDate, int installmentCount) {
        if (installmentCount == 1) {
            return spentDate;
        }
        Calendar cal = DateUtil.convertStringToCalendarFULL(spentDate);
        int position = installmentCount - 1;
        int starDay = cal.get(5);
        cal.add(2, position);
        int currentYear = cal.get(1);
        int currentMonth = cal.get(2);
        int actualDay = cal.getActualMaximum(5);
        int hour = cal.get(11);
        int minute = cal.get(12);
        int second = cal.get(13);
        String finishDate = actualDay > starDay ? currentYear + "-" + decimalFormat.format(currentMonth + 1) + "-" + decimalFormat.format(starDay) : currentYear + "-" + decimalFormat.format(currentMonth + 1) + "-" + decimalFormat.format(actualDay);
        finishDate = finishDate + " " + decimalFormat.format(hour) + ":" + decimalFormat.format(minute) + ":" + decimalFormat.format(second);
        SimpleDateFormat fullDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.KOREA);
        try {
            Date d = fullDF.parse(finishDate);
            finishDate = fullDF.format(d);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return finishDate;
    }

    static int getDiffDateAsCalendar(Calendar before, Calendar after) {
        Calendar newBefore = Calendar.getInstance();
        newBefore.set(before.get(1), before.get(2), before.get(5));
        Calendar newAfter = Calendar.getInstance();
        newAfter.set(after.get(1), after.get(2), after.get(5));
        long start = newBefore.getTimeInMillis();
        long end = newAfter.getTimeInMillis();
        Long diff = (end - start) / 86400000L;
        return diff.intValue() + 1;
    }
}

