/*
 * Decompiled with CFR 0.152.
 */
package tenqube.parser.core;

import android.content.Context;
import android.database.SQLException;
import android.os.AsyncTask;
import java.util.ArrayList;
import java.util.LinkedList;
import tenqube.parser.BulkSmsAdapter;
import tenqube.parser.OnNetworkResultListener;
import tenqube.parser.Parser;
import tenqube.parser.core.ParserPresenter;
import tenqube.parser.core.PrefUtils;
import tenqube.parser.core.SecretKeyManager;
import tenqube.parser.core.Utils;
import tenqube.parser.model.ParserResult;
import tenqube.parser.model.ParsingRule;
import tenqube.parser.model.SMS;
import tenqube.parser.model.Transaction;
import tenqube.parser.util.LogUtil;

public class ParserService
implements Parser {
    public static final String TAG = LogUtil.makeLogTag(ParserService.class);
    private Context mContext;
    private boolean mIsBulk = false;
    public static boolean mIsDebug = false;
    private int mTranCnt;
    private ParserPresenter mParserPresenter;
    private static ParserService mInstance;
    private ParserBulkTask mParseBulkTask = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ParserService getInstance(Context context) {
        Class<ParserService> clazz = ParserService.class;
        synchronized (ParserService.class) {
            if (mInstance == null) {
                mInstance = new ParserService(context);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return mInstance;
        }
    }

    private ParserService(Context context) throws SQLException {
        this.mContext = context;
        this.mParserPresenter = new ParserPresenter(context);
        this.mIsBulk = false;
        this.mTranCnt = PrefUtils.getInstance(this.mContext).loadIntValue("TRAN_COUNT", 50);
    }

    @Override
    public int getRuleVersion() {
        return PrefUtils.getInstance(this.mContext).loadIntValue("ruleVersion", 0);
    }

    @Override
    public void syncParsingRule(ParsingRule parsingRule) throws SQLException {
        if (parsingRule != null) {
            SecretKeyManager.getInstance(this.mContext).saveKey(parsingRule.securityKey);
            PrefUtils.getInstance(this.mContext).saveIntValue("ruleVersion", parsingRule.ruleVersion);
            PrefUtils.getInstance(this.mContext).saveIntValue("TRAN_COUNT", parsingRule.tranCount);
            this.mTranCnt = parsingRule.tranCount;
            this.mParserPresenter.syncParsingRule(parsingRule, this.mTranCnt);
        }
    }

    @Override
    public ParserResult parse(SMS sms) throws SQLException {
        if (PrefUtils.getInstance(this.mContext).loadIntValue("ruleVersion", 0) == 0) {
            return new ParserResult(-4, null);
        }
        if (sms != null && sms.isValid()) {
            if (!this.mIsBulk) {
                this.mParserPresenter.deleteOldTransaction(sms.getSmsDate());
            }
            return this.mParserPresenter.parse(sms);
        }
        return new ParserResult(-1, null);
    }

    @Override
    public void onNetworkResult(ArrayList<Transaction> transactions, boolean isSuccess) {
        this.mParserPresenter.updateIsSuccess(transactions, isSuccess ? 1 : 0);
    }

    @Override
    public void destroy() {
        if (mInstance != null && this.mParseBulkTask != null) {
            this.mParseBulkTask.cancel(true);
            this.mParseBulkTask = null;
        }
        mInstance = null;
    }

    @Override
    public void setDebugMode(boolean isDebug) {
        mIsDebug = isDebug;
    }

    @Override
    public void initDb() throws SQLException {
        this.mParserPresenter.initDb();
    }

    @Override
    public void addTestOriginNumber(String number) throws SQLException {
        this.mParserPresenter.addTestOriginNumber(number);
    }

    @Override
    public void cancelParseBulk() {
        if (this.mParseBulkTask != null) {
            this.mParseBulkTask.cancelTask();
            this.mParseBulkTask = null;
        }
    }

    @Override
    public void parseBulk(BulkSmsAdapter bulkSmsAdapter) throws SQLException {
        LogUtil.LOGI(TAG, "Start FUNC : parseBulk", mIsDebug);
        if (bulkSmsAdapter != null && !this.mIsBulk) {
            this.mIsBulk = true;
            if (PrefUtils.getInstance(this.mContext).loadIntValue("ruleVersion", 0) == 0) {
                bulkSmsAdapter.onError(-4);
                this.mIsBulk = false;
            } else {
                this.cancelParseBulk();
                this.mParseBulkTask = new ParserBulkTask(this, bulkSmsAdapter);
                this.mParseBulkTask.execute(new Void[0]);
            }
        }
        LogUtil.LOGI(TAG, "End FUNC : parseBulk", mIsDebug);
    }

    private static class SendToServerThread
    extends Thread {
        private boolean mIsError;
        private boolean mIsCompleted;
        private boolean mIsCanceled;
        private boolean mIsLastTransactionPushed = false;
        private BulkSmsAdapter mAdapter;
        private LinkedList<ArrayList<Transaction>> mTransactionPool = new LinkedList();
        private ArrayList<ArrayList<Transaction>> mSendingTransactionPool = new ArrayList();
        private Object mWaitObject;
        private ParserPresenter mParserPresenter;

        SendToServerThread(BulkSmsAdapter adapter, ParserPresenter parserPresenter) {
            this.mAdapter = adapter;
            this.mWaitObject = new Object();
            this.mIsError = false;
            this.mIsCompleted = false;
            this.mIsCanceled = false;
            this.mParserPresenter = parserPresenter;
        }

        void cancelThread() {
            this.mIsCanceled = true;
            this.mTransactionPool.clear();
            this.mSendingTransactionPool.clear();
            this.wakeupThread();
            LogUtil.LOGI(TAG, "Thread Canceled.. ", mIsDebug);
        }

        void setLastTransactionPushed() {
            this.mIsLastTransactionPushed = true;
            this.wakeupThread();
        }

        void pushTransactions(ArrayList<Transaction> transactions) {
            if (transactions != null && !this.mIsError && !this.mIsCanceled) {
                this.mTransactionPool.push(transactions);
            }
            this.wakeupThread();
        }

        @Override
        public void run() {
            LogUtil.LOGI(TAG, "Start Sender Thread ", mIsDebug);
            while (!this.isFinishedLoop()) {
                if (this.mTransactionPool != null && !this.mTransactionPool.isEmpty()) {
                    final ArrayList<Transaction> transactions = Utils.distinctTransactions(this.mTransactionPool.pop());
                    this.mSendingTransactionPool.add(transactions);
                    LogUtil.LOGI(TAG, "Start Network ... ", mIsDebug);
                    this.mAdapter.sendToServerTransactions(transactions, new OnNetworkResultListener(){

                        @Override
                        public void onResult(boolean bSuccess) {
                            try {
                                if (SendToServerThread.this.mSendingTransactionPool != null) {
                                    SendToServerThread.this.mSendingTransactionPool.remove(transactions);
                                    if (!bSuccess && !SendToServerThread.this.mIsError) {
                                        SendToServerThread.this.mIsError = true;
                                    }
                                    if (bSuccess) {
                                        SendToServerThread.this.mParserPresenter.insertTransactionAndMaxSmsId(transactions);
                                    }
                                    if (SendToServerThread.this.mIsLastTransactionPushed && SendToServerThread.this.mTransactionPool.isEmpty() && SendToServerThread.this.mSendingTransactionPool.isEmpty()) {
                                        SendToServerThread.this.mIsCompleted = true;
                                    }
                                    LogUtil.LOGI(TAG, "End Network ... ", mIsDebug);
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            SendToServerThread.this.wakeupThread();
                        }
                    });
                } else if (this.mIsLastTransactionPushed && this.mSendingTransactionPool.isEmpty()) {
                    this.mIsCompleted = true;
                }
                if (!this.shouldWaitThread()) continue;
                this.waitThread();
            }
            LogUtil.LOGI(TAG, "End Sender Thread", mIsDebug);
        }

        void releaseAll() {
            this.mAdapter = null;
            if (this.mTransactionPool != null) {
                this.mTransactionPool.clear();
                this.mTransactionPool = null;
            }
            if (this.mSendingTransactionPool != null) {
                this.mSendingTransactionPool.clear();
                this.mSendingTransactionPool = null;
            }
            this.mWaitObject = null;
        }

        private synchronized boolean isFinishedLoop() {
            return this.mIsCompleted || this.mIsCanceled || this.mIsError;
        }

        private synchronized boolean shouldWaitThread() {
            return !this.isFinishedLoop() && this.mTransactionPool.isEmpty();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void wakeupThread() {
            block5: {
                try {
                    if (this.mWaitObject == null) break block5;
                    Object object = this.mWaitObject;
                    synchronized (object) {
                        this.mWaitObject.notifyAll();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void waitThread() {
            block5: {
                try {
                    if (this.mWaitObject == null) break block5;
                    Object object = this.mWaitObject;
                    synchronized (object) {
                        this.mWaitObject.wait();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static class ParserBulkTask
    extends AsyncTask<Void, Void, Void> {
        private ParserService mParser;
        private BulkSmsAdapter mAdapter;
        private SendToServerThread mSendToServerThread;
        private boolean mIsCanceled;

        ParserBulkTask(ParserService parserService, BulkSmsAdapter smsAdapter) {
            this.mParser = parserService;
            this.mAdapter = smsAdapter;
            this.mIsCanceled = false;
        }

        protected void onPreExecute() {
            super.onPreExecute();
            this.mParser.mParserPresenter.initTransactions();
            this.mParser.mParserPresenter.initMap();
            this.mParser.mParserPresenter.setSendersWithBulk();
        }

        void cancelTask() {
            if (this.mSendToServerThread != null) {
                this.mSendToServerThread.cancelThread();
            }
            this.mIsCanceled = true;
        }

        protected Void doInBackground(Void ... params) {
            LogUtil.LOGI(TAG, "doInBackground", mIsDebug);
            this.mSendToServerThread = new SendToServerThread(this.mAdapter, this.mParser.mParserPresenter);
            this.mSendToServerThread.start();
            int totalCnt = this.mAdapter.getSmsCount();
            ArrayList<Transaction> transactionBuffer = null;
            for (int i = 0; i < totalCnt && !this.mIsCanceled; ++i) {
                ArrayList<Transaction> transactions;
                SMS sms = this.mAdapter.getSmsAt(i);
                if (sms != null && sms.isValid() && (transactions = this.mParser.mParserPresenter.parseWithBulk(sms)) != null && !transactions.isEmpty()) {
                    if (transactionBuffer == null) {
                        transactionBuffer = new ArrayList<Transaction>();
                    }
                    transactionBuffer.addAll(transactions);
                }
                if (transactionBuffer != null && transactionBuffer.size() >= this.mParser.mTranCnt) {
                    this.mSendToServerThread.pushTransactions(transactionBuffer);
                    transactionBuffer = null;
                }
                this.mAdapter.onProgress(i, totalCnt);
            }
            if (!this.mIsCanceled && transactionBuffer != null && !transactionBuffer.isEmpty()) {
                this.mSendToServerThread.pushTransactions(transactionBuffer);
            }
            this.mSendToServerThread.setLastTransactionPushed();
            try {
                this.mSendToServerThread.join();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }

        protected void onPostExecute(Void aVoid) {
            try {
                LogUtil.LOGI(TAG, "onPostExecute", mIsDebug);
                if (this.mSendToServerThread != null) {
                    if (this.mAdapter != null) {
                        if (!this.mSendToServerThread.mIsCanceled) {
                            if (this.mSendToServerThread.mIsError) {
                                this.mAdapter.onError(-2);
                            } else {
                                this.mAdapter.onCompleted();
                            }
                        } else {
                            this.mAdapter.onError(-3);
                        }
                    }
                    this.mSendToServerThread.releaseAll();
                    this.mSendToServerThread = null;
                }
                if (this.mParser != null) {
                    this.mParser.mIsBulk = false;
                    if (this.mParser.mParserPresenter != null) {
                        this.mParser.mParserPresenter.onBulkComplete();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.mAdapter = null;
            this.mParser = null;
            super.onPostExecute((Object)aVoid);
        }
    }
}

