/*
 * Decompiled with CFR 0.152.
 */
package tenqube.parser.core;

import android.content.Context;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import java.util.Calendar;
import java.util.Date;
import tenqube.parser.constants.Constants;
import tenqube.parser.core.DateUtil;
import tenqube.parser.core.Utils;
import tenqube.parser.model.NotiRequest;
import tenqube.parser.model.SMS;

public class Mapper {
    public static SMS toSMS(@Nullable Context context, NotiRequest notiRequest) {
        SMS sms = Mapper.makeTestSMS(notiRequest);
        if (sms != null) {
            return sms;
        }
        boolean isDefault = context != null && Utils.isDefaultSMS(context, notiRequest.getPkgName());
        String title = Utils.filterTitle(notiRequest.getTitle());
        SMS newSMS = new SMS(0, Mapper.getFullSms(notiRequest.getPkgName(), notiRequest.getBigText(), notiRequest.getText(), isDefault), Mapper.getSender(isDefault, notiRequest.getPkgName(), title), "", Mapper.getSmsDate(notiRequest.getWhen()), Mapper.getSMStype(isDefault), title);
        newSMS.setShouldIgnoreDate(isDefault);
        return newSMS;
    }

    private static SMS makeTestSMS(NotiRequest notiRequest) {
        if ("com.google.android.talk".equals(notiRequest.getPkgName()) && notiRequest.getText().contains("`")) {
            String[] notis = notiRequest.getText().substring(1).split(";");
            String title = "";
            String text = "";
            String sender = "";
            int smsType = Constants.SMSType.NOTIFICATION.ordinal();
            if (notis.length > 0) {
                int i = 0;
                for (String noti : notis) {
                    if (i == 0) {
                        sender = noti;
                    } else if (i == 1) {
                        title = noti;
                    } else if (i == 2) {
                        text = noti;
                    } else if (i == 3) {
                        smsType = Integer.parseInt(noti);
                    }
                    ++i;
                }
                return new SMS(0, text, sender, "", Mapper.getSmsDate(Calendar.getInstance().getTimeInMillis()), smsType, title);
            }
        }
        return null;
    }

    private static String getFullSms(String pkg, String bigText, String text, boolean isDefaultSMS) {
        if (isDefaultSMS) {
            String tempText;
            String[] texts;
            if (bigText == null) {
                bigText = "";
            }
            if (text == null) {
                text = "";
            }
            if ((texts = (tempText = text.length() > bigText.length() ? text : bigText).split("\\[[a-zA-Z]{3}\ubc1c\uc2e0\\]")).length > 1) {
                return texts[texts.length - 1].trim();
            }
        }
        if ("com.hyundaicard.appcard".equals(pkg) && !TextUtils.isEmpty((CharSequence)bigText)) {
            return bigText;
        }
        return text;
    }

    private static String getSender(boolean isDefault, String pkgName, String title) {
        if (isDefault) {
            return title;
        }
        return pkgName;
    }

    private static String getSmsDate(long when) {
        return DateUtil.fullDF.format(new Date(when));
    }

    private static int getSMStype(boolean isDefault) {
        if (isDefault) {
            return Constants.SMSType.SMS.ordinal();
        }
        return Constants.SMSType.NOTIFICATION.ordinal();
    }
}

