/*
 * Decompiled with CFR 0.152.
 */
package tenqube.parser.model;

import java.io.Serializable;
import tenqube.parser.util.Validator;

public class SMS
implements Serializable {
    private final int smsId;
    private final String fullSms;
    private final String displaySender;
    private final String sender;
    private final String smsDate;
    private final int smsType;
    private final String title;
    private boolean shouldIgnoreDate;

    public SMS(int smsId, String fullSms, String sender, String displaySender, String smsDate, int smsType) {
        this(smsId, fullSms, sender, displaySender, smsDate, smsType, "");
    }

    public SMS(int smsId, String fullSms, String sender, String displaySender, String smsDate, int smsType, String title) {
        this.smsId = smsId;
        this.fullSms = fullSms;
        this.sender = sender;
        this.displaySender = displaySender;
        this.smsDate = smsDate;
        this.smsType = smsType;
        this.title = title;
    }

    public boolean isValid() {
        return this.fullSms != null && this.fullSms.length() < 500 && this.sender != null && this.smsDate != null && Validator.isDate(this.smsDate);
    }

    public boolean shouldIgnoreDate() {
        return this.shouldIgnoreDate;
    }

    public void setShouldIgnoreDate(boolean shouldIgnoreDate) {
        this.shouldIgnoreDate = shouldIgnoreDate;
    }

    public String toString() {
        return "SMS{smsId=" + this.smsId + ", fullSms='" + this.fullSms + '\'' + ", displaySender='" + this.displaySender + '\'' + ", sender='" + this.sender + '\'' + ", smsDate='" + this.smsDate + '\'' + ", smsType=" + this.smsType + '}';
    }

    public int getSmsId() {
        return this.smsId;
    }

    public String getFullSms() {
        return this.fullSms;
    }

    public String getDisplaySender() {
        return this.displaySender;
    }

    public String getSender() {
        return this.sender;
    }

    public String getSmsDate() {
        return this.smsDate;
    }

    public int getSmsType() {
        return this.smsType;
    }

    public String getTitle() {
        return this.title;
    }
}

