/*
 * Decompiled with CFR 0.152.
 */
package tenqube.parser.core;

import android.content.Context;
import android.text.TextUtils;
import java.util.Calendar;
import java.util.Date;
import tenqube.parser.constants.Constants;
import tenqube.parser.core.DateUtil;
import tenqube.parser.core.Utils;
import tenqube.parser.model.NotiRequest;
import tenqube.parser.model.SMS;

public class Mapper {
    public static SMS toSMS(Context context, NotiRequest notiRequest) {
        SMS sms = Mapper.makeTestSMS(notiRequest);
        if (sms != null) {
            return sms;
        }
        boolean isDefault = Utils.isDefaultSMS(context, notiRequest.getPkgName());
        String title = Utils.filterTitle(notiRequest.getTitle());
        return new SMS(0, Mapper.getFullSms(notiRequest.getBigText(), notiRequest.getText()), Mapper.getSender(isDefault, notiRequest.getPkgName(), title), "", Mapper.getSmsDate(notiRequest.getWhen()), Mapper.getSMStype(isDefault), title);
    }

    private static SMS makeTestSMS(NotiRequest notiRequest) {
        if ("com.google.android.talk".equals(notiRequest.getPkgName()) && notiRequest.getText().contains("`")) {
            String[] notis = notiRequest.getText().substring(1).split(";");
            String title = "";
            String text = "";
            String sender = "";
            int smsType = Constants.SMSType.NOTIFICATION.ordinal();
            if (notis.length > 0) {
                int i = 0;
                for (String noti : notis) {
                    if (i == 0) {
                        sender = noti;
                    } else if (i == 1) {
                        title = noti;
                    } else if (i == 2) {
                        text = noti;
                    } else if (i == 3) {
                        smsType = Integer.parseInt(noti);
                    }
                    ++i;
                }
                return new SMS(0, text, sender, "", Mapper.getSmsDate(Calendar.getInstance().getTimeInMillis()), smsType, title);
            }
        }
        return null;
    }

    private static String getFullSms(String bigText, String text) {
        if (!TextUtils.isEmpty((CharSequence)bigText) && !TextUtils.isEmpty((CharSequence)text) && bigText.length() > text.length()) {
            return bigText;
        }
        return text;
    }

    private static String getSender(boolean isDefault, String pkgName, String title) {
        if (isDefault) {
            return title;
        }
        return pkgName;
    }

    private static String getSmsDate(long when) {
        return DateUtil.fullDF.format(new Date(when));
    }

    private static int getSMStype(boolean isDefault) {
        if (isDefault) {
            return Constants.SMSType.SMS.ordinal();
        }
        return Constants.SMSType.NOTIFICATION.ordinal();
    }
}

