/*
 * Decompiled with CFR 0.152.
 */
package tenqube.parser.core;

import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Build;
import android.provider.Settings;
import android.provider.Telephony;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import tenqube.parser.constants.Constants;
import tenqube.parser.core.CardTableData;
import tenqube.parser.core.DateUtil;
import tenqube.parser.core.ParserService;
import tenqube.parser.model.RegData;
import tenqube.parser.model.Transaction;
import tenqube.parser.util.LogUtil;
import tenqube.parser.util.Validator;

class Utils {
    private static final Pattern spentMoneyPattern = Pattern.compile("\\s*([0-9,])+\ub9cc\uc6d0\\s*", 106);
    private static final Pattern titlePattern = Pattern.compile("(.+)\\([0-9]+\\)", 106);
    private static final Pattern[] KEYWORD_FILTERS = new Pattern[]{Pattern.compile("\\s*\ub204\uacc4\\s*[0-9,-]+[\ub9cc\uc6d0]*\\s*(.*)", 106), Pattern.compile("\\s*\ub204\uc801\\s*[0-9,-]+\uc6d0*\\s*(.*)", 106), Pattern.compile("\\s*\ub204\uc801\\s*[0-9,-]+\uc6d0*\\s*(.*)", 106), Pattern.compile("\\s*\uc794\uc561\\s*[0-9,-]+\uc6d0*\\s*(.*)", 106), Pattern.compile("\\s*\ud1b5\uc7a5\uc794\uc561\\s*[0-9,-]+\uc6d0*\\s*(.*)", 106), Pattern.compile("\\s*\uc9c0\uae09\uac00\ub2a5\uc561\\s*[0-9,-]+\uc6d0*\\s*(.*)", 106), Pattern.compile("\\s*\uc794\uc5ec\\s*[0-9,-]*\uc6d0+\\s*(.*)", 106), Pattern.compile("\\s*\uac00\ub2a5\uc561\\s*[0-9,-]*\uc6d0+\\s*(.*)", 106), Pattern.compile("\\s*\uc801\ub9bd\uc608\uc815\\s*[0-9,-]+\uc6d0*\\s*(.*)", 106), Pattern.compile("\\s*\uc794\uc5ec\ud55c\ub3c4\\s*[0-9,-]+\uc6d0*\\s*(.*)", 106), Pattern.compile("\\s*(.*)\\s+\ub204\uacc4.*", 106), Pattern.compile("\\s*(.*)\\s+\ub204\uc801.*", 106), Pattern.compile("\\s*(.*)\\s+\uc794\uc561.*", 106), Pattern.compile("\\s*(.*)\\s+\ud1b5\uc7a5\uc794\uc561.*", 106), Pattern.compile("\\s*(.*)\\s+\uc9c0\uae09\uac00\ub2a5\uc561.*", 106), Pattern.compile("\\s*(.*)\\s+\uc794\uc5ec.*", 106), Pattern.compile("\\s*(.*)\\s+\uac00\ub2a5\uc561.*", 106), Pattern.compile("\\s*(.*)\\s+\uc801\ub9bd\uc608\uc815.*", 106), Pattern.compile("\\s*(.*)\\s+\uc794\uc5ec\ud55c\ub3c4.*", 106)};
    private static final Pattern[] pDate = new Pattern[]{Pattern.compile("\\s*(\\d{1,2})/(\\d{1,2})\\s*,*\\s*(\\d{1,2}):(\\d{1,2})\\s*", 106), Pattern.compile("\\s*(\\d{1,2})\\.(\\d{1,2})\\s*,*\\s*(\\d{1,2}):(\\d{1,2})\\s*", 106), Pattern.compile("\\s*(\\d{1,2})\uc6d4(\\d{1,2})\uc77c\\s*(\\d{1,2})\uc2dc(\\d{1,2})\ubd84\\s*", 106), Pattern.compile("\\s*(\\d{1,2})\uc6d4(\\d{1,2})\uc77c\\s*", 106), Pattern.compile("\\s*(\\d{1,2})/(\\d{1,2})\\s*", 106), Pattern.compile("\\s*(\\d{1,2})/(\\d{1,2})\\s*\\s*(\\d{1,2}):(\\d{1,2}):(\\d{1,2})\\s*", 106), Pattern.compile("\\s*(\\d{4})\\.(\\d{1,2})\\.(\\d{1,2})\\s*(\\d{1,2}):(\\d{1,2}):(\\d{1,2})\\s*", 106), Pattern.compile("\\s*(\\d{4})/(\\d{1,2})/(\\d{1,2})\\s*(\\d{1,2}):(\\d{1,2})\\s*", 106), Pattern.compile("\\s*(\\d{4})\\s*-\\s*(\\d{1,2})\\s*-\\s*(\\d{1,2})\\s*", 106), Pattern.compile("\\s*(\\d{4})\ub144\\s*(\\d{1,2})\uc6d4\\s*(\\d{1,2})\uc77c\\s*", 106), Pattern.compile("\\s*(\\d{1,2}):(\\d{1,2}):(\\d{1,2})\\s*", 106)};
    static final Pattern numberPattern = Pattern.compile(".*[0-9]+.*", 106);

    Utils() {
    }

    public static String filterTitle(@NonNull String title) {
        Matcher matcher = titlePattern.matcher(title);
        if (matcher.matches()) {
            title = Utils.getMatcher(1, matcher);
        }
        title = title.replace("\u2069", "");
        title = title.replace("\u2068", "");
        title = title.replace("\u200e", "");
        title = title.replace("\u200b", "");
        return title.trim();
    }

    public static boolean isDefaultSMS(Context context, String pkgName) {
        String defaultSMS;
        if (Build.VERSION.SDK_INT >= 19) {
            defaultSMS = Telephony.Sms.getDefaultSmsPackage((Context)context);
        } else {
            String defApp = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"sms_default_application");
            PackageManager pm = context.getApplicationContext().getPackageManager();
            Intent iIntent = pm.getLaunchIntentForPackage(defApp);
            ResolveInfo mInfo = pm.resolveActivity(iIntent, 0);
            defaultSMS = mInfo.activityInfo.packageName;
        }
        return defaultSMS.equals(pkgName);
    }

    public static double transformSpentMoney(String spentMoney) {
        Matcher matcher = spentMoneyPattern.matcher(spentMoney);
        if (matcher.matches()) {
            String spentMoneyStr = Utils.getMatcher(1, matcher);
            if (TextUtils.isEmpty((CharSequence)spentMoneyStr)) {
                return 0.0;
            }
            return Double.parseDouble(spentMoneyStr.replace(",", "").replace(" ", "").replace("O", "0").trim()) * 10000.0;
        }
        return 0.0;
    }

    static String transformKeyword(String keyword) {
        try {
            keyword = keyword.trim();
            keyword = keyword.replace("\t", "");
            keyword = keyword.replace("<", "");
            keyword = keyword.replace(">", "");
            keyword = keyword.replaceAll("\\\\", "");
            keyword = keyword.replaceAll("  ", "");
            keyword = keyword.replace("\n", "");
            int length = keyword.length();
            if (length > 0) {
                if (keyword.substring(0, 1).equals("(") && ")".equals(keyword.substring(--length))) {
                    keyword = keyword.substring(1, length);
                } else if (keyword.substring(length).equals(".") || keyword.substring(length).equals("(") || keyword.substring(length).equals(",")) {
                    keyword = keyword.substring(0, length);
                }
            }
            if (keyword.contains("\uc794\uc561") || keyword.contains("\ub204\uacc4") || keyword.contains("\ub204\uc801") || keyword.contains("\uac00\ub2a5\uc561") || keyword.contains("\uc794\uc5ec") || keyword.contains("\uc801\ub9bd\uc608\uc815")) {
                for (Pattern pattern : KEYWORD_FILTERS) {
                    Matcher matcher = pattern.matcher(keyword);
                    if (!matcher.matches()) continue;
                    return "".equals(Utils.getMatcher(1, matcher)) ? "\ub0b4\uc6a9\uc5c6\uc74c" : Utils.getMatcher(1, matcher);
                }
            }
        }
        catch (Exception e) {
            return keyword;
        }
        return keyword;
    }

    static boolean matchingCardName(String duplCard, String parsedCard, String duplIsBank, String parsedIsBank) {
        if (!parsedIsBank.equals(duplIsBank)) {
            return true;
        }
        if (duplCard == null) {
            duplCard = "none";
        }
        if (parsedCard == null) {
            parsedCard = "none";
        }
        duplCard = duplCard.toLowerCase();
        parsedCard = parsedCard.toLowerCase();
        return (duplCard = Utils.transformCardName(duplCard)).equals(parsedCard = Utils.transformCardName(parsedCard)) || duplCard.contains(parsedCard) || parsedCard.contains(duplCard);
    }

    static String transformCardName(String cardName) {
        if (cardName == null) {
            cardName = "none";
        }
        cardName = cardName.replace("\uccb4\ud06c", "");
        cardName = cardName.replace("\uac00\uc871", "");
        cardName = cardName.replace("\ubc95\uc778", "");
        cardName = cardName.replace("\uc740\ud589", "");
        cardName = cardName.replace("\uc2e0\uc6a9", "");
        cardName = cardName.replace("\ub18d\ud611", "NH");
        cardName = cardName.replace("\uc678\ud658", "\ud558\ub098");
        cardName = cardName.replace("KEB", "\ud558\ub098");
        cardName = cardName.replace("citi", "\uc528\ud2f0");
        cardName = cardName.replace("\uad6d\ubbfc", "KB");
        cardName = cardName.replace("\ubd80\uc0b0", "BNK");
        cardName = cardName.replace("\uae30\uc5c5", "IBK");
        cardName = cardName.replace("MG", "\uc0c8\ub9c8\uc744");
        cardName = cardName.replace("\uc2a4\ud0e0\ucc28\ud0c0\ub4dc", "SC");
        cardName = cardName.replace("\uc804\ubd81", "JB");
        return cardName;
    }

    static String transformFullSMS(String fullSMS) {
        if (fullSMS == null) {
            fullSMS = "None";
        }
        fullSMS = fullSMS.replace("[FW]", "");
        fullSMS = fullSMS.replace("\u3000", " ");
        fullSMS = fullSMS.replace("\u21b5", " ");
        fullSMS = fullSMS.replace("FW>", "");
        fullSMS = fullSMS.replace("\ub4c0>", "");
        fullSMS = fullSMS.replace("[\uc7ac\uc804\uc1a1]", "");
        fullSMS = fullSMS.replace("[\ud22c]", "");
        fullSMS = fullSMS.replace("[Web\ubc1c\uc2e0]\n", "");
        fullSMS = fullSMS.replace("[Web\ubc1c\uc2e0]", "");
        fullSMS = fullSMS.replace("[Web \ubc1c\uc2e0]", "");
        fullSMS = fullSMS.replace("[web \ubc1c\uc2e0]", "");
        fullSMS = fullSMS.replace("[web\ubc1c\uc2e0]", "");
        fullSMS = fullSMS.replace("[WEB\ubc1c\uc2e0]", "");
        fullSMS = fullSMS.replace("[WEB \ubc1c\uc2e0]", "");
        fullSMS = fullSMS.replace("(\uc7ac\uc804\uc1a1)", "");
        fullSMS = fullSMS.replace("[", " ");
        if ((fullSMS = fullSMS.replace("]", " ")).length() > 4 && fullSMS.substring(0, 4).contains("FW")) {
            fullSMS = fullSMS.replace("FW", "");
        }
        return fullSMS.replace("\n", " ");
    }

    static String transformCurrency(String currency) {
        if (TextUtils.isEmpty((CharSequence)currency) || "null".equalsIgnoreCase(currency)) {
            return "";
        }
        if ("\uc5d4".equals(currency.trim())) {
            return "JPY";
        }
        if ("\uc704\uc548".equals(currency.trim())) {
            return "CNY";
        }
        if ("\uc720\ub85c".equals(currency.trim())) {
            return "EUR";
        }
        if ("\ub2ec\ub7ec".equals(currency.trim())) {
            return "USD";
        }
        return currency;
    }

    static String getCardNumUntilFour(String cardNum) {
        if (TextUtils.isEmpty((CharSequence)cardNum)) {
            return "";
        }
        cardNum = cardNum.replace("(", "");
        cardNum = cardNum.replace(")", "");
        cardNum = cardNum.replace("-", "");
        cardNum = cardNum.replace("X", "*");
        cardNum = cardNum.replace("#", "*");
        return (cardNum = cardNum.replaceAll(" ", "")).length() > 4 ? "(" + cardNum.substring(cardNum.length() - 4) + ")" : "(" + cardNum + ")";
    }

    static String transformDate(Calendar smsCal, String spentDate) {
        String year = smsCal.get(1) + "";
        String second = DateUtil.decimalFormat.format(smsCal.get(13)) + "";
        String month = DateUtil.decimalFormat.format(smsCal.get(2) + 1);
        String day = DateUtil.decimalFormat.format(smsCal.get(5)) + "";
        String hour = DateUtil.decimalFormat.format(smsCal.get(11)) + "";
        String minute = DateUtil.decimalFormat.format(smsCal.get(12)) + "";
        try {
            if (!TextUtils.isEmpty((CharSequence)spentDate)) {
                block11: for (int i = 0; i < pDate.length; ++i) {
                    Matcher matcher = pDate[i].matcher(spentDate);
                    if (!matcher.matches()) continue;
                    switch (i) {
                        case 0: 
                        case 1: 
                        case 2: {
                            month = String.format(Locale.KOREA, "%02d", Integer.parseInt(Utils.getMatcher(1, matcher)));
                            day = String.format(Locale.KOREA, "%02d", Integer.parseInt(Utils.getMatcher(2, matcher)));
                            hour = "24".equals(Utils.getMatcher(3, matcher)) ? "00" : String.format(Locale.KOREA, "%02d", Integer.parseInt(Utils.getMatcher(3, matcher)));
                            minute = String.format(Locale.KOREA, "%02d", Integer.parseInt(Utils.getMatcher(4, matcher)));
                            continue block11;
                        }
                        case 3: 
                        case 4: {
                            month = String.format(Locale.KOREA, "%02d", Integer.parseInt(Utils.getMatcher(1, matcher)));
                            day = String.format(Locale.KOREA, "%02d", Integer.parseInt(Utils.getMatcher(2, matcher)));
                            continue block11;
                        }
                        case 5: {
                            month = String.format(Locale.KOREA, "%02d", Integer.parseInt(Utils.getMatcher(1, matcher)));
                            day = String.format(Locale.KOREA, "%02d", Integer.parseInt(Utils.getMatcher(2, matcher)));
                            hour = "24".equals(Utils.getMatcher(3, matcher)) ? "00" : String.format(Locale.KOREA, "%02d", Integer.parseInt(Utils.getMatcher(3, matcher)));
                            minute = String.format(Locale.KOREA, "%02d", Integer.parseInt(Utils.getMatcher(4, matcher)));
                            second = String.format(Locale.KOREA, "%02d", Integer.parseInt(Utils.getMatcher(5, matcher)));
                            continue block11;
                        }
                        case 6: {
                            year = String.format(Locale.KOREA, "%02d", Integer.parseInt(Utils.getMatcher(1, matcher)));
                            month = String.format(Locale.KOREA, "%02d", Integer.parseInt(Utils.getMatcher(2, matcher)));
                            day = String.format(Locale.KOREA, "%02d", Integer.parseInt(Utils.getMatcher(3, matcher)));
                            hour = "24".equals(Utils.getMatcher(3, matcher)) ? "00" : String.format(Locale.KOREA, "%02d", Integer.parseInt(Utils.getMatcher(4, matcher)));
                            minute = String.format(Locale.KOREA, "%02d", Integer.parseInt(Utils.getMatcher(5, matcher)));
                            second = String.format(Locale.KOREA, "%02d", Integer.parseInt(Utils.getMatcher(6, matcher)));
                            continue block11;
                        }
                        case 7: {
                            year = String.format(Locale.KOREA, "%02d", Integer.parseInt(Utils.getMatcher(1, matcher)));
                            month = String.format(Locale.KOREA, "%02d", Integer.parseInt(Utils.getMatcher(2, matcher)));
                            day = String.format(Locale.KOREA, "%02d", Integer.parseInt(Utils.getMatcher(3, matcher)));
                            hour = "24".equals(Utils.getMatcher(3, matcher)) ? "00" : String.format(Locale.KOREA, "%02d", Integer.parseInt(Utils.getMatcher(4, matcher)));
                            minute = String.format(Locale.KOREA, "%02d", Integer.parseInt(Utils.getMatcher(5, matcher)));
                            continue block11;
                        }
                        case 8: 
                        case 9: {
                            year = String.format(Locale.KOREA, "%02d", Integer.parseInt(Utils.getMatcher(1, matcher)));
                            month = String.format(Locale.KOREA, "%02d", Integer.parseInt(Utils.getMatcher(2, matcher)));
                            day = String.format(Locale.KOREA, "%02d", Integer.parseInt(Utils.getMatcher(3, matcher)));
                            continue block11;
                        }
                        case 10: {
                            hour = "24".equals(Utils.getMatcher(3, matcher)) ? "00" : String.format(Locale.KOREA, "%02d", Integer.parseInt(Utils.getMatcher(1, matcher)));
                            minute = String.format(Locale.KOREA, "%02d", Integer.parseInt(Utils.getMatcher(2, matcher)));
                            second = String.format(Locale.KOREA, "%02d", Integer.parseInt(Utils.getMatcher(3, matcher)));
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String resultDate = year + "-" + month + "-" + day + " " + hour + ":" + minute + ":" + second;
        return Validator.isDate(resultDate) ? resultDate : null;
    }

    static String transformSpentMoney(double value) {
        if (value == 0.0) {
            return "0";
        }
        String pattern = "###,###";
        DecimalFormat decimalFormat = new DecimalFormat(pattern);
        return decimalFormat.format(value);
    }

    static String transformSender(String sender) {
        if (!TextUtils.isEmpty((CharSequence)sender)) {
            sender = sender.replace("+822", "");
            if ((sender = sender.replace("+82", "")).length() > 2 && sender.substring(0, 3).equals("822")) {
                sender = sender.replaceFirst("822", "");
            }
            if (sender.length() > 1 && sender.substring(0, 2).equals("82")) {
                sender = sender.replaceFirst("82", "");
            }
            sender = sender.replace("-", "");
            sender = sender.replace("+", "");
            if ((sender = sender.replace("#", "")).length() > 1 && sender.substring(0, 2).equals("02")) {
                sender = sender.replaceFirst("02", "");
            }
            if (sender.length() > 1 && sender.substring(0, 1).equals("0")) {
                sender = sender.length() > 2 ? (!sender.substring(0, 3).equals("010") ? sender.replaceFirst("0", "") : sender.replaceFirst("0", "")) : sender.replaceFirst("0", "");
            }
            return sender;
        }
        return "";
    }

    static String transformRepSender(String fullSMS) {
        if (!TextUtils.isEmpty((CharSequence)fullSMS)) {
            if (fullSMS.contains("\ud558\uc774\ud22c\uc790")) {
                return "\ud558\uc774\ud22c\uc790";
            }
            if (fullSMS.contains("SK\uc99d\uad8c")) {
                return "SK\uc99d\uad8c";
            }
            if (fullSMS.contains("\uc2e0\uc601\uc99d\uad8c")) {
                return "\uc2e0\uc601\uc99d\uad8c";
            }
            if (fullSMS.contains("\ub3d9\ubd80\uc99d\uad8c")) {
                return "\ub3d9\ubd80\uc99d\uad8c";
            }
            if (fullSMS.contains("\uc720\uc9c4\ud22c\uc790")) {
                return "\uc720\uc9c4\ud22c\uc790";
            }
        }
        return null;
    }

    static String getMatcher(int pos, Matcher matcher) {
        try {
            return matcher.group(pos);
        }
        catch (IndexOutOfBoundsException e) {
            return "";
        }
    }

    static ArrayList<Transaction> distinctTransactions(ArrayList<Transaction> transactions) {
        LinkedHashMap<String, Transaction> map = new LinkedHashMap<String, Transaction>();
        for (Transaction transaction : transactions) {
            String key = transaction.identifier;
            map.put(key, transaction);
        }
        return new ArrayList<Transaction>(map.values());
    }

    static int getSMSType(int smsType) {
        return Constants.SMSType.NOTIFICATION.ordinal() == smsType ? Constants.SMSType.NOTIFICATION.ordinal() : Constants.SMSType.SMS.ordinal();
    }

    static boolean isSpendSMS(String fullSMS) {
        Matcher matcher = numberPattern.matcher(fullSMS);
        return matcher.matches();
    }

    static String makeCardKey(CardTableData parsedCard) {
        StringBuilder key = new StringBuilder();
        key.append(TextUtils.isEmpty((CharSequence)parsedCard.cardName) ? "" : parsedCard.cardName);
        key.append(TextUtils.isEmpty((CharSequence)parsedCard.cardNum) ? "" : parsedCard.cardNum);
        key.append(parsedCard.cardType);
        key.append(parsedCard.cardSubType);
        return key.toString();
    }

    static String makeSpentMoneyDwTypeKey(double spentMoney, int dwType) {
        StringBuilder key = new StringBuilder();
        key.append(spentMoney);
        key.append(";");
        key.append(dwType);
        return key.toString();
    }

    static String makeRegKey(String repSender, int smsType) {
        StringBuilder key = new StringBuilder();
        key.append(TextUtils.isEmpty((CharSequence)repSender) ? "" : repSender);
        key.append(smsType);
        return key.toString();
    }

    static String getCanceledSpentDate(Calendar smsCalendar, Calendar spentCalendar) {
        LogUtil.LOGI(ParserService.TAG, "getCanceledSpentDatesmsCalendar" + DateUtil.getStringDateAsYYYYMMddHHmmss(smsCalendar), ParserService.mIsDebug);
        Calendar spentCalendar2 = Calendar.getInstance();
        spentCalendar2.setTimeInMillis(spentCalendar.getTimeInMillis());
        spentCalendar2.add(1, -1);
        int diffDay = Math.abs(DateUtil.getDiffDateAsCalendar(smsCalendar, spentCalendar));
        int diffDay2 = Math.abs(DateUtil.getDiffDateAsCalendar(smsCalendar, spentCalendar2));
        LogUtil.LOGI(ParserService.TAG, "getCanceledSpentDatediffDay" + diffDay, ParserService.mIsDebug);
        LogUtil.LOGI(ParserService.TAG, "getCanceledSpentDatediffDay" + DateUtil.getStringDateAsYYYYMMddHHmmss(spentCalendar), ParserService.mIsDebug);
        LogUtil.LOGI(ParserService.TAG, "getCanceledSpentDatediffDay2" + diffDay2, ParserService.mIsDebug);
        LogUtil.LOGI(ParserService.TAG, "getCanceledSpentDatediffDay2" + DateUtil.getStringDateAsYYYYMMddHHmmss(spentCalendar2), ParserService.mIsDebug);
        if (diffDay <= diffDay2) {
            return DateUtil.getStringDateAsYYYYMMddHHmmss(spentCalendar);
        }
        return DateUtil.getStringDateAsYYYYMMddHHmmss(spentCalendar2);
    }

    static class RegComparator
    implements Comparator<RegData> {
        RegComparator() {
        }

        @Override
        public int compare(RegData reg1, RegData reg2) {
            return reg2.priority == reg1.priority ? (reg1.userPriority < reg2.userPriority ? 1 : -1) : (reg1.priority < reg2.priority ? 1 : -1);
        }
    }
}

