/*
 * Decompiled with CFR 0.152.
 */
package tenqube.parser.core;

import android.content.Context;
import android.text.TextUtils;
import java.util.Date;
import tenqube.parser.constants.Constants;
import tenqube.parser.core.DateUtil;
import tenqube.parser.core.Utils;
import tenqube.parser.model.NotiRequest;
import tenqube.parser.model.SMS;

public class Mapper {
    public static SMS toSMS(Context context, NotiRequest notiRequest) {
        boolean isDefault = Utils.isDefaultSMS(context, notiRequest.getPkgName());
        return new SMS(0, Mapper.getFullSms(notiRequest.getBigText(), notiRequest.getText()), Mapper.getSender(isDefault, notiRequest.getPkgName(), notiRequest.getTitle()), "", Mapper.getSmsDate(notiRequest.getWhen()), Mapper.getSMStype(isDefault), notiRequest.getTitle());
    }

    private static String getFullSms(String bigText, String text) {
        if (!TextUtils.isEmpty((CharSequence)bigText) && !TextUtils.isEmpty((CharSequence)text) && bigText.length() > text.length()) {
            return bigText;
        }
        return text;
    }

    private static String getSender(boolean isDefault, String pkgName, String title) {
        if (isDefault) {
            return title;
        }
        return pkgName;
    }

    private static String getSmsDate(long when) {
        return DateUtil.fullDF.format(new Date(when));
    }

    private static int getSMStype(boolean isDefault) {
        if (isDefault) {
            return Constants.SMSType.SMS.ordinal();
        }
        return Constants.SMSType.NOTIFICATION.ordinal();
    }
}

