/*
 * Decompiled with CFR 0.152.
 */
package tenqube.parser.core;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import tenqube.parser.core.DatabaseHelper;
import tenqube.parser.util.LogUtil;

class BaseQueryHelper {
    public static final String TAG = LogUtil.makeLogTag(BaseQueryHelper.class);
    static final String SELECT = " SELECT ";
    static final String VALUES = " VALUES ";
    static final String EXISTS = " EXISTS ";
    static final String LIMIT = " LIMIT ";
    static final String ORDER_BY = " ORDER BY ";
    static final String FROM = " FROM ";
    static final String WHERE = " WHERE ";
    static final String GROUP_BY = " GROUP BY ";
    static final String HAVING = " HAVING ";
    static final String JOIN = " JOIN ";
    static final String ON = " ON ";
    static final String AND = " AND ";
    static final String IN = " IN ";
    static final String NOT_IN = " NOT IN ";
    static final String OR = " OR ";
    static final String DESC = " DESC ";
    static final String ASC = " ASC ";
    static final String YYYY_MM_DD_H_M = "'%Y-%m-%d %H:%M'";
    static final String YYYY_MM_DD = "'%Y-%m-%d'";
    static final String MM_DD = "'%m-%d'";
    static final String H_M_S = "'%H:%M:%S'";
    static final String H_M = "'%H:%M'";
    private SQLiteDatabase db;
    SQLiteDatabase wdb;
    Context mContext;

    BaseQueryHelper(Context context) throws SecurityException, SQLException {
        this.mContext = context;
        this.db = DatabaseHelper.getInstance(context).getReadableDatabase();
        this.wdb = DatabaseHelper.getInstance(context).getWritableDatabase();
    }

    long insert(String tableName, ContentValues values) throws SecurityException, SQLException {
        return this.wdb.insert(tableName, null, values);
    }

    long update(String tableName, ContentValues values, String selection, String[] selectionArgs) throws SecurityException, SQLException {
        return this.wdb.update(tableName, values, selection, selectionArgs);
    }

    long delete(String tableName, String selection, String[] selectionArgs) throws SecurityException, SQLException {
        return this.wdb.delete(tableName, selection, selectionArgs);
    }

    Cursor runQuery(String query) throws SecurityException, SQLException {
        Cursor rows = this.db.rawQuery(query, null);
        if (rows == null) {
            return null;
        }
        try {
            int rowCount = rows.getCount();
            if (rowCount == 0 || !rows.moveToLast()) {
                rows.close();
                return null;
            }
        }
        catch (RuntimeException ex) {
            rows.close();
            return null;
        }
        return rows;
    }

    String getJoinTable() {
        return " TRANSACTIONS AS tran  JOIN  CARDS AS card  ON  tran.cardId= card._id";
    }
}

