package tenqube.parser.core;

import android.content.Context;
import android.text.TextUtils;

import java.util.Date;

import tenqube.parser.constants.Constants;
import tenqube.parser.model.NotiRequest;
import tenqube.parser.model.SMS;

public class Mapper {

    public static SMS toSMS(Context context, NotiRequest notiRequest) {

        boolean isDefault = Utils.isDefaultSMS(context, notiRequest.getPkgName());
        return new SMS(0, getFullSms(notiRequest.getBigText(), notiRequest.getText()),
                getSender(isDefault, notiRequest.getPkgName(), notiRequest.getTitle()),
                "",
                getSmsDate(notiRequest.getWhen()),
                getSMStype(isDefault),
                notiRequest.getTitle());
    }

    private static String getFullSms(String bigText, String text) {
        if(!TextUtils.isEmpty(bigText) && !TextUtils.isEmpty(text)) {
            if(bigText.length() > text.length()) {
                return bigText;
            }
        }
        return text;
    }

    /**
     * 디폴트 문자앱의 패키지인경우 title을 센더로 나머지는 pkgName
     * @return
     */
    private static String getSender(boolean isDefault, String pkgName, String title) {

        if(isDefault) {
            return title;
        } else {
            return pkgName;
        }

    }

    private static String getSmsDate(long when) {
        return DateUtil.fullDF.format(new Date(when));
    }

    private static int getSMStype(boolean isDefault) {
        if(isDefault) {
            return Constants.SMSType.SMS.ordinal();
        } else {
            return Constants.SMSType.NOTIFICATION.ordinal();
        }
    }
}
