/*
 * Decompiled with CFR 0.152.
 */
package tenqube.parser.util;

import android.text.TextUtils;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;

public class Validator {
    private static Map<String, Integer> VALIDATOR = new HashMap<String, Integer>();
    public static final String CARD_NAME = "cardName";
    public static final String CARD_NUM = "cardNum";
    public static final String KEYWORD = "keyword";
    public static final String SENDER = "sender";
    public static final String FULL_SMS = "fullSms";
    public static final String MEMO = "memo";
    public static final SimpleDateFormat fullDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.KOREA);
    private static Pattern numberPattern;
    private static Pattern currencyPattern;

    public static boolean invalidStr(String string, String string2) {
        Integer n = VALIDATOR.get(string);
        if (n != null) {
            return !TextUtils.isEmpty((CharSequence)string2) && string2.length() > n;
        }
        return true;
    }

    public static boolean isDate(String string) {
        if (string == null) {
            return false;
        }
        fullDF.setLenient(false);
        try {
            fullDF.parse(string);
        }
        catch (Exception exception) {
            return false;
        }
        return string.length() == 19;
    }

    public static boolean isNumber(String string) {
        return numberPattern.matcher(string).matches();
    }

    public static String getValidString(String string) {
        return !TextUtils.isEmpty((CharSequence)string) && string.length() < 50 ? string.trim() : "";
    }

    public static String getValidFullSMS(String string) {
        return !TextUtils.isEmpty((CharSequence)string) && string.length() < 500 ? string.trim() : "";
    }

    public static int getValidInstallmentCount(int n) {
        return n >= 1 && n <= 36 ? n : 1;
    }

    public static String getValidCurrency(String string) {
        return currencyPattern.matcher(string).matches() ? string : "none";
    }

    static {
        VALIDATOR.put(CARD_NAME, 50);
        VALIDATOR.put(CARD_NUM, 50);
        VALIDATOR.put(KEYWORD, 50);
        VALIDATOR.put(SENDER, 50);
        VALIDATOR.put(FULL_SMS, 500);
        VALIDATOR.put(MEMO, 300);
        numberPattern = Pattern.compile("[0-9]+", 106);
        currencyPattern = Pattern.compile("[A-Z]{3}", 106);
    }
}

