/*
 * Decompiled with CFR 0.152.
 */
package tech.v3.dataset;

import clojure.lang.IDeref;
import ham_fisted.ArrayLists;
import java.util.function.LongConsumer;
import org.roaringbitmap.RoaringBitmap;

public class ByteValidity {
    public static int trimIndexes(int[] nArray, int n, long l) {
        while (n > 0 && Integer.toUnsignedLong(nArray[n - 1]) >= l) {
            --n;
        }
        return n;
    }

    public static class MissingIndexReducer
    extends ValidityBase {
        public MissingIndexReducer(long l, long l2) {
            super(l, l2);
        }

        @Override
        public void accept(long l) {
            if (l != -1L) {
                int n = (int)l;
                int n2 = this.idx * 8;
                if ((n & 1) != 1) {
                    this.indexes[this.nIndexes++] = n2;
                }
                if ((n & 2) != 2) {
                    this.indexes[this.nIndexes++] = n2 + 1;
                }
                if ((n & 4) != 4) {
                    this.indexes[this.nIndexes++] = n2 + 2;
                }
                if ((n & 8) != 8) {
                    this.indexes[this.nIndexes++] = n2 + 3;
                }
                if ((n & 0x10) != 16) {
                    this.indexes[this.nIndexes++] = n2 + 4;
                }
                if ((n & 0x20) != 32) {
                    this.indexes[this.nIndexes++] = n2 + 5;
                }
                if ((n & 0x40) != 64) {
                    this.indexes[this.nIndexes++] = n2 + 6;
                }
                if ((n & 0x80) != 128) {
                    this.indexes[this.nIndexes++] = n2 + 7;
                }
            }
            ++this.idx;
        }

        public Object deref() {
            RoaringBitmap roaringBitmap = new RoaringBitmap();
            roaringBitmap.addN(this.indexes, 0, ByteValidity.trimIndexes(this.indexes, this.nIndexes, this.nElems));
            return roaringBitmap;
        }
    }

    public static class ValidityIndexReducer
    extends ValidityBase {
        public ValidityIndexReducer(long l, long l2) {
            super(l, l2);
        }

        @Override
        public void accept(long l) {
            if (l != 0L) {
                int n = (int)l;
                int n2 = this.idx * 8;
                if ((n & 1) == 1) {
                    this.indexes[this.nIndexes++] = n2;
                }
                if ((n & 2) == 2) {
                    this.indexes[this.nIndexes++] = n2 + 1;
                }
                if ((n & 4) == 4) {
                    this.indexes[this.nIndexes++] = n2 + 2;
                }
                if ((n & 8) == 8) {
                    this.indexes[this.nIndexes++] = n2 + 3;
                }
                if ((n & 0x10) == 16) {
                    this.indexes[this.nIndexes++] = n2 + 4;
                }
                if ((n & 0x20) == 32) {
                    this.indexes[this.nIndexes++] = n2 + 5;
                }
                if ((n & 0x40) == 64) {
                    this.indexes[this.nIndexes++] = n2 + 6;
                }
                if ((n & 0x80) == 128) {
                    this.indexes[this.nIndexes++] = n2 + 7;
                }
            }
            ++this.idx;
        }

        public Object deref() {
            return ArrayLists.toList((int[])this.indexes).subList(0, ByteValidity.trimIndexes(this.indexes, this.nIndexes, this.nElems));
        }
    }

    public static abstract class ValidityBase
    implements LongConsumer,
    IDeref {
        long nElems;
        int idx;
        int nIndexes;
        int[] indexes;

        public ValidityBase(long l, long l2) {
            this.nElems = l;
            this.indexes = new int[(int)l2];
            this.nIndexes = 0;
            this.idx = 0;
        }
    }
}

