/*
 * Decompiled with CFR 0.152.
 */
package tech.v3.datatype;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.Month;
import java.time.chrono.IsoChronology;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalField;
import java.time.temporal.WeekFields;
import java.util.Locale;
import tech.v3.datatype.ByteConversions;

public class PackedLocalDate {
    public static final int DAYS_PER_CYCLE = 146097;
    public static final long DAYS_0000_TO_1970 = 719528L;

    public static byte getDayOfMonth(int n) {
        return (byte)n;
    }

    public static short getYear(int n) {
        byte by = (byte)(n >> 24);
        byte by2 = (byte)(n >> 16);
        return (short)((by << 8) + (by2 & 0xFF));
    }

    public static LocalDate asLocalDate(int n) {
        return LocalDate.of((int)PackedLocalDate.getYear(n), PackedLocalDate.getMonthValue(n), (int)PackedLocalDate.getDayOfMonth(n));
    }

    public static byte getMonthValue(int n) {
        return (byte)(n >> 8);
    }

    public static int pack(LocalDate localDate) {
        return PackedLocalDate.pack((short)localDate.getYear(), (byte)localDate.getMonthValue(), (byte)localDate.getDayOfMonth());
    }

    public static int pack(short s, byte by, byte by2) {
        byte by3 = (byte)(s >> 8 & 0xFF);
        byte by4 = (byte)s;
        return ByteConversions.intFromBytesBE((byte)by3, (byte)by4, (byte)by, (byte)by2);
    }

    public static int pack(int n, int n2, int n3) {
        byte by = (byte)(n >> 8 & 0xFF);
        byte by2 = (byte)n;
        return ByteConversions.intFromBytesBE((byte)by, (byte)by2, (byte)((byte)n2), (byte)((byte)n3));
    }

    public static int getDayOfYear(int n) {
        return PackedLocalDate.getMonth(n).firstDayOfYear(PackedLocalDate.isLeapYear(n)) + PackedLocalDate.getDayOfMonth(n) - 1;
    }

    public static boolean isLeapYear(int n) {
        return IsoChronology.INSTANCE.isLeapYear(PackedLocalDate.getYear(n));
    }

    public static Month getMonth(int n) {
        return Month.of(PackedLocalDate.getMonthValue(n));
    }

    public static int lengthOfMonth(int n) {
        switch (PackedLocalDate.getMonthValue(n)) {
            case 2: {
                return PackedLocalDate.isLeapYear(n) ? 29 : 28;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                return 30;
            }
        }
        return 31;
    }

    public static long toEpochDay(int n) {
        long l = PackedLocalDate.getYear(n);
        long l2 = PackedLocalDate.getMonthValue(n);
        long l3 = 0L;
        l3 += 365L * l;
        l3 = l >= 0L ? (l3 += (l + 3L) / 4L - (l + 99L) / 100L + (l + 399L) / 400L) : (l3 -= l / -4L - l / -100L + l / -400L);
        l3 += (367L * l2 - 362L) / 12L;
        l3 += (long)(PackedLocalDate.getDayOfMonth(n) - 1);
        if (l2 > 2L) {
            --l3;
            if (!PackedLocalDate.isLeapYear(n)) {
                --l3;
            }
        }
        return l3 - 719528L;
    }

    public static DayOfWeek getDayOfWeek(int n) {
        int n2 = Math.floorMod((int)PackedLocalDate.toEpochDay(n) + 3, 7);
        return DayOfWeek.of(n2 + 1);
    }

    public static int getQuarter(int n) {
        Month month = PackedLocalDate.getMonth(n);
        switch (month) {
            case JANUARY: 
            case FEBRUARY: 
            case MARCH: {
                return 1;
            }
            case APRIL: 
            case MAY: 
            case JUNE: {
                return 2;
            }
            case JULY: 
            case AUGUST: 
            case SEPTEMBER: {
                return 3;
            }
        }
        return 4;
    }

    public static boolean isInQ1(int n) {
        return PackedLocalDate.getQuarter(n) == 1;
    }

    public static boolean isInQ2(int n) {
        return PackedLocalDate.getQuarter(n) == 2;
    }

    public static boolean isInQ3(int n) {
        return PackedLocalDate.getQuarter(n) == 3;
    }

    public static boolean isInQ4(int n) {
        return PackedLocalDate.getQuarter(n) == 4;
    }

    public static boolean isAfter(int n, int n2) {
        return n > n2;
    }

    public static boolean isEqualTo(int n, int n2) {
        return n == n2;
    }

    public static boolean isBefore(int n, int n2) {
        return n < n2;
    }

    public static boolean isOnOrBefore(int n, int n2) {
        return n <= n2;
    }

    public static boolean isOnOrAfter(int n, int n2) {
        return n >= n2;
    }

    public static boolean isDayOfWeek(int n, DayOfWeek dayOfWeek) {
        DayOfWeek dayOfWeek2 = PackedLocalDate.getDayOfWeek(n);
        return dayOfWeek == dayOfWeek2;
    }

    public static boolean isSunday(int n) {
        return PackedLocalDate.isDayOfWeek(n, DayOfWeek.SUNDAY);
    }

    public static boolean isMonday(int n) {
        return PackedLocalDate.isDayOfWeek(n, DayOfWeek.MONDAY);
    }

    public static boolean isTuesday(int n) {
        return PackedLocalDate.isDayOfWeek(n, DayOfWeek.TUESDAY);
    }

    public static boolean isWednesday(int n) {
        return PackedLocalDate.isDayOfWeek(n, DayOfWeek.WEDNESDAY);
    }

    public static boolean isThursday(int n) {
        return PackedLocalDate.isDayOfWeek(n, DayOfWeek.THURSDAY);
    }

    public static boolean isFriday(int n) {
        return PackedLocalDate.isDayOfWeek(n, DayOfWeek.FRIDAY);
    }

    public static boolean isSaturday(int n) {
        return PackedLocalDate.isDayOfWeek(n, DayOfWeek.SATURDAY);
    }

    public static boolean isFirstDayOfMonth(int n) {
        return PackedLocalDate.getDayOfMonth(n) == 1;
    }

    public static boolean isInJanuary(int n) {
        return PackedLocalDate.getMonth(n) == Month.JANUARY;
    }

    public static boolean isInFebruary(int n) {
        return PackedLocalDate.getMonth(n) == Month.FEBRUARY;
    }

    public static boolean isInMarch(int n) {
        return PackedLocalDate.getMonth(n) == Month.MARCH;
    }

    public static boolean isInApril(int n) {
        return PackedLocalDate.getMonth(n) == Month.APRIL;
    }

    public static boolean isInMay(int n) {
        return PackedLocalDate.getMonth(n) == Month.MAY;
    }

    public static boolean isInJune(int n) {
        return PackedLocalDate.getMonth(n) == Month.JUNE;
    }

    public static boolean isInJuly(int n) {
        return PackedLocalDate.getMonth(n) == Month.JULY;
    }

    public static boolean isInAugust(int n) {
        return PackedLocalDate.getMonth(n) == Month.AUGUST;
    }

    public static boolean isInSeptember(int n) {
        return PackedLocalDate.getMonth(n) == Month.SEPTEMBER;
    }

    public static boolean isInOctober(int n) {
        return PackedLocalDate.getMonth(n) == Month.OCTOBER;
    }

    public static boolean isInNovember(int n) {
        return PackedLocalDate.getMonth(n) == Month.NOVEMBER;
    }

    public static boolean isInDecember(int n) {
        return PackedLocalDate.getMonth(n) == Month.DECEMBER;
    }

    public static boolean isLastDayOfMonth(int n) {
        return PackedLocalDate.getDayOfMonth(n) == PackedLocalDate.lengthOfMonth(n);
    }

    public static int withDayOfMonth(int n, int n2) {
        byte by = (byte)n;
        byte by2 = PackedLocalDate.getMonthValue(n2);
        short s = PackedLocalDate.getYear(n2);
        return PackedLocalDate.pack(s, by2, by);
    }

    public static int withMonth(int n, int n2) {
        byte by = PackedLocalDate.getDayOfMonth(n2);
        byte by2 = (byte)n;
        short s = PackedLocalDate.getYear(n2);
        return PackedLocalDate.pack(s, by2, by);
    }

    public static int withYear(int n, int n2) {
        byte by = PackedLocalDate.getDayOfMonth(n2);
        byte by2 = PackedLocalDate.getMonthValue(n2);
        short s = (short)n;
        return PackedLocalDate.pack(s, by2, by);
    }

    public static int plusYears(int n, int n2) {
        if (n == 0) {
            return n2;
        }
        byte by = PackedLocalDate.getDayOfMonth(n2);
        byte by2 = PackedLocalDate.getMonthValue(n2);
        short s = PackedLocalDate.getYear(n2);
        int n3 = ChronoField.YEAR.checkValidIntValue(n + s);
        return PackedLocalDate.resolvePreviousValid(n3, by2, by);
    }

    public static int minusYears(int n, int n2) {
        return PackedLocalDate.plusYears(-n, n2);
    }

    public static int plusMonths(int n, int n2) {
        if (n == 0) {
            return n2;
        }
        byte by = PackedLocalDate.getDayOfMonth(n2);
        byte by2 = PackedLocalDate.getMonthValue(n2);
        short s = PackedLocalDate.getYear(n2);
        long l = (long)s * 12L + (long)(by2 - 1);
        long l2 = l + (long)n;
        int n3 = ChronoField.YEAR.checkValidIntValue(Math.floorDiv((int)l2, 12));
        int n4 = Math.floorMod((int)l2, 12) + 1;
        return PackedLocalDate.resolvePreviousValid(n3, n4, by);
    }

    public static int minusMonths(int n, int n2) {
        return PackedLocalDate.plusMonths(-n, n2);
    }

    public static int plusWeeks(int n, int n2) {
        return PackedLocalDate.plusDays(n * 7, n2);
    }

    public static int minusWeeks(int n, int n2) {
        return PackedLocalDate.minusDays(n * 7, n2);
    }

    public static int plusDays(int n, int n2) {
        if (n == 0) {
            return n2;
        }
        byte by = PackedLocalDate.getDayOfMonth(n2);
        byte by2 = PackedLocalDate.getMonthValue(n2);
        short s = PackedLocalDate.getYear(n2);
        int n3 = n + by;
        if (n3 > 0) {
            if (n3 <= 28) {
                return PackedLocalDate.pack(s, by2, (byte)n3);
            }
            if (n3 <= 59) {
                long l = PackedLocalDate.lengthOfMonth(n2);
                if ((long)n3 <= l) {
                    return PackedLocalDate.pack(s, by2, (byte)n3);
                }
                if (by2 < 12) {
                    return PackedLocalDate.pack(s, (byte)(by2 + 1), (byte)((long)n3 - l));
                }
                ChronoField.YEAR.checkValidValue((long)s + 1L);
                return PackedLocalDate.pack((short)(s + 1), (byte)1, (byte)((long)n3 - l));
            }
        }
        long l = Math.addExact(PackedLocalDate.toEpochDay(n2), (long)n);
        return PackedLocalDate.ofEpochDay(l);
    }

    public static int minusDays(int n, int n2) {
        return PackedLocalDate.plusDays(-n, n2);
    }

    public static boolean isInYear(int n, int n2) {
        return PackedLocalDate.getYear(n) == n2;
    }

    public static int lengthOfYear(int n) {
        return PackedLocalDate.isLeapYear(n) ? 366 : 365;
    }

    public static int resolvePreviousValid(int n, int n2, int n3) {
        int n4 = n3;
        switch (n2) {
            case 2: {
                n4 = Math.min(n3, IsoChronology.INSTANCE.isLeapYear(n) ? 29 : 28);
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                n4 = Math.min(n3, 30);
            }
        }
        return PackedLocalDate.pack((short)n, (byte)n2, (byte)n4);
    }

    public static int getWeekOfYear(int n) {
        LocalDate localDate = PackedLocalDate.asLocalDate(n);
        if (localDate == null) {
            throw new IllegalArgumentException("Cannot get week of year for missing value");
        }
        TemporalField temporalField = WeekFields.of(Locale.getDefault()).weekOfWeekBasedYear();
        return localDate.get(temporalField);
    }

    public static int ofEpochDay(long l) {
        long l2;
        long l3;
        ChronoField.EPOCH_DAY.checkValidValue(l);
        long l4 = l + 719528L;
        long l5 = 0L;
        if ((l4 -= 60L) < 0L) {
            l3 = (l4 + 1L) / 146097L - 1L;
            l5 = l3 * 400L;
            l4 += -l3 * 146097L;
        }
        if ((l2 = l4 - (365L * (l3 = (400L * l4 + 591L) / 146097L) + l3 / 4L - l3 / 100L + l3 / 400L)) < 0L) {
            l2 = l4 - (365L * --l3 + l3 / 4L - l3 / 100L + l3 / 400L);
        }
        l3 += l5;
        int n = (int)l2;
        int n2 = (n * 5 + 2) / 153;
        int n3 = (n2 + 2) % 12 + 1;
        int n4 = n - (n2 * 306 + 5) / 10 + 1;
        int n5 = ChronoField.YEAR.checkValidIntValue(l3 += (long)(n2 / 10));
        return PackedLocalDate.pack((short)n5, (byte)n3, (byte)n4);
    }

    public static int plus(int n, ChronoUnit chronoUnit, int n2) {
        switch (chronoUnit) {
            case YEARS: {
                return PackedLocalDate.plusYears(n, n2);
            }
            case MONTHS: {
                return PackedLocalDate.plusMonths(n, n2);
            }
            case WEEKS: {
                return PackedLocalDate.plusWeeks(n, n2);
            }
            case DAYS: {
                return PackedLocalDate.plusDays(n, n2);
            }
        }
        throw new IllegalArgumentException("Unsupported Temporal Unit");
    }

    public static int minus(int n, ChronoUnit chronoUnit, int n2) {
        return PackedLocalDate.plus(-n, chronoUnit, n2);
    }

    public static int daysUntil(int n, int n2) {
        return (int)(PackedLocalDate.toEpochDay(n) - PackedLocalDate.toEpochDay(n2));
    }

    public static int weeksUntil(int n, int n2) {
        return (int)(PackedLocalDate.toEpochDay(n) - PackedLocalDate.toEpochDay(n2)) / 7;
    }

    public static int monthsUntil(int n, int n2) {
        int n3 = PackedLocalDate.getMonthInternal(n2) * 32 + PackedLocalDate.getDayOfMonth(n2);
        int n4 = PackedLocalDate.getMonthInternal(n) * 32 + PackedLocalDate.getDayOfMonth(n);
        return (n4 - n3) / 32;
    }

    public static int yearsUntil(int n, int n2) {
        return PackedLocalDate.monthsUntil(n, n2) / 12;
    }

    public static int getMonthInternal(int n) {
        return PackedLocalDate.getYear(n) * 12 + PackedLocalDate.getMonthValue(n) - 1;
    }
}

