/*
 * Decompiled with CFR 0.152.
 */
package tech.uom.lib.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.measure.Dimension;
import tech.units.indriya.unit.UnitDimension;

public class DimensionJsonDeserializer
extends StdScalarDeserializer<Dimension> {
    private static final long serialVersionUID = 1L;

    public DimensionJsonDeserializer() {
        super(Dimension.class);
    }

    public Dimension deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        Map baseDimensionsStrings = (Map)p.readValueAs(Map.class);
        HashMap<Dimension, Integer> baseDimensions = new HashMap<Dimension, Integer>(baseDimensionsStrings.entrySet().stream().collect(Collectors.toMap(entry -> DimensionJsonDeserializer.parseBaseDimension((String)entry.getKey()), entry -> (Integer)entry.getValue())));
        Dimension retValue = UnitDimension.NONE;
        for (Dimension baseDimension : baseDimensions.keySet()) {
            int exp = (Integer)baseDimensions.get(baseDimension);
            retValue = retValue.multiply(baseDimension.pow(exp));
        }
        return retValue;
    }

    private static Dimension parseBaseDimension(String symbol) {
        switch (symbol) {
            case "[N]": {
                return UnitDimension.AMOUNT_OF_SUBSTANCE;
            }
            case "[I]": {
                return UnitDimension.ELECTRIC_CURRENT;
            }
            case "[L]": {
                return UnitDimension.LENGTH;
            }
            case "[J]": {
                return UnitDimension.LUMINOUS_INTENSITY;
            }
            case "[M]": {
                return UnitDimension.MASS;
            }
            case "[\u0398]": {
                return UnitDimension.TEMPERATURE;
            }
            case "[T]": {
                return UnitDimension.TIME;
            }
        }
        throw new IllegalArgumentException(String.format("dimension symbol '%s' not supported, maybe dimensionless or wrong universe?", symbol));
    }
}

