/*
 * Decompiled with CFR 0.152.
 */
package tech.uom.lib.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import java.io.IOException;
import java.text.ParsePosition;
import javax.measure.Unit;
import systems.uom.ucum.format.UCUMFormat;

public class UnitJacksonModule
extends SimpleModule {
    private static final long serialVersionUID = 7601584599518016604L;

    public UnitJacksonModule() {
        super("UnitJsonSerializationModule", new Version(1, 3, 3, null, UnitJacksonModule.class.getPackage().getName(), "uom-lib-jackson"));
        this.addSerializer(Unit.class, (JsonSerializer)new UnitJsonSerializer());
        this.addDeserializer(Unit.class, (JsonDeserializer)new UnitJsonDeserializer());
    }

    private class UnitJsonDeserializer
    extends StdScalarDeserializer<Unit> {
        private static final long serialVersionUID = -6327531740958676293L;

        protected UnitJsonDeserializer() {
            super(Unit.class);
        }

        public Unit deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            JsonToken currentToken = jsonParser.getCurrentToken();
            if (currentToken == JsonToken.VALUE_STRING) {
                return UCUMFormat.getInstance((UCUMFormat.Variant)UCUMFormat.Variant.CASE_INSENSITIVE).parse((CharSequence)jsonParser.getText(), new ParsePosition(0));
            }
            throw deserializationContext.wrongTokenException(jsonParser, String.class, JsonToken.VALUE_STRING, "Expected unit value in String format");
        }
    }

    private class UnitJsonSerializer
    extends StdScalarSerializer<Unit> {
        private static final long serialVersionUID = 2500234678114311932L;

        protected UnitJsonSerializer() {
            super(Unit.class);
        }

        public void serialize(Unit unit, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            if (unit == null) {
                jgen.writeNull();
            } else {
                String ucumFormattedUnit = UCUMFormat.getInstance((UCUMFormat.Variant)UCUMFormat.Variant.CASE_SENSITIVE).format(unit, (Appendable)new StringBuilder()).toString();
                jgen.writeString(ucumFormattedUnit);
            }
        }
    }
}

