/*
 * Units of Measurement Reference Implementation
 * Copyright (c) 2005-2023, Jean-Marie Dautelle, Werner Keil, Otavio Santana.
 *
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice, this list of conditions
 *    and the following disclaimer in the documentation and/or other materials provided with the distribution.
 *
 * 3. Neither the name of JSR-385, Indriya nor the names of their contributors may be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
/* Generated By:JavaCC: Do not edit this line. TokenException.java Version 5.0 */
/* JavaCCOptions:KEEP_LINE_COL=null */
package tech.units.indriya.format;

import javax.measure.format.MeasurementParseException;

/**
 * This exception is thrown when token errors are encountered. You can explicitly create objects of this exception type by calling the method
 * raiseTokenException in the generated parser.
 *
 * You can modify this class to customize your error reporting mechanisms so long as you retain the public fields.
 * 
 * @author <a href="mailto:jean-marie@dautelle.com">Jean-Marie Dautelle</a>
 * @author <a href="mailto:werner@units.tech">Werner Keil</a>
 * @version 1.1, Sep 29, 2020
 */
public class TokenException extends MeasurementParseException {
  /**
   * The Serialization identifier for this class. Increment only if the <i>serialized</i> form of the class changes.
   */
  private static final long serialVersionUID = 2932151235799168061L;

  /**
   * This is the last token that has been consumed successfully. If this object has been created due to a parse error, the token following this token
   * will (therefore) be the first error token.
   */
  public Token currentToken;

  /**
   * Each entry in this array is an array of integers. Each array of integers represents a sequence of tokens (by their ordinal values) that is
   * expected at this point of the parse.
   */
  @SuppressWarnings("unused")
  private int[][] expectedTokenSequences;

  /**
   * This is a reference to the "tokenImage" array of the generated parser within which the parse error occurred. This array is defined in the
   * generated ...Constants interface.
   */
  @SuppressWarnings("unused")
  private String[] tokenImage;
  
  /**
   * This constructor is used by the method "raiseTokenException" in the generated parser. Calling this constructor generates a new object of this
   * type with the fields "currentToken", "expectedTokenSequences", and "tokenImage" set.
   */
  public TokenException(Token currentTokenVal, int[][] expectedTokenSequencesVal, String[] tokenImageVal) {
    super(initialise(currentTokenVal, expectedTokenSequencesVal, tokenImageVal));
    currentToken = currentTokenVal;
    expectedTokenSequences = expectedTokenSequencesVal;
    tokenImage = tokenImageVal;
  }

  /**
   * The following constructors are for use by you for whatever purpose you can think of. Constructing the exception in this manner makes the
   * exception behave in the normal way - i.e., as documented in the class "Throwable". The fields "errorToken", "expectedTokenSequences", and
   * "tokenImage" do not contain relevant information. The JavaCC generated code does not use these constructors.
   */

  public TokenException() {
    super("");
  }

  /** Constructor with message. */
  public TokenException(String message) {
    super(message);
  }

  public Token getToken() {
	return currentToken;
  }
  
  /**
   * It uses "currentToken" and "expectedTokenSequences" to generate a parse error message and returns it. If this object has been created due to a
   * parse error, and you do not catch it (it gets thrown from the parser) the correct error message gets displayed.
   */
  private static String initialise(Token currentToken, int[][] expectedTokenSequences, String[] tokenImage) {
    String eol = System.getProperty("line.separator", "\n");
    StringBuilder expected = new StringBuilder();
    int maxSize = 0;
    for (int[] expectedTokenSequence : expectedTokenSequences) {
      if (maxSize < expectedTokenSequence.length) {
        maxSize = expectedTokenSequence.length;
      }
      for (int anExpectedTokenSequence : expectedTokenSequence) {
        expected.append(tokenImage[anExpectedTokenSequence]).append(' ');
      }
      if (expectedTokenSequence[expectedTokenSequence.length - 1] != 0) {
        expected.append("...");
      }
      expected.append(eol).append("    ");
    }
    String retval = "Encountered \"";
    Token tok = currentToken.next;
    for (int i = 0; i < maxSize; i++) {
      if (i != 0)
        retval += " ";
      if (tok.kind == 0) {
        retval += tokenImage[0];
        break;
      }
      retval += " " + tokenImage[tok.kind];
      retval += " \"";
      retval += add_escapes(tok.image);
      retval += " \"";
      tok = tok.next;
    }
    retval += "\" at line " + currentToken.next.beginLine + ", column " + currentToken.next.beginColumn;
    retval += "." + eol;
    if (expectedTokenSequences.length == 1) {
      retval += "Was expecting:" + eol + "    ";
    } else {
      retval += "Was expecting one of:" + eol + "    ";
    }
    retval += expected.toString();
    return retval;
  }

  /**
   * The end of line string for this machine.
   */
  protected String eol = System.getProperty("line.separator", "\n");

  /**
   * Used to convert raw characters to their escaped version when these raw version cannot be used as part of an ASCII string literal.
   */
  private static String add_escapes(String str) {
    StringBuilder retval = new StringBuilder();
    char ch;
    for (int i = 0; i < str.length(); i++) {
      switch (str.charAt(i)) {
        case 0:
          continue;
        case '\b':
          retval.append("\\b");
          continue;
        case '\t':
          retval.append("\\t");
          continue;
        case '\n':
          retval.append("\\n");
          continue;
        case '\f':
          retval.append("\\f");
          continue;
        case '\r':
          retval.append("\\r");
          continue;
        case '\"':
          retval.append("\\\"");
          continue;
        case '\'':
          retval.append("\\\'");
          continue;
        case '\\':
          retval.append("\\\\");
          continue;
        default:
          if ((ch = str.charAt(i)) < 0x20 || ch > 0x7e) {
            String s = "0000" + Integer.toString(ch, 16);
            retval.append("\\u").append(s.substring(s.length() - 4, s.length()));
          } else {
            retval.append(ch);
          }
      }
    }
    return retval.toString();
  }

}
/*
 * JavaCC - OriginalChecksum=c67b0f8ee6c642900399352b33f90efd (do not edit this
 * line)
 */
