/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.format;

import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.measure.format.QuantityFormat;
import javax.measure.format.UnitFormat;
import javax.measure.spi.FormatService;
import tech.units.indriya.format.EBNFUnitFormat;
import tech.units.indriya.format.FormatBehavior;
import tech.units.indriya.format.LocalUnitFormat;
import tech.units.indriya.format.NumberDelimiterQuantityFormat;
import tech.units.indriya.format.SimpleQuantityFormat;
import tech.units.indriya.format.SimpleUnitFormat;
import tech.uom.lib.common.function.IntPrioritySupplier;

public class DefaultFormatService
implements FormatService,
IntPrioritySupplier {
    private static final int PRIO = 1000;
    private static final String DEFAULT_QUANTITY_FORMAT_NAME = "Simple";
    private static final String DEFAULT_UNIT_FORMAT_NAME = SimpleUnitFormat.Flavor.Default.name();
    private final Map<String, QuantityFormat> quantityFormats = new HashMap<String, QuantityFormat>();
    private final Map<String, UnitFormat> unitFormats = new HashMap<String, UnitFormat>();
    private static final NumberDelimiterQuantityFormat EBNF_QUANTITY_FORMAT = new NumberDelimiterQuantityFormat.Builder().setNumberFormat(NumberFormat.getInstance(Locale.ROOT)).setUnitFormat(EBNFUnitFormat.getInstance()).build();

    public DefaultFormatService() {
        this.unitFormats.put(DEFAULT_UNIT_FORMAT_NAME, SimpleUnitFormat.getInstance());
        this.unitFormats.put(SimpleUnitFormat.Flavor.ASCII.name(), SimpleUnitFormat.getInstance(SimpleUnitFormat.Flavor.ASCII));
        this.unitFormats.put("EBNF", EBNFUnitFormat.getInstance());
        this.unitFormats.put("Local", LocalUnitFormat.getInstance());
        this.quantityFormats.put(DEFAULT_QUANTITY_FORMAT_NAME, SimpleQuantityFormat.getInstance());
        this.quantityFormats.put("NumberDelimiter", NumberDelimiterQuantityFormat.getInstance());
        this.quantityFormats.put("EBNF", EBNF_QUANTITY_FORMAT);
        this.quantityFormats.put("Local", NumberDelimiterQuantityFormat.getInstance(FormatBehavior.LOCALE_SENSITIVE));
    }

    public QuantityFormat getQuantityFormat(String name) {
        return this.quantityFormats.get(name);
    }

    public QuantityFormat getQuantityFormat() {
        return this.getQuantityFormat(DEFAULT_QUANTITY_FORMAT_NAME);
    }

    public Set<String> getAvailableFormatNames(FormatService.FormatType type) {
        switch (type) {
            case QUANTITY_FORMAT: {
                return this.quantityFormats.keySet();
            }
        }
        return this.unitFormats.keySet();
    }

    public UnitFormat getUnitFormat(String formatName) {
        Objects.requireNonNull(formatName, "Format name required");
        return this.unitFormats.get(formatName);
    }

    public UnitFormat getUnitFormat() {
        return this.getUnitFormat(DEFAULT_UNIT_FORMAT_NAME);
    }

    public int getPriority() {
        return 1000;
    }

    public UnitFormat getUnitFormat(String name, String variant) {
        return this.getUnitFormat(name);
    }
}

